/*
 * Decompiled with CFR 0.152.
 */
package mkbrowser;

import java.io.IOException;
import java.lang.reflect.Field;
import java.net.CookieHandler;
import java.net.Proxy;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.concurrent.Worker;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Label;
import javafx.scene.control.MenuButton;
import javafx.scene.control.MenuItem;
import javafx.scene.control.ProgressBar;
import javafx.scene.control.TextField;
import javafx.scene.control.Tooltip;
import javafx.scene.image.Image;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.web.WebEngine;
import javafx.scene.web.WebEvent;
import javafx.scene.web.WebView;
import javafx.stage.Stage;
import javafx.util.Callback;
import javax.swing.SwingUtilities;
import main.Main;
import mkgethtml.Config;
import mkgethtml.Enumeration;
import models.LoginInfo;
import resource.text.Messages;
import sun.net.www.protocol.http.Handler;
import utils.CommonValue;

public class MiniBrowserController
implements Initializable {
    public String homeAddres = "https://google.com.vn";
    public static String openUrl = "https://google.com.vn";
    private static final String BLANK_IMAGE_LOC = "https://upload.wikimedia.org/wikipedia/commons/c/ce/Transparent.gif";
    private static final String IMAGE_MIME_TYPE_PREFIX = "image/";
    private Boolean isLoadImage = true;
    public static int MaxHistoryBackForward = 50;
    public String pageCode = "";
    ArrayList<String> ListAddress = new ArrayList();
    private int currentAddressIndex = -1;
    private Boolean isAddNewAddress = true;
    @FXML
    Button btnBackward;
    @FXML
    Button btnForward;
    @FXML
    Button btnRefresh;
    @FXML
    Button btnHome;
    @FXML
    Button btnGo;
    @FXML
    TextField txtAddress;
    @FXML
    WebView wvMain;
    @FXML
    MenuButton mnubFunction;
    @FXML
    MenuItem mnuSaveLoginInfo;
    @FXML
    MenuButton mnubSetting;
    @FXML
    MenuItem mnuEnableImage;
    @FXML
    Label lblStatus;
    @FXML
    ProgressBar progressBar;
    WebEngine engine;
    Boolean isInitSuccess = false;

    public void initialize(URL location, ResourceBundle resources) {
        this.init();
    }

    void init() {
        Object isLoadingObject = Config.get(Enumeration.EnumConfigKey.ISLOADIMAGE);
        if (isLoadingObject == null) {
            Config.put(Enumeration.EnumConfigKey.ISLOADIMAGE, Boolean.TRUE, true);
        } else {
            try {
                this.isLoadImage = Boolean.parseBoolean(isLoadingObject.toString());
            }
            catch (Exception e) {
                this.isLoadImage = true;
                Config.put(Enumeration.EnumConfigKey.ISLOADIMAGE, Boolean.TRUE, true);
            }
        }
        this.localized();
        this.engine = this.wvMain.getEngine();
        this.engine.setJavaScriptEnabled(true);
        this.engine.setUserAgent(CommonValue.USER_AGENT);
        this.txtAddress.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent event) {
                if (event.getCode() == KeyCode.ENTER) {
                    String url = MiniBrowserController.this.txtAddress.getText();
                    if ((url = url.trim()).contains(" ")) {
                        url = "https://www.google.com.vn/search?q=" + MiniBrowserController.this.txtAddress.getText().trim();
                    }
                    MiniBrowserController.this.isAddNewAddress = true;
                    MiniBrowserController.this.loadAddress(url);
                }
            }
        });
        this.txtAddress.setOnMouseClicked((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                MiniBrowserController.this.txtAddress.selectAll();
            }
        });
        this.btnBackward.setOnMouseClicked((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                MiniBrowserController miniBrowserController = MiniBrowserController.this;
                miniBrowserController.currentAddressIndex = miniBrowserController.currentAddressIndex - 1;
                if (MiniBrowserController.this.currentAddressIndex > -1 && MiniBrowserController.this.currentAddressIndex < MiniBrowserController.this.ListAddress.size()) {
                    MiniBrowserController.this.isAddNewAddress = false;
                    MiniBrowserController.this.loadAddress(MiniBrowserController.this.ListAddress.get(MiniBrowserController.this.currentAddressIndex));
                }
            }
        });
        this.btnForward.setOnMouseClicked((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                MiniBrowserController miniBrowserController = MiniBrowserController.this;
                miniBrowserController.currentAddressIndex = miniBrowserController.currentAddressIndex + 1;
                if (MiniBrowserController.this.currentAddressIndex > -1 && MiniBrowserController.this.currentAddressIndex < MiniBrowserController.this.ListAddress.size()) {
                    MiniBrowserController.this.isAddNewAddress = false;
                    MiniBrowserController.this.loadAddress(MiniBrowserController.this.ListAddress.get(MiniBrowserController.this.currentAddressIndex));
                }
            }
        });
        this.btnHome.setOnMouseClicked((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                MiniBrowserController.this.isAddNewAddress = true;
                MiniBrowserController.this.loadAddress(MiniBrowserController.this.homeAddres);
            }
        });
        this.btnRefresh.setOnMouseClicked((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                String url = MiniBrowserController.this.txtAddress.getText();
                if (url.trim() != "") {
                    MiniBrowserController.this.isAddNewAddress = false;
                    MiniBrowserController.this.loadAddress(url);
                } else {
                    MiniBrowserController.this.txtAddress.requestFocus();
                }
            }
        });
        this.btnGo.setOnMouseClicked((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                String url = MiniBrowserController.this.txtAddress.getText();
                if (url.trim() != "") {
                    MiniBrowserController.this.isAddNewAddress = true;
                    MiniBrowserController.this.loadAddress(url);
                } else {
                    MiniBrowserController.this.txtAddress.requestFocus();
                }
            }
        });
        this.mnuEnableImage.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                MiniBrowserController.this.isLoadImage = MiniBrowserController.this.isLoadImage == false;
                MiniBrowserController.this.handleLoadingImageOnBrowser();
                Config.put(Enumeration.EnumConfigKey.ISLOADIMAGE, MiniBrowserController.this.isLoadImage, true);
                if (MiniBrowserController.this.isLoadImage.booleanValue()) {
                    MiniBrowserController.this.mnuEnableImage.setText(Messages.getString("MKBrowser.fx.mnuDisableImage"));
                } else {
                    MiniBrowserController.this.mnuEnableImage.setText(Messages.getString("MKBrowser.fx.mnuEnableImage"));
                }
                String url = MiniBrowserController.this.txtAddress.getText();
                if (url.trim() != "") {
                    MiniBrowserController.this.isAddNewAddress = false;
                    MiniBrowserController.this.loadAddress(url);
                } else {
                    MiniBrowserController.this.txtAddress.requestFocus();
                }
            }
        });
        this.mnuSaveLoginInfo.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                Alert alert = new Alert(Alert.AlertType.CONFIRMATION);
                alert.setTitle(Messages.getString("MKBrowser.dialog.confirmLoggedTitle"));
                alert.setContentText(String.format(Messages.getString("MKBrowser.dialog.confirmLoggedAndSave"), MiniBrowserController.this.pageCode));
                alert.setHeaderText(null);
                alert.setResultConverter((Callback)new Callback<ButtonType, ButtonType>(){

                    public ButtonType call(ButtonType param) {
                        if (param != null && param.getButtonData() == ButtonBar.ButtonData.OK_DONE) {
                            CookieHandler cookies = CookieHandler.getDefault();
                            LinkedHashMap<String, List<String>> headers = new LinkedHashMap<String, List<String>>();
                            Map<Object, Object> cookiesMap = new LinkedHashMap();
                            try {
                                String location = (this).MiniBrowserController.this.engine.getLocation();
                                cookiesMap = cookies.get(new URI(location), headers);
                                List lstCookies = (List)cookiesMap.get("Cookie");
                                if (lstCookies.size() > 0) {
                                    LoginInfo loginInfo = new LoginInfo((this).MiniBrowserController.this.pageCode);
                                    loginInfo.setCookies((String)lstCookies.get(0));
                                    if (location.toLowerCase().contains((this).MiniBrowserController.this.pageCode.toLowerCase())) {
                                        Config.updateLoginInfo(loginInfo, (this).MiniBrowserController.this.pageCode);
                                    }
                                }
                            }
                            catch (IOException | URISyntaxException e) {
                                e.printStackTrace();
                            }
                        }
                        return param;
                    }
                });
                Stage stage = (Stage)alert.getDialogPane().getScene().getWindow();
                stage.getIcons().add((Object)new Image(this.getClass().getResource("/resource/box-16.png").toString()));
                alert.showAndWait();
            }
        });
        this.webEnginEvent();
        this.handleLoadingImageOnBrowser();
        this.isInitSuccess = true;
    }

    private void localized() {
        this.mnubFunction.setText(Messages.getString("MKBrowser.fx.mnubFunction"));
        this.mnuSaveLoginInfo.setText(Messages.getString("MKBrowser.fx.mnuSaveLoginInfo"));
        this.mnubSetting.setText(Messages.getString("MKBrowser.fx.mnubSetting"));
        if (this.isLoadImage.booleanValue()) {
            this.mnuEnableImage.setText(Messages.getString("MKBrowser.fx.mnuDisableImage"));
        } else {
            this.mnuEnableImage.setText(Messages.getString("MKBrowser.fx.mnuEnableImage"));
        }
        this.btnBackward.setTooltip(new Tooltip(Messages.getString("MKBrowser.btnBackward.toolTipText")));
        this.btnForward.setTooltip(new Tooltip(Messages.getString("MKBrowser.btnForward.toolTipText")));
        this.btnGo.setTooltip(new Tooltip(Messages.getString("MKBrowser.btnGo.toolTipText")));
        this.btnHome.setTooltip(new Tooltip(Messages.getString("MKBrowser.btnHome.toolTipText")));
        this.btnRefresh.setTooltip(new Tooltip(Messages.getString("MKBrowser.btnRefresh.toolTipText")));
        this.txtAddress.promptTextProperty().setValue(Messages.getString("MKBrowser.txtAddress.promtText"));
    }

    void webEnginEvent() {
        this.engine.titleProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, final String newValue) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Main.browser.setTitle(newValue);
                    }
                });
            }
        });
        this.engine.setOnStatusChanged((EventHandler)new EventHandler<WebEvent<String>>(){

            public void handle(WebEvent<String> event) {
                MiniBrowserController.this.lblStatus.setText((String)event.getData());
            }
        });
        this.engine.getLoadWorker().workDoneProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observableValue, Number oldValue, Number newValue) {
                MiniBrowserController.this.progressBar.setProgress((double)newValue.intValue());
            }
        });
        this.engine.getLoadWorker().exceptionProperty().addListener((ChangeListener)new ChangeListener<Throwable>(){

            public void changed(ObservableValue<? extends Throwable> o, Throwable old, Throwable value) {
                if (MiniBrowserController.this.engine.getLoadWorker().getState() == Worker.State.FAILED) {
                    MiniBrowserController.this.lblStatus.setText("Network error...!");
                }
            }
        });
        this.engine.locationProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> ov, String oldValue, final String newValue) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        (this).MiniBrowserController.this.txtAddress.setText(newValue);
                    }
                });
            }
        });
    }

    public void loadAddress(String url) {
        if (!(url = url.trim()).startsWith("http://") && !url.startsWith("https://")) {
            url = "http://" + url;
        }
        this.txtAddress.setText(url);
        this.engine.load(url);
        if (this.isAddNewAddress.booleanValue()) {
            this.currentAddressIndex = this.ListAddress.size();
            if (this.ListAddress.size() > MaxHistoryBackForward) {
                this.ListAddress.remove(0);
                --this.currentAddressIndex;
            }
            this.ListAddress.add(url);
            this.isAddNewAddress = false;
        }
        this.btnBackward.setDisable(true);
        this.btnForward.setDisable(true);
        if (this.currentAddressIndex > 0) {
            this.btnBackward.setDisable(false);
        }
        if (this.currentAddressIndex > -1 && this.currentAddressIndex < this.ListAddress.size() - 1) {
            this.btnForward.setDisable(false);
        }
        this.wvMain.requestFocus();
    }

    public void loadAddressOnFirst(final String url) {
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                while (!MiniBrowserController.this.isInitSuccess.booleanValue()) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        MiniBrowserController.this.loadAddress(url);
                    }
                });
            }
        });
        t.start();
    }

    void handleLoadingImageOnBrowser() {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                URLStreamHandlerFactory factory = new URLStreamHandlerFactory(){

                    @Override
                    public URLStreamHandler createURLStreamHandler(String protocol) {
                        if ("http".equals(protocol)) {
                            return new Handler(){

                                @Override
                                protected URLConnection openConnection(URL url, Proxy proxy) throws IOException {
                                    String[] fileParts = url.getFile().split("\\?");
                                    String contentType = URLConnection.guessContentTypeFromName(fileParts[0]);
                                    if (fileParts[0].endsWith(".svg")) {
                                        contentType = "image/svg";
                                    }
                                    if (contentType != null && contentType.startsWith(MiniBrowserController.IMAGE_MIME_TYPE_PREFIX)) {
                                        if (MiniBrowserController.this.isLoadImage.booleanValue()) {
                                            return super.openConnection(url, proxy);
                                        }
                                        return new URL(MiniBrowserController.BLANK_IMAGE_LOC).openConnection();
                                    }
                                    return super.openConnection(url, proxy);
                                }
                            };
                        }
                        return null;
                    }
                };
                try {
                    URL.setURLStreamHandlerFactory(factory);
                }
                catch (Error e) {
                    try {
                        Field factoryField = URL.class.getDeclaredField("factory");
                        factoryField.setAccessible(true);
                        factoryField.set(null, factory);
                    }
                    catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e1) {
                        e1.printStackTrace();
                    }
                }
            }
        });
    }
}

