/*
 * Decompiled with CFR 0.152.
 */
package mkgethtml;

import com.google.gson.JsonSyntaxException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import javafx.application.Platform;
import javax.swing.SwingUtilities;
import mkgethtml.Enumeration;
import models.LoginInfo;
import models.PageConfig;
import utils.CommonValue;
import utils.JSONUtil;
import utils.XMLParse;

public class Config {
    private static HashMap<Enumeration.EnumConfigKey, Object> configDataSetting = new HashMap();
    private static ArrayList<PageConfig> configHost = new ArrayList();
    private static ArrayList<LoginInfo> loginDataConfig = new ArrayList();

    public static void addHost(PageConfig p) {
        configHost.add(p);
        Config.saveConfig(Enumeration.ConfigType.DataSite);
    }

    public static void deleteHostByPageCode(String pageCode) {
        if (configHost.contains(new PageConfig(pageCode))) {
            configHost.remove(new PageConfig(pageCode));
            Config.saveConfig(Enumeration.ConfigType.DataSite);
        }
    }

    public static void editHost(PageConfig replace, PageConfig replacement) {
        int indexOfPage = configHost.indexOf(replace);
        if (indexOfPage > -1) {
            configHost.set(indexOfPage, replacement);
            Config.saveConfig(Enumeration.ConfigType.DataSite);
        }
    }

    public static ArrayList<PageConfig> getAllHostConfig() {
        return configHost;
    }

    public static PageConfig getHostConfigByPageCode(String pageCode) {
        PageConfig p = new PageConfig(pageCode);
        if (configHost.contains(p)) {
            return configHost.get(configHost.indexOf(p));
        }
        return null;
    }

    public static int isSupportHost(String url) {
        PageConfig check = new PageConfig(url.toLowerCase());
        for (PageConfig pageConfig : configHost) {
            if (!check.equals(pageConfig)) continue;
            if (pageConfig.getIsManualGet().booleanValue()) {
                return -1;
            }
            return 1;
        }
        return 0;
    }

    public static void updateLoginInfo(LoginInfo loginInfo, String pageCode) {
        int indexOfLogin = loginDataConfig.indexOf(loginInfo);
        if (indexOfLogin > -1) {
            loginDataConfig.set(indexOfLogin, loginInfo);
        } else {
            loginDataConfig.add(loginInfo);
        }
        configDataSetting.put(Enumeration.EnumConfigKey.LOGIN_INFO, loginDataConfig);
        Config.saveConfig(Enumeration.ConfigType.Setting);
    }

    public static LoginInfo getLoginInfoByPageCode(String pageCode) {
        LoginInfo loginInfo = new LoginInfo(pageCode);
        if (loginDataConfig.contains(loginInfo)) {
            return loginDataConfig.get(loginDataConfig.indexOf(loginInfo));
        }
        return null;
    }

    static void createDefaultConfig(Boolean isReconfig) {
        Config.createDefaultHostConfig(isReconfig);
        Config.createDefaultUserConfig(isReconfig);
    }

    static void createDefaultUserConfig(Boolean isReconfig) {
        HashMap<Enumeration.EnumConfigKey, Object> config = new HashMap<Enumeration.EnumConfigKey, Object>();
        String configPath = Config.getConfigPathByConfigType(Enumeration.ConfigType.Setting);
        try {
            File file = new File(configPath);
            config.put(Enumeration.EnumConfigKey.LANGUAGE, "vi");
            config.put(Enumeration.EnumConfigKey.RECENT_FOLDER, "D:");
            config.put(Enumeration.EnumConfigKey.LINE_HEIGHT, 16);
            config.put(Enumeration.EnumConfigKey.SLEEP_TIME, 30);
            config.put(Enumeration.EnumConfigKey.TIME_OUT, 60);
            config.put(Enumeration.EnumConfigKey.MAXCONNECTION, 4);
            config.put(Enumeration.EnumConfigKey.EBOOKCREATOR, "mkbyme");
            config.put(Enumeration.EnumConfigKey.CONVERTER, "");
            config.put(Enumeration.EnumConfigKey.SOURCE, "");
            config.put(Enumeration.EnumConfigKey.AUTHOR, "");
            config.put(Enumeration.EnumConfigKey.EBOOKNAME, "");
            config.put(Enumeration.EnumConfigKey.STATUS, "");
            config.put(Enumeration.EnumConfigKey.INFO, "<br/>Created Tools:<a href =\"https://sourceforge.net/projects/gethtmlfromurl/\"> " + CommonValue.getAppName() + "</a>");
            config.put(Enumeration.EnumConfigKey.ENCODING, "UTF-8");
            Boolean isSave = false;
            if (!file.exists()) {
                file.createNewFile();
                isSave = true;
            } else if (isReconfig.booleanValue()) {
                isSave = true;
            }
            if (isSave.booleanValue()) {
                XMLParse.saveConfig(configPath, config);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    static void createDefaultHostConfig(Boolean isReconfig) {
        String configPath = Config.getConfigPathByConfigType(Enumeration.ConfigType.DataSite);
        try {
            File file = new File(configPath);
            ArrayList<PageConfig> listPageConfig = new ArrayList<PageConfig>();
            PageConfig p = new PageConfig();
            p.setPageCode("truyenfull.vn");
            p.setIsVietNameseHost(true);
            p.setPagingPattern("trang-");
            p.setCssQueryGetListChapter("#list-chapter .row ul{start=0&end=n}");
            p.setCssQueryGetChapterTitle(".row .chapter-title");
            p.setCssQueryGetChapterContent(".row .chapter-c");
            p.setUrlPageTest("http://truyenfull.vn/dai-hoc-la-gi-inspired-by-a-true-story/");
            p.setOverMaxSizePageCountState(Enumeration.OverMaxSizePageCountState.MOVE_TO_LAST);
            String guide = "1. Truy c\u1eadp trang http://truyenfull.vn\n2. Ch\u1ecdn 1 truy\u1ec7n nh\u1ea5n v\u00e0 m\u1edf \u0111\u1ecdc truy\u1ec7n\n3. Sao ch\u00e9p \u0111\u01b0\u1eddng d\u1eabn truy\u1ec7n \u1edf thanh \u0111\u1ecba ch\u1ec9 tr\u00ecnh duy\u1ec7t\n4. D\u00e1n v\u00e0o URL tr\u00ean ph\u1ea7n m\u1ec1m\n\nD\u1ea1ng URL:\nhttp://truyenfull.vn/[T\u00caN_TRUY\u1ec6N]/\nV\u00ed d\u1ee5:\nhttp://truyenfull.vn/dai-hoc-la-gi-inspired-by-a-true-story/\nl\u00e0 h\u1ee3p l\u1ec7\n------\nNh\u1ea5n T\u1ea3i xu\u1ed1ng.";
            p.setTextGuide(guide);
            listPageConfig.add(p);
            Boolean isSave = false;
            if (!file.exists()) {
                file.createNewFile();
                isSave = true;
            } else if (isReconfig.booleanValue()) {
                isSave = true;
            }
            if (isSave.booleanValue()) {
                try {
                    JSONUtil.saveConfig(configPath, listPageConfig);
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static Object get(Enumeration.EnumConfigKey key) {
        Config.loadConfig();
        return configDataSetting.get((Object)key);
    }

    public static void initConfig() {
        Config.createDefaultConfig(false);
        Config.loadConfig();
        CommonValue.initValue();
    }

    private static void loadConfig() {
        if (configDataSetting.isEmpty()) {
            try {
                configDataSetting = (HashMap)XMLParse.loadConfig(Config.getConfigPathByConfigType(Enumeration.ConfigType.Setting));
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        }
        if ((loginDataConfig = (ArrayList)configDataSetting.get((Object)Enumeration.EnumConfigKey.LOGIN_INFO)) == null) {
            loginDataConfig = new ArrayList();
        }
        if (configHost.isEmpty()) {
            try {
                configHost = JSONUtil.loadConfig(Config.getConfigPathByConfigType(Enumeration.ConfigType.DataSite));
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (JsonSyntaxException e) {
                try {
                    Config.createDefaultHostConfig(true);
                    Config.loadConfig();
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        }
    }

    public static void put(final Enumeration.EnumConfigKey key, final Object value) {
        if (Platform.isFxApplicationThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    configDataSetting.put(key, value);
                }
            });
        } else {
            configDataSetting.put(key, value);
        }
    }

    public static void put(final Enumeration.EnumConfigKey key, final Object value, final Boolean isSave) {
        if (Platform.isFxApplicationThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    configDataSetting.put(key, value);
                    if (isSave.booleanValue()) {
                        Config.saveConfig(Enumeration.ConfigType.Setting);
                    }
                }
            });
        } else {
            configDataSetting.put(key, value);
            if (isSave.booleanValue()) {
                Config.saveConfig(Enumeration.ConfigType.Setting);
            }
        }
    }

    public static void reConfig() {
        Config.createDefaultConfig(true);
        if (configDataSetting != null) {
            configDataSetting.clear();
        }
        if (loginDataConfig != null) {
            loginDataConfig.clear();
        }
        Config.loadConfig();
    }

    public static void remove(Enumeration.EnumConfigKey key) {
        if (configDataSetting != null) {
            configDataSetting.remove((Object)key);
        }
    }

    public static void saveConfig(Enumeration.ConfigType configType) {
        String configPath = Config.getConfigPathByConfigType(configType);
        File f = new File(configPath);
        try {
            if (!f.exists()) {
                f.createNewFile();
            }
            switch (configType) {
                case DataSite: {
                    JSONUtil.saveConfig(configPath, configHost);
                    break;
                }
                case Setting: {
                    XMLParse.saveConfig(configPath, configDataSetting);
                    break;
                }
                default: {
                    JSONUtil.saveConfig(configPath, configHost);
                    break;
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static String getConfigPathByConfigType(Enumeration.ConfigType configType) {
        String ret = "";
        switch (configType) {
            case DataSite: {
                ret = CommonValue.CONFIG_DATASITE;
                break;
            }
            case Setting: {
                ret = CommonValue.CONFIG_USER_SETTING;
                break;
            }
            default: {
                ret = CommonValue.CONFIG_DATASITE;
            }
        }
        return ret;
    }
}

