/*
 * Decompiled with CFR 0.152.
 */
package mkgethtml;

import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JLabel;
import javax.swing.JTextArea;
import mkgethtml.Config;
import mkgethtml.Enumeration;
import mkgethtml.GetHtmlCss;
import models.Chapter;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import resource.text.Messages;
import utils.CommonExceptionHandle;
import utils.CommonValue;
import utils.UrlHandler;

public class GetHtmlCsMix {
    public static Chapter getChapterTitleAndContentOfForum(int id, String chapterUrl, String cssChapterTitle, String cssChapterContent, String cssRemoveContent, Boolean isEnableChapterSign) {
        Chapter back = new Chapter();
        Document htmlPage = null;
        try {
            htmlPage = Jsoup.connect(chapterUrl).userAgent("Mozilla/5.0 (Macintosh; Intel Mac OS X 10_11_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/45.0.2454.101 Safari/537.36").timeout(CommonValue.TIME_OUT * 1000).get();
        }
        catch (Exception e) {
            return back;
        }
        Elements content = htmlPage.select(cssChapterContent);
        if (content == null) {
            return back;
        }
        StringBuilder sb = new StringBuilder();
        Elements imgs = content.select("img");
        int imgsSize = imgs.size();
        htmlPage.children().stream().close();
        int startPos = 0;
        int lastPos = -1;
        if (imgsSize > 0) {
            sb.append(content.html());
            int i = 0;
            while (i < imgs.size()) {
                lastPos = sb.indexOf("<img", startPos);
                String strInsert = String.format(Messages.getGlobalString("log.viewImageOfChapter"), ((Element)imgs.get(i)).attr("src").toString(), i + 1);
                if (lastPos > -1) {
                    sb.insert(lastPos, strInsert);
                }
                startPos = lastPos + strInsert.length() + 10;
                ++i;
            }
            htmlPage = Jsoup.parse(sb.toString());
        }
        if (imgsSize > 0) {
            htmlPage = GetHtmlCss.filterHtml(htmlPage, cssRemoveContent);
            content = htmlPage.select("body").first().children();
        } else {
            content = GetHtmlCss.filterHtml(content, cssRemoveContent);
        }
        sb = new StringBuilder();
        StringBuilder sbTitle = new StringBuilder();
        int spaceID = id * 250 + 5;
        int i = 0;
        if (imgs.size() > 0) {
            sb.append(Messages.getGlobalString("log.chapterHasImage"));
        }
        for (Element element : content) {
            String title = CommonValue.getAnchorIDandTitle(spaceID, String.format(Messages.getGlobalString("log.page"), id + 1, ++i));
            sbTitle.append(title);
            sb.append(CommonValue.getIDandTitleString(spaceID, String.format(Messages.getGlobalString("log.page"), id + 1, i)));
            sb.append(element.html());
            ++spaceID;
        }
        back.setTitle(sbTitle.toString());
        back.setContent(sb.toString());
        return back;
    }

    public static Chapter getChapterTitleAndContentSSTruyen(int id, String chapterUrl, String cssSelecTitle, String cssSelectContent, Boolean isEnableChapterSignal) {
        Chapter back = new Chapter();
        Document htmlPage = null;
        try {
            htmlPage = Jsoup.connect(chapterUrl).userAgent(CommonValue.USER_AGENT).timeout(CommonValue.TIME_OUT * 1000).get();
        }
        catch (Exception e) {
            return back;
        }
        Elements content = htmlPage.select(cssSelectContent);
        if (content == null) {
            return back;
        }
        String contentStr = content.html().replaceAll("\\;?var", "#");
        String[] arr = contentStr.split("#");
        String chapterID = arr[1].split("=")[1].trim();
        String time = arr[2].split("=")[1].trim();
        time = time.replaceAll("[\\-\\:\\s\\\"]", "");
        String urlParam = "http://sstruyen.com/doc-truyen/index.php?ajax=ct&id=" + chapterID + "&t=" + time;
        try {
            content = Jsoup.connect(urlParam).userAgent(CommonValue.USER_AGENT).get().getAllElements();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Elements imgs = content.select("img");
        htmlPage.children().stream().close();
        StringBuilder sb = new StringBuilder();
        int startPos = 0;
        int lastPos = -1;
        sb.append(content.toString());
        int i = 0;
        while (i < imgs.size()) {
            lastPos = sb.indexOf("<img", startPos);
            String strInsert = String.format(Messages.getGlobalString("log.viewImageOfChapter"), ((Element)imgs.get(i)).attr("src").toString(), i + 1);
            if (lastPos > -1) {
                sb.insert(lastPos, strInsert);
            }
            startPos = lastPos + strInsert.length() + 10;
            ++i;
        }
        if (isEnableChapterSignal.booleanValue()) {
            if (htmlPage.select(cssSelecTitle).size() == 0) {
                back.setTitle(CommonValue.getChapterNameWithSignal(id + 1, ""));
            } else {
                back.setTitle(CommonValue.getChapterNameWithSignal(id + 1, htmlPage.select(cssSelecTitle).first().text().trim()));
            }
        } else if (!htmlPage.select(cssSelecTitle).isEmpty()) {
            back.setTitle(htmlPage.select(cssSelecTitle).first().text().trim());
        } else {
            back.setTitle("");
        }
        back.setContent(String.valueOf(CommonValue.getIDandTitleString(id, back.getTitle())) + sb.toString());
        if (imgs.size() > 0) {
            back.setContent(String.valueOf(CommonValue.getIDandTitleString(id, back.getTitle())) + Messages.getGlobalString("log.chapterHasImage") + sb.toString());
        }
        return back;
    }

    /*
     * WARNING - void declaration
     */
    public static String getContentFromAjaxRequest(String url, String urlParameters, HashMap<String, String> requestHeaders, String method) throws IOException {
        byte[] postData = urlParameters.getBytes(StandardCharsets.UTF_8);
        URL u = new URL(url);
        HttpURLConnection conn = (HttpURLConnection)u.openConnection();
        conn.setDoOutput(true);
        conn.setInstanceFollowRedirects(false);
        conn.setRequestMethod(method);
        conn.setRequestProperty("User-Agent", CommonValue.USER_AGENT);
        if (requestHeaders != null) {
            for (String string : requestHeaders.keySet()) {
                conn.setRequestProperty(string, requestHeaders.get(string));
            }
        }
        conn.setUseCaches(false);
        Throwable throwable = null;
        Iterator<String> iterator = null;
        try (DataOutputStream wr = new DataOutputStream(conn.getOutputStream());){
            wr.write(postData);
        }
        catch (Throwable throwable2) {
            void var7_13;
            if (throwable == null) {
                Throwable throwable3 = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw var7_13;
        }
        conn.connect();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(conn.getInputStream(), Config.get(Enumeration.EnumConfigKey.ENCODING).toString()));
        String tempReader = "";
        StringBuilder sb = new StringBuilder();
        while ((tempReader = bufferedReader.readLine()) != null) {
            sb.append(tempReader);
            sb.append("\r\n");
        }
        bufferedReader.close();
        conn.disconnect();
        return sb.toString();
    }

    public static ArrayList<String> getListChaptersOnPageTruyenCV(String url, String cssQuery) throws IOException {
        Document htmlPage = null;
        ArrayList<String> listChapter = new ArrayList<String>();
        try {
            htmlPage = Jsoup.connect(url).userAgent(CommonValue.USER_AGENT).timeout(CommonValue.TIME_OUT * 1000).get();
        }
        catch (Exception e) {
            CommonExceptionHandle.HandleException(e, "L\u1ea5y th\u00f4ng tin truy\u1ec7n tr\u00ean truyencv th\u1ea5t b\u1ea1i");
            return listChapter;
        }
        String type = url.replaceAll("(http:\\/\\/truyencv.com)", "");
        type = type.replaceAll("[\\-\\/]", " ").trim();
        String media_id = htmlPage.select(cssQuery).first().attr("onclick");
        media_id = media_id.split("[(,]")[1];
        String ajaxUrl = "http://truyencv.com/index.php";
        String urlParameters = "showChapter=1&media_id=" + media_id + "&number=9999&page=1&type=" + type;
        HashMap<String, String> requestHeaders = new HashMap<String, String>();
        requestHeaders.put("Host", "truyencv.com");
        requestHeaders.put("Origin", "http://truyencv.com");
        htmlPage = Jsoup.parse(GetHtmlCsMix.getContentFromAjaxRequest(ajaxUrl, urlParameters, null, "POST"));
        htmlPage.select("a").forEach(a -> listChapter.add(a.attr("href").toString()));
        return listChapter;
    }

    public static Element getTotalPageOfForum(Document docHTML, String txtUrl, String cssDivListChapter, String pagingPattern, JLabel lblStatus, JTextArea txtLog) throws IOException {
        String totalPageRegex = "";
        String totalPageCss = cssDivListChapter;
        String pageingPatternTmp = "";
        Element listChapter = docHTML.createElement("div");
        lblStatus.setText(Messages.getGlobalString("lblStatus.leechingTotalPage"));
        if (totalPageCss.contains(";")) {
            totalPageCss = cssDivListChapter.substring(0, cssDivListChapter.indexOf(";"));
            totalPageRegex = cssDivListChapter.substring(cssDivListChapter.indexOf(";") + 1);
        }
        int totalPageInt = 1;
        String lastPageLink = docHTML.select(totalPageCss).first().attr("href");
        Pattern pattern = Pattern.compile(totalPageRegex);
        Matcher matcher = pattern.matcher(lastPageLink);
        if (matcher.find()) {
            try {
                totalPageInt = Integer.parseInt(matcher.group(0).replaceAll("\\D", ""));
                txtLog.append(String.format(Messages.getGlobalString("txtLog.totalPage"), totalPageInt));
                txtLog.append(String.format(Messages.getGlobalString("txtLog.addLink"), txtUrl));
                if (pagingPattern.contains(";")) {
                    pageingPatternTmp = pagingPattern.substring(0, pagingPattern.indexOf(";"));
                }
                listChapter.appendChild(docHTML.createElement("a").attr("href", txtUrl));
                int i = 1;
                while (i < totalPageInt) {
                    String urlTemp = String.valueOf(txtUrl) + pageingPatternTmp + (i + 1);
                    if (pagingPattern.contains("{")) {
                        urlTemp = pageingPatternTmp.contains("-") ? UrlHandler.getPagePatternUrl(pagingPattern, txtUrl, pageingPatternTmp.replaceFirst("\\{[\\w\\W]*\\}", String.valueOf(i))) : UrlHandler.getPagePatternUrl(pagingPattern, txtUrl, pageingPatternTmp.replaceFirst("\\{\\w*\\}", String.valueOf(i + 1)));
                    }
                    listChapter.appendChild(docHTML.createElement("a").attr("href", urlTemp));
                    lblStatus.setText(String.format(Messages.getGlobalString("txtLog.addLink"), urlTemp.length() > 30 ? urlTemp.substring(0, 30) : urlTemp));
                    txtLog.append(String.format(Messages.getGlobalString("txtLog.addLink"), urlTemp));
                    ++i;
                }
            }
            catch (NumberFormatException e) {
                totalPageInt = 1;
                e.printStackTrace();
            }
        }
        return listChapter;
    }

    public static ArrayList<String> getListChaptersOnPageWikiDich(String url, String cssQuery, Boolean isUseJsoupGet) throws IOException {
        Document htmlPage = null;
        ArrayList<String> listChapter = new ArrayList<String>();
        try {
            try {
                htmlPage = Jsoup.connect(url).userAgent(CommonValue.USER_AGENT).timeout(CommonValue.TIME_OUT * 1000).get();
            }
            catch (Exception e) {
                CommonExceptionHandle.HandleException(e, "L\u1ea5y th\u00f4ng tin truy\u1ec7n tr\u00ean wikidich th\u1ea5t b\u1ea1i");
                return listChapter;
            }
            String bookId = htmlPage.getElementById("bookId").val();
            Elements paging = htmlPage.select("[data-start]").size() > 1 ? htmlPage.select("[data-start]") : null;
            String ajaxUrl = "http://wikidich.com/book/index";
            String templateParas = "?bookId=%s&start=%d&size=%d";
            if (paging != null) {
                for (Element el : paging) {
                    int start = Integer.parseInt(el.attr("data-start"));
                    int size = Integer.parseInt(el.attr("data-size"));
                    String tempUrl = String.valueOf(ajaxUrl) + String.format(templateParas, bookId, start, size);
                    htmlPage = Jsoup.parse(GetHtmlCss.getHtmlStringFromURLbyCharset(tempUrl, isUseJsoupGet));
                    htmlPage.select("a.truncate").forEach(a -> {
                        String link = a.attr("href").toString();
                        if (link.length() < 5 && a.hasAttr("data-href")) {
                            link = a.attr("data-href").toString();
                        }
                        listChapter.add(link);
                    });
                    htmlPage.children().stream().close();
                }
            } else {
                String tempUrl = String.valueOf(ajaxUrl) + String.format(templateParas, bookId, 0, 501);
                htmlPage = Jsoup.parse(GetHtmlCss.getHtmlStringFromURLbyCharset(tempUrl, isUseJsoupGet));
                htmlPage.select("a.truncate").forEach(a -> {
                    String link = a.attr("href").toString();
                    if (link.length() < 5 && a.hasAttr("data-href")) {
                        link = a.attr("data-href").toString();
                    }
                    listChapter.add(link);
                });
                htmlPage.children().stream().close();
            }
        }
        catch (Exception e1) {
            CommonExceptionHandle.HandleException(e1, "L\u1ea5y th\u00f4ng tin truy\u1ec7n tr\u00ean wikidich th\u1ea5t b\u1ea1i");
            e1.printStackTrace();
        }
        return listChapter;
    }

    public static ArrayList<String> getListChaptersOnPageTruyenTangThuVien(String url, String cssQuery, Boolean isUseJsoupGet) throws IOException {
        Document htmlPage = null;
        ArrayList<String> listChapter = new ArrayList<String>();
        try {
            try {
                htmlPage = Jsoup.connect(url).userAgent(CommonValue.USER_AGENT).timeout(CommonValue.TIME_OUT * 1000).get();
            }
            catch (Exception e) {
                CommonExceptionHandle.HandleException(e, "L\u1ea5y th\u00f4ng tin truy\u1ec7n tr\u00ean truyen.tangthuvien.com th\u1ea5t b\u1ea1i");
                return listChapter;
            }
            String bookId = htmlPage.getElementsByAttributeValue("name", "story_id").val();
            String ajaxUrl = "https://truyen.tangthuvien.vn/story/chapters";
            String templateParas = "?story_id=%s&chapter_id=1";
            String tempUrl = String.valueOf(ajaxUrl) + String.format(templateParas, bookId);
            htmlPage = Jsoup.parse(GetHtmlCss.getHtmlStringFromURLbyCharset(tempUrl, false));
            htmlPage.select("a").forEach(a -> {
                String link = a.attr("href").toString();
                listChapter.add(link);
            });
            htmlPage.children().stream().close();
        }
        catch (Exception e1) {
            CommonExceptionHandle.HandleException(e1, "L\u1ea5y th\u00f4ng tin truy\u1ec7n tr\u00ean truyen.tangthuvien.com th\u1ea5t b\u1ea1i");
            e1.printStackTrace();
        }
        return listChapter;
    }

    public static Chapter getChapterTitleTangThuCacDotCom(String storyUrl, int index, String chapterUrl, String cssChapterTitle, String cssChapterContent, String cssRemoveContent, Boolean isEnableChapterSign) throws IOException {
        Chapter back = new Chapter();
        Document htmlPage = null;
        try {
            htmlPage = Jsoup.connect(chapterUrl).userAgent(CommonValue.USER_AGENT).timeout(CommonValue.TIME_OUT * 1000).get();
            String title = htmlPage.select(cssChapterTitle).html();
            if (storyUrl.endsWith("/")) {
                storyUrl = storyUrl.substring(0, storyUrl.length() - 1);
            }
            storyUrl = storyUrl.replace("/muc-luc", "");
            String id = storyUrl.substring(storyUrl.lastIndexOf("/") + 1);
            String ajaxUrl = "https://tangthucac.com/chapter/" + id + "/";
            String templateParas = "id=%s-%d";
            templateParas = String.format(templateParas, id, index);
            HashMap<String, String> requestHeaders = new HashMap<String, String>();
            requestHeaders.put("Host", "tangthucac.com");
            requestHeaders.put("Origin", "https://tangthucac.com");
            htmlPage = Jsoup.parse(GetHtmlCsMix.getContentFromAjaxRequest(ajaxUrl, templateParas, requestHeaders, "POST"));
            Elements content = htmlPage.select("body");
            Elements imgs = content.select("img");
            StringBuilder sb = new StringBuilder();
            int startPos = 0;
            int lastPos = -1;
            sb.append(content.toString());
            int i = 0;
            while (i < imgs.size()) {
                lastPos = sb.indexOf("<img", startPos);
                String strInsert = String.format(Messages.getGlobalString("log.viewImageOfChapter"), ((Element)imgs.get(i)).attr("src").toString(), i + 1);
                if (lastPos > -1) {
                    sb.insert(lastPos, strInsert);
                }
                startPos = lastPos + strInsert.length() + 10;
                ++i;
            }
            content = Jsoup.parse(sb.toString().replaceAll("<br>\n<br>\n<br>", "")).select("body");
            content = GetHtmlCss.filterHtml(content, cssRemoveContent);
            if (isEnableChapterSign.booleanValue()) {
                if (title == "") {
                    back.setTitle(CommonValue.getChapterNameWithSignal(index - 1, ""));
                } else {
                    back.setTitle(CommonValue.getChapterNameWithSignal(index - 1, title));
                }
            } else if (title != "") {
                back.setTitle(title);
            } else {
                back.setTitle("");
            }
            back.setContent(String.valueOf(CommonValue.getIDandTitleString(index - 1, back.getTitle())) + content.html());
            if (imgs.size() > 0) {
                back.setContent(String.valueOf(CommonValue.getIDandTitleString(index, back.getTitle())) + Messages.getGlobalString("log.chapterHasImage") + content.html());
            }
        }
        catch (Exception e) {
            CommonExceptionHandle.HandleException(e, "L\u1ea5y th\u00f4ng tin truy\u1ec7n tr\u00ean tangthucac.com th\u1ea5t b\u1ea1i");
            e.printStackTrace();
        }
        return back;
    }
}

