/*
 * Decompiled with CFR 0.152.
 */
package mkgethtml;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import mkgethtml.Enumeration;
import models.PageConfig;
import utils.CommonValue;
import utils.JSONUtil;
import utils.XMLParse;

public class HostConfig {
    private static ArrayList<PageConfig> configHost;

    public static void addHost(PageConfig p) {
        configHost.add(p);
        HostConfig.saveConfig(Enumeration.ConfigType.DataSite);
    }

    public static void deleteHostByPageCode(String pageCode) {
        if (configHost.contains(new PageConfig(pageCode))) {
            configHost.remove(new PageConfig(pageCode));
            HostConfig.saveConfig(Enumeration.ConfigType.DataSite);
        }
    }

    public static void editHost(PageConfig replace, PageConfig replacement) {
        if (configHost.contains(replace)) {
            configHost.set(configHost.indexOf(replace), replacement);
            HostConfig.saveConfig(Enumeration.ConfigType.DataSite);
        }
    }

    static void createDefaultConfig(Boolean isReconfig) {
        HostConfig.createDefaultHostConfig(isReconfig);
        HostConfig.createDefaultUserConfig(isReconfig);
    }

    static void createDefaultUserConfig(Boolean isReconfig) {
        HashMap<Enumeration.EnumConfigKey, Object> config = new HashMap<Enumeration.EnumConfigKey, Object>();
        String configPath = HostConfig.getConfigPathByConfigType(Enumeration.ConfigType.Setting);
        try {
            File file = new File(configPath);
            config.put(Enumeration.EnumConfigKey.LANGUAGE, "vi");
            config.put(Enumeration.EnumConfigKey.RECENT_FOLDER, "D:");
            config.put(Enumeration.EnumConfigKey.LINE_HEIGHT, 16);
            config.put(Enumeration.EnumConfigKey.SLEEP_TIME, 30);
            config.put(Enumeration.EnumConfigKey.TIME_OUT, 60);
            config.put(Enumeration.EnumConfigKey.MAXCONNECTION, 4);
            config.put(Enumeration.EnumConfigKey.EBOOKCREATOR, "mkbyme");
            config.put(Enumeration.EnumConfigKey.CONVERTER, "");
            config.put(Enumeration.EnumConfigKey.SOURCE, "");
            config.put(Enumeration.EnumConfigKey.AUTHOR, "");
            config.put(Enumeration.EnumConfigKey.EBOOKNAME, "");
            config.put(Enumeration.EnumConfigKey.STATUS, "");
            config.put(Enumeration.EnumConfigKey.INFO, "<br/>Created Tools:<a href =\"https://sourceforge.net/projects/gethtmlfromurl/\"> " + CommonValue.getAppName() + "</a>");
            config.put(Enumeration.EnumConfigKey.ENCODING, "UTF-8");
            Boolean isSave = false;
            if (!file.exists()) {
                file.createNewFile();
                isSave = true;
            } else if (isReconfig.booleanValue()) {
                isSave = true;
            }
            if (isSave.booleanValue()) {
                XMLParse.saveConfig(configPath, config);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    static void createDefaultHostConfig(Boolean isReconfig) {
        String configPath = HostConfig.getConfigPathByConfigType(Enumeration.ConfigType.DataSite);
        try {
            File file = new File(configPath);
            ArrayList<PageConfig> listPageConfig = new ArrayList<PageConfig>();
            PageConfig p = new PageConfig();
            p.setPageCode("truyenfull.vn");
            p.setPagingPattern("trang-");
            p.setCssQueryGetListChapter("#list-chapter .row ul{start=0&end=n}");
            p.setCssQueryGetChapterTitle(".row .chapter-title");
            p.setCssQueryGetChapterContent(".row .chapter-c");
            p.setUrlPageTest("http://truyenfull.vn/dai-hoc-la-gi-inspired-by-a-true-story/");
            p.setOverMaxSizePageCountState(Enumeration.OverMaxSizePageCountState.MOVE_TO_LAST);
            listPageConfig.add(p);
            Boolean isSave = false;
            if (!file.exists()) {
                file.createNewFile();
                isSave = true;
            } else if (isReconfig.booleanValue()) {
                isSave = true;
            }
            if (isSave.booleanValue()) {
                try {
                    JSONUtil.saveConfig(configPath, listPageConfig);
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static ArrayList<PageConfig> getAllHostConfig() {
        return configHost;
    }

    public static PageConfig getHostConfigByPageCode(String pageCode) {
        PageConfig p = new PageConfig(pageCode);
        if (configHost.contains(p)) {
            return configHost.get(configHost.indexOf(p));
        }
        return null;
    }

    private static void loadConfig() {
        if (configHost.isEmpty()) {
            try {
                configHost = JSONUtil.loadConfig(HostConfig.getConfigPathByConfigType(Enumeration.ConfigType.DataSite));
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        }
    }

    public static void initConfig() {
        HostConfig.createDefaultConfig(false);
        HostConfig.loadConfig();
        CommonValue.initValue();
    }

    public static int isSupport(String url) {
        PageConfig check = new PageConfig(url.toLowerCase());
        for (PageConfig pageConfig : configHost) {
            if (!check.equals(pageConfig)) continue;
            if (pageConfig.getIsManualGet().booleanValue()) {
                return -1;
            }
            return 1;
        }
        return 0;
    }

    public static void reConfig() {
        HostConfig.createDefaultConfig(true);
        HostConfig.loadConfig();
    }

    public static void saveConfig(Enumeration.ConfigType configType) {
        String configPath = HostConfig.getConfigPathByConfigType(configType);
        File f = new File(configPath);
        try {
            if (!f.exists()) {
                f.createNewFile();
            }
            switch (configType) {
                case DataSite: {
                    JSONUtil.saveConfig(configPath, configHost);
                    break;
                }
                default: {
                    JSONUtil.saveConfig(configPath, configHost);
                    break;
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static String getConfigPathByConfigType(Enumeration.ConfigType configType) {
        String ret = "";
        switch (configType) {
            case DataSite: {
                ret = CommonValue.CONFIG_DATASITE;
                break;
            }
            case Setting: {
                ret = CommonValue.CONFIG_USER_SETTING;
                break;
            }
            default: {
                ret = CommonValue.CONFIG_DATASITE;
            }
        }
        return ret;
    }
}

