/*
 * Decompiled with CFR 0.152.
 */
package models;

import mkgethtml.Enumeration;
import resource.text.Messages;
import utils.UrlHandler;

public class PageConfig {
    private String pageCode;
    private String pagingPattern;
    private String cssQueryGetListChapter;
    private String cssQueryGetChapterTitle;
    private String cssQueryGetChapterContent;
    private String urlPageTest;
    private String textGuide;
    private String cssFilter;
    private Boolean isManualGet;
    private Boolean isChapterLinkAsolute;
    private Boolean isEnableChapterSign;
    private Boolean isRevertChapterList = false;
    private Boolean isForumType = false;
    private Enumeration.OverMaxSizePageCountState overMaxSizePageCountState;
    private Boolean isUseJsoupGet = true;
    private Boolean isVietNameseHost = false;
    private String scriptJS = "";

    public PageConfig() {
        this.isManualGet = false;
        this.isChapterLinkAsolute = true;
        this.isEnableChapterSign = false;
    }

    public PageConfig(String pageCode) {
        this.pageCode = pageCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PageConfig other = (PageConfig)obj;
        if (this.pageCode == null) {
            if (other.pageCode != null) {
                return false;
            }
        } else if (this.pageCode.contains("*") || other.pageCode.contains("*")) {
            if (this.pageCode.contains("*") && !other.pageCode.contains(this.pageCode.replace("*", ""))) {
                return false;
            }
            if (other.pageCode.contains("*") && !this.pageCode.contains(other.pageCode.replace("*", ""))) {
                return false;
            }
        } else if (!UrlHandler.normalizeHost(this.pageCode).equals(UrlHandler.normalizeHost(other.pageCode))) {
            return false;
        }
        return true;
    }

    public String getCssFilter() {
        return this.cssFilter;
    }

    public String getCssQueryGetChapterContent() {
        return this.cssQueryGetChapterContent;
    }

    public String getCssQueryGetChapterTitle() {
        return this.cssQueryGetChapterTitle;
    }

    public String getCssQueryGetListChapter() {
        return this.cssQueryGetListChapter;
    }

    public Boolean getIsChapterLinkAsolute() {
        return this.isChapterLinkAsolute;
    }

    public Boolean getIsEnableChapterSign() {
        return this.isEnableChapterSign;
    }

    public Boolean getIsForumType() {
        return this.isForumType;
    }

    public Boolean getIsManualGet() {
        return this.isManualGet;
    }

    public Boolean getIsRevertChapterList() {
        return this.isRevertChapterList;
    }

    public Enumeration.OverMaxSizePageCountState getOverMaxSizePageCountState() {
        return this.overMaxSizePageCountState;
    }

    public String getPageCode() {
        return this.pageCode;
    }

    public String getPagingPattern() {
        return this.pagingPattern;
    }

    public String getTextGuide() {
        return this.textGuide;
    }

    public String getUrlPageTest() {
        return this.urlPageTest;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.pageCode == null ? 0 : this.pageCode.hashCode());
        return result;
    }

    public void setCssFilter(String cssRemoveContent) {
        this.cssFilter = cssRemoveContent;
    }

    public void setCssQueryGetChapterContent(String cssQueryGetChapterContent) {
        this.cssQueryGetChapterContent = cssQueryGetChapterContent;
    }

    public void setCssQueryGetChapterTitle(String cssQueryGetChapterTitle) {
        this.cssQueryGetChapterTitle = cssQueryGetChapterTitle;
    }

    public void setCssQueryGetListChapter(String cssQueryGetListChapterContaint) {
        this.cssQueryGetListChapter = cssQueryGetListChapterContaint;
    }

    public void setIsChapterLinkAsolute(Boolean isChapterLinkAsolute) {
        this.isChapterLinkAsolute = isChapterLinkAsolute;
    }

    public void setIsEnableChapterSign(Boolean isEnableChapterSign) {
        this.isEnableChapterSign = isEnableChapterSign;
    }

    public void setIsForumType(Boolean isForumType) {
        this.isForumType = isForumType;
    }

    public void setIsManualGet(Boolean isManualGet) {
        this.isManualGet = isManualGet;
    }

    public void setIsRevertChapterList(Boolean isRevertChapterList) {
        this.isRevertChapterList = isRevertChapterList;
    }

    public void setOverMaxSizePageCountState(Enumeration.OverMaxSizePageCountState overMaxSizePageCountState) {
        this.overMaxSizePageCountState = overMaxSizePageCountState;
    }

    public void setPageCode(String pageCode) {
        this.pageCode = pageCode;
    }

    public void setPagingPattern(String pagingPattern) {
        this.pagingPattern = pagingPattern;
    }

    public void setTextGuide(String textGuide) {
        this.textGuide = textGuide;
    }

    public void setUrlPageTest(String urlPageTest) {
        this.urlPageTest = urlPageTest;
    }

    public String toString() {
        String location = this.isVietNameseHost != false ? Messages.getGlobalString("const.locationVietNam") : Messages.getGlobalString("const.locationInternational");
        String hostType = this.isForumType != false ? Messages.getGlobalString("const.hostType.forum") : Messages.getGlobalString("const.hostType.web");
        return String.valueOf(this.pageCode) + " - " + hostType + ": " + location;
    }

    public Boolean getIsUseJsoupGet() {
        return this.isUseJsoupGet;
    }

    public void setIsUseJsoupGet(Boolean isUseJsoupGet) {
        this.isUseJsoupGet = isUseJsoupGet;
    }

    public Boolean getIsVietNameseHost() {
        return this.isVietNameseHost;
    }

    public void setIsVietNameseHost(Boolean isVietNameseHost) {
        this.isVietNameseHost = isVietNameseHost;
    }

    public String getScriptJS() {
        return this.scriptJS;
    }

    public void setScriptJS(String scriptJS) {
        this.scriptJS = scriptJS;
    }
}

