/*
 * Decompiled with CFR 0.152.
 */
package resource.text;

import java.beans.Beans;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class Messages {
    private static final String BUNDLE_GLOBAL_NAME = "resource.text.global";
    private static final ResourceBundle RESOURCE_GLOBAL_BUNDLE = Messages.loadGlobalBundle();
    private static final String BUNDLE_NAME = "resource.text.messages";
    private static final ResourceBundle RESOURCE_BUNDLE = Messages.loadBundle();

    public static String getGlobalString(String key) {
        try {
            ResourceBundle bundle = Beans.isDesignTime() ? Messages.loadGlobalBundle() : RESOURCE_GLOBAL_BUNDLE;
            return bundle.getString(key);
        }
        catch (MissingResourceException e) {
            return "!" + key + "!";
        }
    }

    public static String getString(String key) {
        try {
            ResourceBundle bundle = Beans.isDesignTime() ? Messages.loadBundle() : RESOURCE_BUNDLE;
            return bundle.getString(key);
        }
        catch (MissingResourceException e) {
            return "!" + key + "!";
        }
    }

    private static ResourceBundle loadBundle() {
        return ResourceBundle.getBundle(BUNDLE_NAME);
    }

    private static ResourceBundle loadGlobalBundle() {
        return ResourceBundle.getBundle(BUNDLE_GLOBAL_NAME);
    }

    private Messages() {
    }
}

