/*
 * Decompiled with CFR 0.152.
 */
package thread;

import java.awt.Desktop;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Scanner;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;
import javax.swing.JTextArea;
import javax.swing.SpinnerNumberModel;
import main.DownloadRange;
import mkgethtml.Config;
import mkgethtml.Enumeration;
import mkgethtml.GetHtmlCsMix;
import mkgethtml.GetHtmlCss;
import models.Chapter;
import models.PageConfig;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import resource.text.Messages;
import thread.MutilDownload;
import utils.CommonExceptionHandle;
import utils.CommonValue;
import utils.UrlHandler;

public class TAuto
implements Runnable {
    public static String lineBreak = System.getProperty("line.separator");
    Thread t;
    String fileName;
    String tempFileName;
    String txtUrl;
    String ebookInfo;
    JButton btnCancel;
    JButton btnDownload;
    JButton btnResume;
    String storyTitle = "";
    JLabel lblStatus;
    JTextArea log;
    JProgressBar progressBar;
    int count = 0;
    int inteval = 0;
    int size = 0;
    int type = 0;
    Boolean isFinish = false;
    public ArrayList<String> listChapter;
    public PageConfig p;
    public String storyTempFolder = "";
    final Object lockO = new Object();
    String encoding = "UTF-8";
    Boolean isShowDoCapchaDiaglog = false;
    Boolean isDoneCapcha = false;
    Boolean isDivideFile = false;
    String extension = "html";
    String folderMutilFilePath = "";
    String fileNameWithoutExtension = "";
    ArrayList<MutilDownload> mutilThread;

    public TAuto() {
    }

    public TAuto(JButton btnCancel, JButton btnDownload, JButton btnResume, String txtUrl, String fileName, JLabel lblStatus, JTextArea txtLog, JProgressBar progressBar, String ebookInfo, Boolean isDivideFile) {
        this.txtUrl = txtUrl;
        this.ebookInfo = ebookInfo;
        this.fileName = fileName;
        this.lblStatus = lblStatus;
        this.log = txtLog;
        this.progressBar = progressBar;
        this.btnCancel = btnCancel;
        this.btnDownload = btnDownload;
        this.btnResume = btnResume;
        this.isShowDoCapchaDiaglog = false;
        this.isDoneCapcha = false;
        this.isDivideFile = isDivideFile;
        try {
            this.tempFileName = Paths.get(fileName, new String[0]).toFile().getName();
            if (this.tempFileName.contains(".txt")) {
                this.extension = ".txt";
            } else if (this.tempFileName.contains(".html")) {
                this.extension = ".html";
            }
        }
        catch (Exception e1) {
            txtLog.append(String.format(Messages.getGlobalString("error.fileNameInvalid"), e1.getMessage()));
        }
        btnCancel.setEnabled(true);
        btnDownload.setEnabled(false);
        this.count = 0;
        this.storyTitle = "";
        this.listChapter = new ArrayList();
        this.mutilThread = new ArrayList();
        if (txtUrl.length() < 1000) {
            try {
                URL u = new URL(txtUrl);
                if (Config.isSupportHost(u.getHost()) == 1) {
                    this.p = Config.getHostConfigByPageCode(u.getHost());
                }
                if (isDivideFile.booleanValue()) {
                    this.fileNameWithoutExtension = this.tempFileName.replaceAll(".txt", "").replaceAll(".html", "");
                    this.folderMutilFilePath = String.valueOf(Paths.get(fileName, new String[0]).toFile().getParent()) + "\\" + this.fileNameWithoutExtension + "_GHFU_" + String.valueOf(new Date().getTime());
                    File f = new File(this.folderMutilFilePath);
                    if (!f.exists()) {
                        f.mkdir();
                    }
                }
            }
            catch (IOException e) {
                this.log.append(String.format(Messages.getGlobalString("error.errorMessage"), e.getMessage()));
                this.log.setCaretPosition(this.log.getDocument().getLength());
                e.printStackTrace();
            }
        }
    }

    public void cancel() {
        if (this.t != null) {
            for (MutilDownload md : this.mutilThread) {
                md.cancel();
            }
            this.t.checkAccess();
            this.t.interrupt();
            this.t = null;
            this.lblStatus.setText(Messages.getGlobalString("lblStatus.stop"));
            this.btnCancel.setEnabled(false);
            this.btnDownload.setEnabled(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkFinish() {
        Object object = this.lockO;
        synchronized (object) {
            if (!this.isFinish.booleanValue() && this.count >= this.size) {
                this.isFinish = true;
                try {
                    Boolean isError = false;
                    Thread.sleep(500L);
                    this.log.append(String.format(Messages.getGlobalString("txtLog.downloadCompletedStartWriteFile"), new Object[0]));
                    this.log.setCaretPosition(this.log.getDocument().getLength());
                    this.progressBar.setValue(100);
                    if (!this.isDivideFile.booleanValue()) {
                        isError = this.writeConcatenateFile(isError);
                    }
                    this.lblStatus.setText(Messages.getGlobalString("lblStatus.stop"));
                    this.btnCancel.setEnabled(false);
                    this.btnDownload.setEnabled(true);
                    if (!isError.booleanValue()) {
                        if (!CommonExceptionHandle.IsHasException.booleanValue()) {
                            this.log.append(String.format(Messages.getGlobalString("txtLog.writeCompleted"), new Object[0]));
                            this.log.setCaretPosition(this.log.getDocument().getLength());
                            JOptionPane.showMessageDialog(null, String.format(Messages.getGlobalString("notify.downloadCompleted"), new Object[0]));
                        } else {
                            this.log.append(String.format(Messages.getGlobalString("txtLog.downloadGotAnError"), new Object[0]));
                            this.log.setCaretPosition(this.log.getDocument().getLength());
                        }
                    } else {
                        this.log.append(Messages.getGlobalString("error.hasErrorWhenWrite"));
                        this.log.setCaretPosition(this.log.getDocument().getLength());
                    }
                }
                catch (IOException | InterruptedException e) {
                    this.log.append(String.format(Messages.getGlobalString("error.errorMessage"), e.getMessage()));
                    this.log.setCaretPosition(this.log.getDocument().getLength());
                    e.printStackTrace();
                    this.btnResume.setEnabled(true);
                    CommonExceptionHandle.HandleException(e, Messages.getGlobalString("error.occurWhenWrittingFile"));
                }
            }
        }
    }

    public Boolean writeConcatenateFile(Boolean isError) throws UnsupportedEncodingException, FileNotFoundException, IOException {
        BufferedWriter writter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.fileName), this.encoding));
        Path dir = Paths.get(this.storyTempFolder, new String[0]);
        BufferedReader br = null;
        if (this.extension == ".html") {
            isError = this.saveHtmlFile(writter, dir, br);
        } else if (this.extension == ".txt") {
            isError = this.saveTextFile(writter, dir, br);
        }
        return isError;
    }

    public Boolean saveHtmlFile(BufferedWriter writter, Path dir, BufferedReader br) {
        Boolean isError;
        block25: {
            Boolean firstTime = true;
            isError = false;
            try {
                try {
                    writter.write(CommonValue.getHtmlOpenString(this.storyTitle));
                    if (this.ebookInfo != null && !this.ebookInfo.isEmpty()) {
                        writter.write(CommonValue.getAnchorIDandTitle(-1, Messages.getGlobalString("text.ebookInfo")));
                    }
                    DirectoryStream<Path> stream = Files.newDirectoryStream(dir, "*.{html}");
                    for (Path entry : stream) {
                        if (firstTime.booleanValue() && entry.toFile().getName().startsWith("C")) {
                            writter.write("<a name=\"start\"></a>");
                            if (this.ebookInfo != null && !this.ebookInfo.isEmpty()) {
                                writter.write(this.ebookInfo);
                            }
                            firstTime = false;
                        }
                        br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(entry.toFile()), this.encoding));
                        String line = "";
                        while ((line = br.readLine()) != null) {
                            writter.write(String.valueOf(line) + lineBreak);
                        }
                        br.close();
                    }
                    writter.write(CommonValue.getHtmlCloseString());
                }
                catch (IOException x) {
                    CommonExceptionHandle.HandleException(x, Messages.getGlobalString("error.hasErrorWhenWrite"));
                    System.err.println(x);
                    x.printStackTrace();
                    isError = true;
                    if (br != null) {
                        try {
                            br.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                    if (writter == null) break block25;
                    try {
                        writter.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            finally {
                if (br != null) {
                    try {
                        br.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                if (writter != null) {
                    try {
                        writter.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return isError;
    }

    public Boolean saveTextFile(BufferedWriter writter, Path dir, BufferedReader br) {
        Boolean isError;
        block23: {
            isError = false;
            try {
                try {
                    DirectoryStream<Path> stream = Files.newDirectoryStream(dir, "*.{txt}");
                    for (Path entry : stream) {
                        br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(entry.toFile()), this.encoding));
                        String line = "";
                        String bakLine = "";
                        while ((line = br.readLine()) != null) {
                            bakLine = line;
                            if ((line = this.removeHtmlString(line)) != bakLine) {
                                writter.write(line);
                                continue;
                            }
                            writter.write(line);
                            writter.write(lineBreak);
                        }
                        br.close();
                    }
                }
                catch (IOException x) {
                    CommonExceptionHandle.HandleException(x, Messages.getGlobalString("error.hasErrorWhenWrite"));
                    x.printStackTrace();
                    isError = true;
                    if (br != null) {
                        try {
                            br.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                    if (writter == null) break block23;
                    try {
                        writter.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            finally {
                if (br != null) {
                    try {
                        br.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                if (writter != null) {
                    try {
                        writter.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return isError;
    }

    public String removeHtmlString(String line) {
        line = line.replaceAll("<\\/?(?:h|br|p)[^>]*>", lineBreak);
        line = line.replaceAll("<[^>]*>", "");
        line = line.replace("&nbsp;", "");
        return line;
    }

    void doWork() {
        if (this.count == 0) {
            this.log.setText("");
            this.getListChapter();
            this.size = this.listChapter.size();
            this.inteval = this.size / 100;
            if (this.inteval == 0) {
                this.inteval = 1;
            }
            if (DownloadRange.visiable.booleanValue()) {
                DownloadRange dr = new DownloadRange();
                dr.spinnerStart.setModel(new SpinnerNumberModel(new Integer(1), new Integer(1), new Integer(this.size - 1), new Integer(1)));
                dr.spinnerEnd.setModel(new SpinnerNumberModel(new Integer(this.size), new Integer(1), new Integer(this.size), new Integer(1)));
                dr.setVisible(true);
                this.lblStatus.setText(String.format(Messages.getGlobalString("lblStatus.totalChapter"), this.size));
                while (!DownloadRange.setComplete.booleanValue()) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                DownloadRange.setComplete = false;
                DownloadRange.visiable = false;
                if (DownloadRange.start < 0) {
                    DownloadRange.start = 1;
                    DownloadRange.end = this.size;
                }
                List<String> sub = this.listChapter.subList(--DownloadRange.start, DownloadRange.end);
                this.listChapter = new ArrayList<String>(sub);
                this.size = this.listChapter.size();
                DownloadRange.end = 0;
                DownloadRange.start = 0;
            }
            this.generateNewMutilThread();
        } else {
            this.generateMutilThreadFromLogFile();
        }
        for (MutilDownload thread : this.mutilThread) {
            thread.start();
        }
    }

    void generateMutilThreadFromLogFile() {
        ArrayList<Integer> arr;
        block22: {
            this.mutilThread.clear();
            this.log.append(String.format(Messages.getGlobalString("txtLog.resumeThread"), this.count, this.size));
            this.log.setCaretPosition(this.log.getDocument().getLength());
            Path dir = Paths.get(this.storyTempFolder, new String[0]);
            arr = new ArrayList<Integer>();
            Boolean success = true;
            String fileContent = "";
            try {
                Throwable throwable = null;
                Object var6_9 = null;
                try (DirectoryStream<Path> stream = Files.newDirectoryStream(dir, "*.{txt}");){
                    Scanner scanner;
                    File file;
                    for (Path entry : stream) {
                        if (entry.toString().endsWith(".bak.txt")) continue;
                        try {
                            file = entry.toFile();
                            scanner = new Scanner(file);
                            fileContent = scanner.nextLine();
                            scanner.close();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        try {
                            arr.add(Integer.parseInt(fileContent));
                        }
                        catch (NumberFormatException e) {
                            success = false;
                            e.printStackTrace();
                        }
                    }
                    if (success.booleanValue()) break block22;
                    arr.removeAll(arr);
                    for (Path entry : stream) {
                        if (!entry.toString().endsWith(".bak.txt")) continue;
                        try {
                            file = entry.toFile();
                            scanner = new Scanner(file);
                            fileContent = scanner.nextLine();
                            scanner.close();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        try {
                            arr.add(Integer.parseInt(fileContent));
                        }
                        catch (NumberFormatException e) {
                            CommonExceptionHandle.HandleException(e, "Th\u1eed v\u00e0o th\u01b0 m\u1ee5c %temp% v\u00e0 s\u1eeda l\u1ea1i ch\u1ec9 s\u1ed1 INDEX.. \u0111\u1ec3 t\u1ea3i ti\u1ebfp");
                            e.printStackTrace();
                        }
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException x) {
                System.err.println(x);
            }
        }
        int chunk = this.size / CommonValue.getNumThread();
        this.count = 0;
        int i = 0;
        while (i < arr.size() - 1) {
            this.count += (Integer)arr.get(i) - i * chunk + 1;
            this.mutilThread.add(new MutilDownload((Integer)arr.get(i) + 1, i * chunk + chunk, i, this.tempFileName, this.type, this));
            ++i;
        }
        int lastIndex = arr.size() - 1;
        this.count += (Integer)arr.get(lastIndex) - lastIndex * chunk + 1;
        this.mutilThread.add(new MutilDownload((Integer)arr.get(lastIndex) + 1, this.size, lastIndex, this.tempFileName, this.type, this));
    }

    void generateNewMutilThread() {
        try {
            Path pIndex;
            Path pContent;
            Path pHead;
            this.tempFileName = String.valueOf(CommonValue.TMP_PREFIX) + String.valueOf(new Date().getTime()) + this.tempFileName;
            Path ptemp = Paths.get(System.getProperty("java.io.tmpdir"), this.tempFileName);
            Files.createDirectory(ptemp, new FileAttribute[0]);
            this.storyTempFolder = ptemp.toString();
            this.size = this.listChapter.size();
            int numThread = CommonValue.getNumThread();
            int chunk = this.size / numThread;
            int i = 0;
            while (i < numThread - 1) {
                this.mutilThread.add(new MutilDownload(i * chunk, i * chunk + chunk, i, this.tempFileName, this.type, this));
                pHead = Paths.get(this.storyTempFolder, "AH" + i + this.tempFileName);
                pContent = Paths.get(this.storyTempFolder, "C" + i + this.tempFileName);
                pIndex = Paths.get(this.storyTempFolder, "INDEX" + i + ".txt");
                if (!pHead.toFile().exists()) {
                    Files.createFile(pHead, new FileAttribute[0]);
                }
                if (!pContent.toFile().exists()) {
                    Files.createFile(pContent, new FileAttribute[0]);
                }
                if (!pIndex.toFile().exists()) {
                    Files.createFile(pIndex, new FileAttribute[0]);
                }
                ++i;
            }
            this.mutilThread.add(new MutilDownload((numThread - 1) * chunk, this.size, numThread - 1, this.tempFileName, this.type, this));
            pHead = Paths.get(this.storyTempFolder, "AH" + (numThread - 1) + this.tempFileName);
            pContent = Paths.get(this.storyTempFolder, "C" + (numThread - 1) + this.tempFileName);
            pIndex = Paths.get(this.storyTempFolder, "INDEX" + (numThread - 1) + ".txt");
            if (!pHead.toFile().exists()) {
                Files.createFile(pHead, new FileAttribute[0]);
            }
            if (!pContent.toFile().exists()) {
                Files.createFile(pContent, new FileAttribute[0]);
            }
            if (!pIndex.toFile().exists()) {
                Files.createFile(pIndex, new FileAttribute[0]);
            }
        }
        catch (IOException e1) {
            e1.printStackTrace();
            this.log.append(String.format(Messages.getGlobalString("error.errorMessage"), e1.getMessage()));
            this.log.setCaretPosition(this.log.getDocument().getLength());
            CommonExceptionHandle.HandleException(e1, Messages.getGlobalString("error.occurWhenInitThreadDownload"));
        }
    }

    int getListChapter() {
        this.progressBar.setMaximum(100);
        this.progressBar.setValue(0);
        Document docHTML = null;
        Element listTagAUrl = null;
        int totalPageCount = 0;
        Boolean isAjax = false;
        String hostPattern = UrlHandler.getHostFromPattern(this.p.getCssQueryGetListChapter(), this.txtUrl);
        String pageingPattern = "";
        Boolean isAsoluted = this.p.getIsChapterLinkAsolute();
        Boolean isUseJsoupGet = this.p.getIsUseJsoupGet();
        if (!Config.get(Enumeration.EnumConfigKey.ENCODING).equals("UTF-8")) {
            Config.put(Enumeration.EnumConfigKey.ENCODING, "UTF-8");
        }
        try {
            URL u = new URL(this.txtUrl);
            this.lblStatus.setText(Messages.getGlobalString("lblStatus.checkConnection"));
            if (DownloadRange.visiable.booleanValue()) {
                this.log.append(String.format(Messages.getGlobalString("txtLog.logSelectDownloadRange"), new Object[0]));
            }
            this.log.append(String.format(Messages.getGlobalString("txtLog.starting"), new Object[0]));
            this.log.setCaretPosition(this.log.getDocument().getLength());
            isAjax = this.processAjaxSiteList(isAjax, hostPattern, isAsoluted, u);
            if (!isAjax.booleanValue()) {
                ArrayList<String> arr = new ArrayList();
                String cssQueryGetListChapter = this.p.getCssQueryGetListChapter().replaceAll("\\;([\\w\\d\\\\W\\D=\\&\\;])*", "");
                if (this.p.getCssQueryGetListChapter().contains("{")) {
                    arr = GetHtmlCss.getSpecialStringFromQuery(this.p.getCssQueryGetListChapter());
                    cssQueryGetListChapter = cssQueryGetListChapter.substring(0, cssQueryGetListChapter.indexOf("{"));
                }
                if (!(docHTML = Jsoup.connect(this.txtUrl).userAgent(CommonValue.USER_AGENT).timeout(CommonValue.TIME_OUT * 1000).get()).charset().name().equals(Config.get(Enumeration.EnumConfigKey.ENCODING))) {
                    Config.put(Enumeration.EnumConfigKey.ENCODING, docHTML.charset().name());
                }
                this.encoding = Config.get(Enumeration.EnumConfigKey.ENCODING).toString();
                int i = 0;
                while (i < 10000) {
                    if (i % 100 == 0) {
                        this.lblStatus.setText(String.format(Messages.getGlobalString("lblStatus.leechPageIndex"), i + 1));
                        this.progressBar.setValue(this.progressBar.getValue() + 1);
                    }
                    String urlTemp = String.valueOf(this.txtUrl) + pageingPattern + (i + 1);
                    if (i == 0) {
                        urlTemp = this.txtUrl;
                    } else if (this.p.getPagingPattern().contains("{")) {
                        urlTemp = this.processPagingPattern(pageingPattern, i);
                    }
                    docHTML = Jsoup.parse(GetHtmlCss.getHtmlStringFromURLbyCharset(urlTemp, isUseJsoupGet), this.encoding);
                    if (i == 0) {
                        this.storyTitle = docHTML.title();
                        pageingPattern = this.p.getPagingPattern().contains(";") ? this.p.getPagingPattern().substring(0, this.p.getPagingPattern().indexOf(";")) : this.p.getPagingPattern();
                        if (this.p.getIsForumType().booleanValue()) {
                            GetHtmlCsMix.getTotalPageOfForum(docHTML, urlTemp, this.p.getCssQueryGetListChapter(), this.p.getPagingPattern(), this.lblStatus, this.log).select("a").forEach(link -> this.listChapter.add(link.attr("href")));
                            break;
                        }
                    }
                    if ((listTagAUrl = this.p.getCssQueryGetListChapter().contains("{") ? GetHtmlCss.getListTagAUrlSpecialCssQuery(docHTML, cssQueryGetListChapter, arr) : docHTML.select(cssQueryGetListChapter).first()) == null) break;
                    this.regenLinkRelativeOrAsoluted(listTagAUrl, hostPattern, isAsoluted, u);
                    if (i > 0 && GetHtmlCss.checkPageFound(listTagAUrl, this.listChapter.get(0), this.listChapter.get(this.listChapter.size() - 1), this.p).booleanValue()) break;
                    this.listChapter.addAll(GetHtmlCss.getListChaptersOnPage(listTagAUrl));
                    this.log.append(String.format(Messages.getGlobalString("txtLog.leechPage"), urlTemp));
                    this.log.setCaretPosition(this.log.getDocument().getLength());
                    docHTML.childNodes().stream().close();
                    this.lblStatus.setText(String.format(Messages.getGlobalString("lblStatus.leechCompleted"), ++totalPageCount, totalPageCount));
                    this.log.append(String.valueOf(this.lblStatus.getText()) + "\n");
                    this.log.setCaretPosition(this.log.getDocument().getLength());
                    ++i;
                }
            }
            this.progressBar.setValue(0);
            this.size = this.listChapter.size();
            this.revertChapterList();
        }
        catch (Exception e) {
            this.log.append(String.format(Messages.getGlobalString("error.errorMessage"), e.getMessage()));
            this.log.setCaretPosition(this.log.getDocument().getLength());
            return -1;
        }
        return 0;
    }

    public Boolean processAjaxSiteList(Boolean isAjax, String hostPattern, Boolean isAsoluted, URL u) throws IOException {
        switch (this.p.getPageCode().toLowerCase()) {
            case "truyencv.com": {
                this.listChapter.addAll(GetHtmlCsMix.getListChaptersOnPageTruyenCV(this.txtUrl, this.p.getCssQueryGetListChapter()));
                isAjax = true;
                break;
            }
            case "wikidich.com": {
                this.listChapter.addAll(GetHtmlCsMix.getListChaptersOnPageWikiDich(this.txtUrl, this.p.getCssQueryGetListChapter(), this.p.getIsUseJsoupGet()));
                this.regenLinkRelativeOrAsoluted(this.listChapter, hostPattern, isAsoluted, u);
                isAjax = true;
                break;
            }
            case "truyen.tangthuvien.vn": {
                this.listChapter.addAll(GetHtmlCsMix.getListChaptersOnPageTruyenTangThuVien(this.txtUrl, this.p.getCssQueryGetListChapter(), this.p.getIsUseJsoupGet()));
                this.regenLinkRelativeOrAsoluted(this.listChapter, hostPattern, isAsoluted, u);
                isAjax = true;
                break;
            }
        }
        return isAjax;
    }

    public void revertChapterList() {
        if (this.p.getIsRevertChapterList().booleanValue()) {
            int i = this.size - 1;
            int j = 0;
            while (i >= j) {
                String temp = this.listChapter.get(i);
                this.listChapter.set(i, this.listChapter.get(j));
                this.listChapter.set(j, temp);
                --i;
                ++j;
            }
        }
    }

    public String processPagingPattern(String pageingPattern, int i) {
        String urlTemp = pageingPattern.contains("-") ? UrlHandler.getPagePatternUrl(this.p.getPagingPattern(), this.txtUrl, pageingPattern.replaceFirst("\\{[\\w\\W]*\\}", String.valueOf(i))) : UrlHandler.getPagePatternUrl(this.p.getPagingPattern(), this.txtUrl, pageingPattern.replaceFirst("\\{\\w*\\}", String.valueOf(i + 1)));
        return urlTemp;
    }

    public void regenLinkRelativeOrAsoluted(ArrayList<String> listChapter, String hostPattern, Boolean isAsoluted, URL u) {
        if (!isAsoluted.booleanValue()) {
            String cssListChapterTemp = this.p.getCssQueryGetListChapter();
            int i = 0;
            while (i < listChapter.size()) {
                String link = listChapter.get(i);
                String newLink = "";
                newLink = cssListChapterTemp.contains(";") ? UrlHandler.normalizeHostAndPath(hostPattern, link) : UrlHandler.normalizeHostAndPath(u.getHost(), link);
                listChapter.set(i, newLink);
                ++i;
            }
        } else {
            int i = 0;
            while (i < listChapter.size()) {
                listChapter.set(i, listChapter.get(i));
                ++i;
            }
        }
    }

    private void regenLinkRelativeOrAsoluted(Element listTagAUrl, String hostPattern, Boolean isAsoluted, URL u) {
        if (!isAsoluted.booleanValue()) {
            String cssListChapterTemp = this.p.getCssQueryGetListChapter();
            listTagAUrl.select("a").iterator().forEachRemaining(link -> {
                String newLink = "";
                newLink = cssListChapterTemp.contains(";") ? UrlHandler.normalizeHostAndPath(hostPattern, link.attr("href")) : UrlHandler.normalizeHostAndPath(u.getHost(), link.attr("href"));
                link.attr("href", newLink);
            });
        } else {
            listTagAUrl.select("a").iterator().forEachRemaining(link -> link.attr("href", UrlHandler.normalizeHost(link.attr("href"))));
        }
    }

    @Override
    public void run() {
        this.btnCancel.setEnabled(true);
        this.btnDownload.setEnabled(false);
        this.btnResume.setEnabled(false);
        this.doWork();
    }

    void saveDownloadFile() {
    }

    public void start() {
        this.t = new Thread((Runnable)this, "Dowork");
        this.t.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateUICount(String chapterTitle, int threadID, int index) {
        Object object = this.lockO;
        synchronized (object) {
            this.lblStatus.setText(String.format(Messages.getGlobalString("lblStatus.downloading"), this.count + 1, this.size, chapterTitle.length() < 50 ? chapterTitle : String.valueOf(chapterTitle.substring(0, 50)) + "..."));
            if (this.count % this.inteval == 0) {
                this.progressBar.setValue((int)((float)this.count / (float)this.size * 100.0f));
            }
            ++this.count;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Chapter checkGoogleRecapcha(Chapter chapter, int chapterIndex, String cssChapterTitle, String cssChapterContent, String cssRemoveContent, Boolean isEnableChapterSign) {
        Chapter c = null;
        Object object = this.lockO;
        synchronized (object) {
            Boolean bIsStopDownload = false;
            if (chapter.getIsHasCapchaBlock().booleanValue() && !this.isDoneCapcha.booleanValue() && !this.isShowDoCapchaDiaglog.booleanValue()) {
                block18: {
                    this.isShowDoCapchaDiaglog = true;
                    int confirm = JOptionPane.showOptionDialog(null, Messages.getGlobalString("message.robotDetectFix"), Messages.getGlobalString("title.notice"), 0, 3, null, new String[]{Messages.getGlobalString("btn.doCapcha"), Messages.getGlobalString("btn.stopDownload")}, Messages.getGlobalString("btn.doCapcha"));
                    if (confirm == 0) {
                        try {
                            Desktop.getDesktop().browse(new URI(this.listChapter.get(chapterIndex)));
                            confirm = JOptionPane.showOptionDialog(null, Messages.getGlobalString("message.doneRecapcha"), Messages.getGlobalString("title.notice"), 0, 3, null, new String[]{Messages.getGlobalString("btn.done"), Messages.getGlobalString("btn.stopDownload")}, Messages.getGlobalString("btn.done"));
                            if (confirm == 0) {
                                this.isDoneCapcha = true;
                                c = GetHtmlCss.getChapterTitleAndContent(chapterIndex, this.listChapter.get(chapterIndex), cssChapterTitle, cssChapterContent, cssRemoveContent, isEnableChapterSign, this.p.getIsUseJsoupGet());
                                this.lockO.notifyAll();
                                break block18;
                            }
                            bIsStopDownload = true;
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                            bIsStopDownload = true;
                        }
                        catch (URISyntaxException e) {
                            e.printStackTrace();
                            bIsStopDownload = true;
                        }
                    } else {
                        bIsStopDownload = true;
                    }
                }
                if (bIsStopDownload.booleanValue()) {
                    this.cancel();
                }
            } else {
                try {
                    if (!this.isDoneCapcha.booleanValue() && !bIsStopDownload.booleanValue()) {
                        this.lockO.wait();
                    } else if (bIsStopDownload.booleanValue()) {
                        this.cancel();
                    } else {
                        c = GetHtmlCss.getChapterTitleAndContent(chapterIndex, this.listChapter.get(chapterIndex), cssChapterTitle, cssChapterContent, cssRemoveContent, isEnableChapterSign, this.p.getIsUseJsoupGet());
                    }
                }
                catch (IOException | InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
        return c;
    }
}

