/*
 * Decompiled with CFR 0.152.
 */
package utils;

import java.awt.Desktop;
import java.awt.HeadlessException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.JLabel;
import mkgethtml.Config;
import mkgethtml.Enumeration;
import resource.text.Messages;
import utils.CommonExceptionHandle;
import utils.CommonValue;
import utils.GetFileUtil;

public class CheckUpdate {
    String fileToDownload = "";
    public String jarName = "";
    public String fileSize = "";
    public String message = "";
    public Date date;
    public Boolean isAppUpdated = false;
    public Boolean isConfigUpdated = false;
    public Enumeration.UpdateState updateStatus = Enumeration.UpdateState.NoNetWorking;

    public static void deleteOldVersion() {
        Object lastVersionJarPathO = Config.get(Enumeration.EnumConfigKey.DELETE_ON_EXIST);
        if (lastVersionJarPathO != null) {
            String lastVersionJarPath = lastVersionJarPathO.toString();
            try {
                Files.deleteIfExists(Paths.get(lastVersionJarPath, new String[0]));
                Config.remove(Enumeration.EnumConfigKey.DELETE_ON_EXIST);
                Config.saveConfig(Enumeration.ConfigType.Setting);
            }
            catch (Exception e) {
                try {
                    Thread.sleep(1000L);
                    Files.deleteIfExists(Paths.get(lastVersionJarPath, new String[0]));
                    Config.remove(Enumeration.EnumConfigKey.DELETE_ON_EXIST);
                    Config.saveConfig(Enumeration.ConfigType.Setting);
                }
                catch (IOException | InterruptedException e2) {
                    e2.printStackTrace();
                }
                e.printStackTrace();
            }
        }
    }

    Boolean checkNetworking() {
        try {
            HttpURLConnection conn = (HttpURLConnection)new URL("http://google.com").openConnection();
            conn.setConnectTimeout(3000);
            conn.connect();
            conn.disconnect();
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    void deleteOnStart() throws IOException {
        Config.put(Enumeration.EnumConfigKey.DELETE_ON_EXIST, CommonValue.getAppJARFile().getName());
        Config.saveConfig(Enumeration.ConfigType.Setting);
        Desktop.getDesktop().open(new File(this.jarName));
        System.exit(0);
    }

    public Enumeration.UpdateState isAppUpdate() {
        Enumeration.UpdateState updateState;
        block17: {
            updateState = Enumeration.UpdateState.GetAppUpdateInfoFailed;
            try {
                String updateString = GetFileUtil.getStringContentFromURI(String.valueOf(CommonValue.SOURCEFORCE_DIRECT_LINK) + "UPDATE.txt", 3000);
                if (updateString == "") break block17;
                updateState = Enumeration.UpdateState.AppOutOfUpdate;
                String[] updates = updateString.split(";");
                updates[2] = updates[2].replace("\r\n", "");
                this.jarName = "GetTextFromHtml-V" + updates[0] + ".jar";
                this.fileSize = updates[2];
                try {
                    this.date = new SimpleDateFormat("yyyy/MM/dd").parse(updates[1]);
                }
                catch (ParseException e) {
                    CommonExceptionHandle.HandleException(e, Messages.getGlobalString("error.convertDatetimeError"));
                }
                this.fileToDownload = String.valueOf(CommonValue.SOURCEFORCE_DIRECT_LINK) + this.jarName;
                String[] newVersion = updates[0].split("\\.");
                String[] currentVersion = CommonValue.APP_VERSION.split("\\.");
                int tc = 0;
                int tn = 0;
                int i = 0;
                while (i < currentVersion.length) {
                    int current = Integer.parseInt(currentVersion[i]);
                    int newVer = Integer.parseInt(newVersion[i]);
                    if (i == 0) {
                        tc += current * 10000;
                        tn += newVer * 10000;
                    } else if (i == 1) {
                        tc += current * 1000;
                        tn += newVer * 1000;
                    } else if (newVer > 9 && current > 9) {
                        tn += newVer;
                        tc += current;
                    } else if (newVer > 9) {
                        tn += newVer;
                        tc += current * 10;
                    } else if (current > 9) {
                        tn += newVer * 10;
                        tc += current;
                    } else {
                        tn += newVer;
                        tc += current;
                    }
                    ++i;
                }
                if (tn > tc) {
                    this.message = GetFileUtil.getStringContentFromURI(String.valueOf(CommonValue.SOURCEFORCE_DIRECT_LINK) + "NEWS.txt");
                } else {
                    updateState = Enumeration.UpdateState.AppUpdated;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return updateState;
    }

    public Enumeration.UpdateState isConfigFileUpdate() {
        Enumeration.UpdateState updateStatus = Enumeration.UpdateState.ConfigOutOfUpdate;
        try {
            File currentConfigFile = new File(CommonValue.CONFIG_DATASITE);
            URL url = new URL(CommonValue.getDownloadLinkConfigFile());
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setConnectTimeout(3000);
            long onlineLength = connection.getContentLengthLong();
            if (currentConfigFile.length() < onlineLength) {
                this.jarName = CommonValue.getAppJARFile().getName();
                this.fileToDownload = String.valueOf(CommonValue.SOURCEFORCE_DIRECT_LINK) + CommonValue.CONFIG_DATASITE;
                this.fileSize = String.valueOf(onlineLength / 1024L) + " Kbs";
                this.message = GetFileUtil.getStringContentFromURI(String.valueOf(CommonValue.SOURCEFORCE_DIRECT_LINK) + "NEWSHOST.txt");
            } else {
                updateStatus = Enumeration.UpdateState.ConfigUpdated;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            CommonExceptionHandle.HandleException(e, Messages.getGlobalString("error.occurWhenCheckingUpdateConfig"));
        }
        return updateStatus;
    }

    public Boolean isUpdated() throws IOException {
        Boolean isUpdate = this.checkNetworking();
        if (!isUpdate.booleanValue()) {
            this.updateStatus = Enumeration.UpdateState.NoNetWorking;
        }
        this.updateStatus = this.isAppUpdate();
        switch (this.updateStatus) {
            case NoNetWorking: 
            case GetAppUpdateInfoFailed: {
                this.isAppUpdated = this.isConfigUpdated = Boolean.valueOf(true);
                break;
            }
            case AppOutOfUpdate: {
                this.isAppUpdated = this.isConfigUpdated = Boolean.valueOf(false);
                break;
            }
            case AppUpdated: {
                this.isAppUpdated = true;
                this.updateStatus = this.isConfigFileUpdate();
                this.isConfigUpdated = this.isLastestConfig();
            }
        }
        isUpdate = this.isAppUpdated != false && this.isConfigUpdated != false;
        return isUpdate;
    }

    public void setFileDownloadLink(String link) {
        this.fileToDownload = link;
    }

    public void updateApp(final JLabel lblStatus) {
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    lblStatus.setText(Messages.getGlobalString("lblStatus.startingUpdate"));
                    URL u = new URL(CheckUpdate.this.fileToDownload);
                    lblStatus.setText(String.format(Messages.getGlobalString("lblStatus.dowloadingUpdate"), CheckUpdate.this.jarName, CheckUpdate.this.fileSize));
                    ReadableByteChannel rbc = Channels.newChannel(u.openStream());
                    FileOutputStream fos = new FileOutputStream(CheckUpdate.this.jarName);
                    fos.getChannel().transferFrom(rbc, 0L, Long.MAX_VALUE);
                    fos.close();
                    lblStatus.setText(String.format(Messages.getGlobalString("lblStatus.downloadUpdateCompleted"), CheckUpdate.this.fileToDownload));
                    lblStatus.setText(String.format(Messages.getGlobalString("lblStatus.downloadConfigFile"), CommonValue.CONFIG_DATASITE));
                    u = new URL(String.valueOf(CommonValue.SOURCEFORCE_DIRECT_LINK) + CommonValue.CONFIG_DATASITE);
                    rbc = Channels.newChannel(u.openStream());
                    fos = new FileOutputStream(CommonValue.CONFIG_DATASITE);
                    fos.getChannel().transferFrom(rbc, 0L, Long.MAX_VALUE);
                    fos.close();
                    lblStatus.setText(Messages.getGlobalString("lblStatus.downloadConfigFileCompleted"));
                    lblStatus.setText(String.format(Messages.getGlobalString("lblStatus.updateCompleteRestartAfterSecs"), 3));
                    lblStatus.setText(String.format(Messages.getGlobalString("lblStatus.updateCompleteRestartAfterSecs"), 2));
                    Thread.sleep(1000L);
                    lblStatus.setText(String.format(Messages.getGlobalString("lblStatus.updateCompleteRestartAfterSecs"), 1));
                    Thread.sleep(1000L);
                    CheckUpdate.this.deleteOnStart();
                }
                catch (HeadlessException | IOException | InterruptedException e) {
                    e.printStackTrace();
                    CommonExceptionHandle.HandleException(e, Messages.getGlobalString("error.updateError"));
                }
            }
        });
        t.start();
    }

    public void updateConfig(final JLabel lblStatus) throws IOException {
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    lblStatus.setText(Messages.getGlobalString("lblStatus.startingUpdate"));
                    URL u = new URL(String.valueOf(CommonValue.SOURCEFORCE_DIRECT_LINK) + CommonValue.CONFIG_DATASITE);
                    lblStatus.setText(String.format(Messages.getGlobalString("lblStatus.downloadConfigFile"), CommonValue.CONFIG_DATASITE));
                    ReadableByteChannel rbc = Channels.newChannel(u.openStream());
                    FileOutputStream fos = new FileOutputStream(CommonValue.CONFIG_DATASITE);
                    fos.getChannel().transferFrom(rbc, 0L, Long.MAX_VALUE);
                    fos.close();
                    lblStatus.setText(Messages.getGlobalString("lblStatus.downloadConfigFileCompleted"));
                    lblStatus.setText(String.format(Messages.getGlobalString("lblStatus.updateCompleteRestartAfterSecs"), 3));
                    lblStatus.setText(String.format(Messages.getGlobalString("lblStatus.updateCompleteRestartAfterSecs"), 2));
                    Thread.sleep(1000L);
                    lblStatus.setText(String.format(Messages.getGlobalString("lblStatus.updateCompleteRestartAfterSecs"), 1));
                    Thread.sleep(1000L);
                    Desktop.getDesktop().open(CommonValue.getAppJARFile());
                    System.exit(0);
                }
                catch (IOException | InterruptedException e) {
                    e.printStackTrace();
                }
            }
        });
        t.start();
    }

    public Boolean isLastestVersion() {
        if (this.updateStatus == Enumeration.UpdateState.AppUpdated) {
            return true;
        }
        return false;
    }

    public Boolean isLastestConfig() {
        if (this.updateStatus == Enumeration.UpdateState.ConfigUpdated) {
            return true;
        }
        return false;
    }
}

