/*
 * Decompiled with CFR 0.152.
 */
package utils;

import com.google.gson.Gson;
import com.google.gson.JsonIOException;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import models.PageConfig;
import utils.CommonExceptionHandle;

public class JSONUtil {
    private static final Type CONFIG_DATASITE_TYPE = new TypeToken<ArrayList<PageConfig>>(){}.getType();

    public static ArrayList<PageConfig> loadConfig(String filePath) throws FileNotFoundException, JsonIOException, JsonSyntaxException {
        ArrayList lstData = new ArrayList();
        Gson gson = new Gson();
        String jsonString = "";
        try {
            jsonString = new String(Files.readAllBytes(Paths.get(filePath, new String[0])), StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        lstData = (ArrayList)gson.fromJson(jsonString, CONFIG_DATASITE_TYPE);
        return lstData;
    }

    public static void saveConfig(String filePath, Object object) throws FileNotFoundException {
        block12: {
            Gson gson = new Gson();
            OutputStreamWriter outWriter = null;
            try {
                try {
                    outWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(filePath), "UTF-8");
                    String jsonString = gson.toJson(object);
                    outWriter.write(jsonString);
                }
                catch (IOException e) {
                    CommonExceptionHandle.HandleException(e, "Save config error");
                    e.printStackTrace();
                    if (outWriter == null) break block12;
                    try {
                        outWriter.close();
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                }
            }
            finally {
                if (outWriter != null) {
                    try {
                        outWriter.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }
}

