/* -*- Mode: C; tab-width: 3; indent-tabs-mode: nil; c-basic-offset: 3 -*- */

/*
 * GImageView
 * Copyright (C) 2001 Takuro Ashie
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * $Id: comment.h,v 1.16 2002/10/31 12:21:11 makeinu Exp $
 */

#ifndef __COMMENT_H__
#define __COMMENT_H__

#include "gimageview.h"

#define TYPE_COMMENT            (comment_get_type ())
#define COMMENT(obj)            (GTK_CHECK_CAST ((obj), TYPE_COMMENT, Comment))
#define COMMENT_CLASS(klass)    (GTK_CHECK_CLASS_CAST ((klass), TYPE_COMMENT, CommentClass))
#define IS_COMMENT(obj)         (GTK_CHECK_TYPE ((obj), TYPE_COMMENT))
#define IS_COMMENT_CLASS(klass) (GTK_CHECK_CLASS_TYPE ((klass), TYPE_COMMENT))

typedef struct Comment_Tag      Comment;
typedef struct CommentClass_Tag CommentClass;

struct Comment_Tag
{
   GtkObject    parent;

   gchar       *filename;
   ImageInfo   *info;        /* 1:1 relation */

   GList       *data_list;   /* comment data list */
   gchar       *note;
};

struct CommentClass_Tag {
   GtkObjectClass parent_class;

   /* -- Signals -- */
   void (*file_saved)   (Comment   *comment,
                         ImageInfo *info); 
   void (*file_deleted) (Comment   *comment,
                         ImageInfo *info); 
};


typedef gchar *(*CommentDataGetDefValFn) (ImageInfo *info, gpointer data);

typedef struct CommentDataEntry_Tag
{
   gchar *key;
   gchar *display_name;
   gchar *value;
   gboolean enable;
   gboolean auto_val;
   gboolean display;
   gboolean userdef;
   CommentDataGetDefValFn def_val_fn;
} CommentDataEntry;


guint             comment_get_type                 ();
Comment          *comment_ref                      (Comment          *comment);
void              comment_unref                    (Comment          *comment);

void              comment_update_data_entry_list   ();
GList            *comment_get_data_entry_list      ();

gchar            *comment_get_path                 (const gchar      *img_path);
gchar            *comment_find_file                (const gchar      *img_path);
CommentDataEntry *comment_data_entry_find_template_by_key (const gchar *key);
CommentDataEntry *comment_find_data_entry_by_key   (Comment          *comment,
                                                    const gchar      *key);
CommentDataEntry *comment_append_data              (Comment          *comment,
                                                    const gchar      *key,
                                                    const gchar      *value);
void              comment_data_entry_remove        (Comment          *comment,
                                                    CommentDataEntry *entry);
void              comment_data_entry_remove_by_key (Comment          *comment,
                                                    const gchar      *key);
CommentDataEntry *comment_data_entry_dup           (CommentDataEntry *src);
void              comment_data_entry_delete        (CommentDataEntry *entry);
gboolean          comment_update_note              (Comment          *comment,
                                                    gchar            *note);
gboolean          comment_save_file                (Comment          *comment);
void              comment_delete_file              (Comment          *comment);
Comment          *comment_get_from_image_info      (ImageInfo        *info);

#endif /* __COMMENT_H__ */
