/* -*- Mode: C; tab-width: 3; indent-tabs-mode: nil; c-basic-offset: 3 -*- */

/*
 * GImageView
 * Copyright (C) 2001 Takuro Ashie
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * $Id: comment_view.h,v 1.7.2.1 2003/05/13 11:25:56 makeinu Exp $
 */

#ifndef __COMMENT_VIEW_H__
#define __COMMENT_VIEW_H__

#include "gimageview.h"
#include "comment.h"

struct CommentView_Tag
{
   Comment *comment;

   GtkWidget *window;
   GtkWidget *main_vbox;
   GtkWidget *notebook;
   GtkWidget *button_area;

   GtkWidget *data_page, *note_page;

   GtkWidget *comment_clist;
   gint       selected_row;

   GtkWidget *key_combo, *value_entry;
   GtkWidget *selected_item;

   GtkWidget *note_box;

   GtkWidget *clear_button;
   GtkWidget *apply_button;
   GtkWidget *del_value_button;

   GtkWidget *save_button;
   GtkWidget *reset_button;
   GtkWidget *delete_button;
};


void         comment_view_clear         (CommentView *cv);
gboolean     comment_view_change_file   (CommentView *cv,
                                         ImageInfo   *info);
CommentView *comment_view_create        ();
CommentView *comment_view_create_window (ImageInfo *info);

#endif /* __COMMENT_VIEW_H__ */
