/* -*- Mode: C; tab-width: 3; indent-tabs-mode: nil; c-basic-offset: 3 -*- */

/*
 * GImageView
 * Copyright (C) 2001-2003 Takuro Ashie
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * $Id: duplicates_finder.h,v 1.1.2.2 2003/05/18 06:39:34 makeinu Exp $
 */

#ifndef __DUPLICATES_FINDER_H__
#define __DUPLICATES_FINDER_H__

#include "gimageview.h"

#include <glib.h>

#define DUPLICATES_FINDER(obj)         GTK_CHECK_CAST (obj, duplicates_finder_get_type (), DuplicatesFinder)
#define DUPLICATES_FINDER_CLASS(klass) GTK_CHECK_CLASS_CAST (klass, duplicates_finder_get_type, DuplicatesFinderClass)
#define IS_DUPLICATES_FINDER(obj)      GTK_CHECK_TYPE (obj, duplicates_finder_get_type ())


typedef struct DuplicatesFinder_Tag         DuplicatesFinder;
typedef struct DuplicatesFinderPriv_Tag     DuplicatesFinderPriv;
typedef struct DuplicatesFinderClass_Tag    DuplicatesFinderClass;
typedef struct DuplicatesPair_Tag           DuplicatesPair;
typedef struct DuplicatesCompFuncTable_Tag  DuplicatesCompFuncTable;


struct DuplicatesFinder_Tag
{
   GtkObject parent;

   GList *src_list, *dest_list;
   GList *cur1, *cur2;

   GHashTable *table;

   DuplicatesCompFuncTable *funcs;

   gfloat progress;
   gint   len, pos;

   gint   pairs_found;

   gint   refresh_rate;
   gint   timer_rate;

   guint  timer_id;
   guint  idle_id;
};


struct DuplicatesFinderClass_Tag
{
   GtkObjectClass parent_class;

   void (*start)           (DuplicatesFinder *finder);
   void (*stop)            (DuplicatesFinder *finder);
   void (*progress_update) (DuplicatesFinder *finder);
   void (*found)           (DuplicatesFinder *finder,
                            DuplicatesPair   *pair);
};


struct DuplicatesPair_Tag
{
   Thumbnail *thumb1;
   Thumbnail *thumb2;
   gfloat similarity;
};


struct DuplicatesCompFuncTable_Tag
{
   const gchar * const label;

   gpointer (*get_data)    (Thumbnail *thumb);
   gint     (*compare)     (gpointer   data1,
                            gpointer   data2,
                            gfloat    *similarity);
   void     (*data_delete) (gpointer   data);
};


guint         duplicates_finder_get_type           (void);

const gchar **duplicates_finder_get_algol_types    (void);

DuplicatesFinder *
              duplicates_finder_new                (const gchar *type);

void          duplicates_finder_set_algol_type     (DuplicatesFinder *finder,
                                                    const gchar      *type);
/* souce doesn't work yet */
void          duplicates_finder_append_source      (DuplicatesFinder *finder,
                                                    Thumbnail        *thumb1);
void          duplicates_finder_append_dest        (DuplicatesFinder *finder,
                                                    Thumbnail        *thumb1);
void          duplicates_finder_start              (DuplicatesFinder *finder);
void          duplicates_finder_stop               (DuplicatesFinder *finder);
gfloat        duplicates_finder_get_progress       (DuplicatesFinder *finder);

#endif /* __DUPLICATES_FINDER_H__ */
