/* -*- Mode: C; tab-width: 3; indent-tabs-mode: nil; c-basic-offset: 3 -*- */

/*
 * GImageView
 * Copyright (C) 2001 Takuro Ashie
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * $Id: nav_window.h,v 1.1.2.1 2003/04/05 18:01:45 makeinu Exp $
 */

/*
 * These codes are mostly taken from gThumb.
 * gThumb code Copyright (C) 2001 The Free Software Foundation, Inc.
 * gThumb author: Paolo Bacchilega
 */

#ifndef __NAV_WINDOW_H__
#define __NAV_WINDOW_H__

#include "gimageview.h"

#define NAV_WIN_SIZE 128 /* Max size of the window. */

typedef struct {
   ImageView *iv;

   gint x_root, y_root;

   GtkWidget *popup_win;
   GtkWidget *preview;
   GdkPixmap *pixmap;
   GdkBitmap *mask;

   GdkGC *gc;

   gint image_width, image_height;

   gint popup_x, popup_y, popup_width, popup_height;
   gint sqr_x, sqr_y, sqr_width, sqr_height;
   gint fix_x_pos, fix_y_pos;

   gint motion_hand_id, keypress_hand_id;

   gdouble factor;
} NavWindow; 

NavWindow *navwin_create (ImageView *iv,
                          gfloat x_root,
                          gfloat y_root,
                          GdkPixmap *pixmap,
                          GdkBitmap *mask);

#endif /* __NAV_WINDOW_H__ */
