/* -*- Mode: C; tab-width: 3; indent-tabs-mode: nil; c-basic-offset: 3 -*- */

/*
 * GImageView
 * Copyright (C) 2001-2003 Takuro Ashie
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * $Id: prefs_xine.c,v 1.1.2.2 2003/04/22 12:05:16 makeinu Exp $
 */

#include "prefs_xine.h"

#ifdef ENABLE_XINE

#include <stdlib.h>
#include "gtkutils.h"
#include "gimv_prefs_ui_utils.h"

#define CONF_THUMBNAIL_DELAY_KEY "create_thumbnail_delay"
#define CONF_THUMBNAIL_DELAY     "3.0"

extern GimvPluginInfo *gimv_xine_plugin_get_info (void);
static GtkWidget      *prefs_xine_page           (void);
static gboolean        prefs_xine_apply          (GimvPrefsWinAction action);

static GimvPrefsWinPage gimv_prefs_page_xine =
{
   path:           N_("/Movie and Audio/Xine"),
   priority_hint:  0,
   icon:           NULL,
   icon_open:      NULL,
   create_page_fn: prefs_xine_page,
   apply_fn:       prefs_xine_apply,
};

static gfloat prev_delay_value;
static gfloat temp_delay_value;

gboolean
gimv_prefs_ui_xine_get_page (guint idx, GimvPrefsWinPage **page, guint *size)
{
   g_return_val_if_fail(page, FALSE);
   *page = NULL;
   g_return_val_if_fail(size, FALSE);
   *size = 0;

   if (idx == 0) {
      *page = &gimv_prefs_page_xine;
      *size = sizeof (gimv_prefs_page_xine);
      return TRUE;
   } else {
      return FALSE;
   }
}


gfloat
gimv_prefs_xine_get_delay (GimvPluginInfo *this)
{
   gfloat delay = atof (CONF_THUMBNAIL_DELAY);
   gboolean success;

   success = gimv_plugin_prefs_load_value (this->name,
                                           GIMV_PLUGIN_IMAGEVIEW_EMBEDER,
                                           CONF_THUMBNAIL_DELAY_KEY,
                                           GIMV_PLUGIN_PREFS_FLOAT,
                                           (gpointer) &delay);
   if (!success) {
      delay = atof (CONF_THUMBNAIL_DELAY);
      gimv_plugin_prefs_save_value (this->name,
                                    GIMV_PLUGIN_IMAGEVIEW_EMBEDER,
                                    CONF_THUMBNAIL_DELAY_KEY,
                                    CONF_THUMBNAIL_DELAY);
   }

   return delay;
}


static GtkWidget *
prefs_xine_page (void)
{
   GtkWidget *main_vbox, *frame, *vbox, *hbox;
   GtkWidget *label, *spinner;
   GtkWidget *vo_combo, *ao_combo;
   GtkAdjustment *adj;
   GimvPluginInfo *this = gimv_xine_plugin_get_info ();

   main_vbox = gtk_vbox_new (FALSE, 0);

   prev_delay_value = temp_delay_value = gimv_prefs_xine_get_delay (this);

   /**********************************************
    * Driver Frame
    **********************************************/
   gimv_prefs_ui_create_frame(_("Driver (Not implemented yet)"),
                              frame, vbox, main_vbox, FALSE);

   /* video driver combo */
   hbox = gtk_hbox_new (FALSE, 0);
   gtk_container_set_border_width(GTK_CONTAINER (hbox), 5);
   gtk_box_pack_start (GTK_BOX (vbox), hbox, FALSE, FALSE, 0);
   gtk_widget_show (hbox);

   label = gtk_label_new (_("Video driver : "));
   gtk_box_pack_start (GTK_BOX (hbox), label, FALSE, FALSE, 2);
   gtk_widget_show (label);

   vo_combo = gtk_combo_new ();
   gtk_box_pack_start (GTK_BOX (hbox), vo_combo, FALSE, FALSE, 2);
   gtk_widget_show (vo_combo);
   gtk_widget_set_usize (vo_combo, 100, -1);

   /* audio driver combo */
   label = gtk_label_new (_("Audio driver : "));
   gtk_box_pack_start (GTK_BOX (hbox), label, FALSE, FALSE, 2);
   gtk_widget_show (label);

   ao_combo = gtk_combo_new ();
   gtk_box_pack_start (GTK_BOX (hbox), ao_combo, FALSE, FALSE, 2);
   gtk_widget_show (ao_combo);
   gtk_widget_set_usize (ao_combo, 100, -1);

   gtk_widget_set_sensitive (frame, FALSE);

   /**********************************************
    * Thumbnail Frame
    **********************************************/
   gimv_prefs_ui_create_frame(_("Thumbnail"), frame, vbox, main_vbox, FALSE);

   hbox = gtk_hbox_new (FALSE, 5);
   gtk_container_set_border_width (GTK_CONTAINER(hbox), 5);
   gtk_box_pack_start (GTK_BOX (vbox), hbox, FALSE, FALSE, 0);
   gtk_widget_show (hbox);
   label = gtk_label_new (_("Delay time to create thumbnail from starting play : "));
   gtk_box_pack_start (GTK_BOX (hbox), label, FALSE, FALSE, 0);
   gtk_widget_show (label);
   adj = (GtkAdjustment *) gtk_adjustment_new (temp_delay_value,
                                               0.0, 7200.0, 0.01, 0.1, 0.0);
   spinner = gtkutil_create_spin_button (adj);
   gtk_widget_set_usize(spinner, 70, -1);
   gtk_spin_button_set_digits (GTK_SPIN_BUTTON (spinner), 2);
   gtk_signal_connect (GTK_OBJECT (adj), "value_changed",
                       GTK_SIGNAL_FUNC (gtkutil_get_data_from_adjustment_by_float_cb),
                       &temp_delay_value);
   gtk_box_pack_start (GTK_BOX (hbox), spinner, FALSE, FALSE, 0);
   gtk_widget_show (spinner);

   label = gtk_label_new (_("[sec]"));
   gtk_box_pack_start (GTK_BOX (hbox), label, FALSE, FALSE, 0);
   gtk_widget_show (label);

   return main_vbox;
}


static gboolean
prefs_xine_apply (GimvPrefsWinAction action)
{
   gchar delay_str[32];
   GimvPluginInfo *this = gimv_xine_plugin_get_info();

   switch (action) {
   case GIMV_PREFS_WIN_ACTION_OK:
   case GIMV_PREFS_WIN_ACTION_APPLY:
      g_snprintf(delay_str, 32, "%f", temp_delay_value);
      break;
   default:
      g_snprintf(delay_str, 32, "%f", prev_delay_value);
      break;
  }

   gimv_plugin_prefs_save_value (this->name,
                                 GIMV_PLUGIN_IMAGEVIEW_EMBEDER,
                                 CONF_THUMBNAIL_DELAY_KEY,
                                 delay_str);

   return FALSE;
}

#endif /* ENABLE_XINE */
