/* -*- Mode: C; tab-width: 3; indent-tabs-mode: nil; c-basic-offset: 3 -*- */

/*
 * GImageView
 * Copyright (C) 2001 Takuro Ashie
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * $Id: compare_similar.h,v 1.1.2.1 2003/05/17 17:43:27 makeinu Exp $
 */

/*
 * These codes are mostly taken from GQview.
 * GQview code Copyright (C) 2001 John Ellis
 */

#ifndef __SIMILAR_H__
#define __SIMILAR_H__

#include "gimv_image.h"
#include "thumbnail.h"

typedef struct ImageSimilarityData_Tag ImageSimilarityData;

struct ImageSimilarityData_Tag
{
   guint8 avg_r[1024];
   guint8 avg_g[1024];
   guint8 avg_b[1024];

   gint filled;
};


ImageSimilarityData *image_sim_new            (void);
void                 image_sim_delete         (ImageSimilarityData *sd);

void                 image_sim_fill_data      (ImageSimilarityData *sd,
                                               GimvImage           *image);
ImageSimilarityData *image_sim_new_from_image (GimvImage           *image);
ImageSimilarityData *image_sim_new_from_thumb (Thumbnail           *thumb);

gfloat               image_sim_compare        (ImageSimilarityData *a,
                                               ImageSimilarityData *b);
gfloat               image_sim_compare_fast   (ImageSimilarityData *a,
                                               ImageSimilarityData *b,
                                               gfloat               min);

#endif /* __SIMILAR_H__ */

