/*
 * GImageView
 * Copyright (C) 2001 Takuro Ashie
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * $Id: gimv_hpaned.h,v 1.1.2.1 2003/04/22 12:06:20 makeinu Exp $
 */

/*
 * These codes are taken from gThumb.
 * gThumb code Copyright (C) 2001 The Free Software Foundation, Inc.
 * gThumb author: Paolo Bacchilega
 */

#ifndef __GIMV_HPANED_H__
#define __GIMV_HPANED_H__

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include <gdk/gdk.h>
#include "gimv_paned.h"


#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */


#ifndef USE_NORMAL_PANED

#define GIMV_HPANED(obj)          GTK_CHECK_CAST (obj, gimv_hpaned_get_type (), GimvHPaned)
#define GIMV_HPANED_CLASS(klass)  GTK_CHECK_CLASS_CAST (klass, gimv_hpaned_get_type (), GimvHPanedClass)
#define GIMV_IS_HPANED(obj)       GTK_CHECK_TYPE (obj, gimv_hpaned_get_type ())


typedef struct _GimvHPaned       GimvHPaned;
typedef struct _GimvHPanedClass  GimvHPanedClass;

struct _GimvHPaned
{
   GimvPaned paned;
};

struct _GimvHPanedClass
{
   GimvPanedClass parent_class;
};


guint      gimv_hpaned_get_type (void);
GtkWidget* gimv_hpaned_new      (void);

#else /* USE_NORMAL_PANED */

#include <gtk/gtkhpaned.h>

#define GimvHPaned GtkHPaned
#define gimv_hpaned_new() gtk_hpaned_new()

#endif /* USE_NORMAL_PANED */


#ifdef __cplusplus
}
#endif /* __cplusplus */


#endif /* __GIMV_HPANED_H__ */
