/* -*- Mode: C; tab-width: 3; indent-tabs-mode: nil; c-basic-offset: 3 -*- */

/*
 * GImageView
 * Copyright (C) 2001 Takuro Ashie
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * $Id: thumbnail_support.h,v 1.19.2.2 2003/05/13 11:25:57 makeinu Exp $
 */

#ifndef __THUMBNAIL_SUPPORT_H__
#define __THUMBNAIL_SUPPORT_H__

#include "gimv_image.h"
#include <sys/types.h>


/* not completed yet */
typedef enum {
   THUMB_CACHE_CLEAR_STATUS_NORMAL,
   THUMB_CACHE_CLEAR_STATUS_UNKNOWN_ERROR
} ThumbCacheClearStatus;


/* this feature is not implemented yet */
typedef enum {
   THUMB_CACHE_CLEAR_TEST       = 1 << 0, /* confirm whether the plugin can do it or not */
   THUMB_CACHE_CLEAR_ALL        = 1 << 1, /* clear thumbnails under specified directory */
                                          /* other flags will be ignored except
                                             THUMB_CACHE_CLEAR_TEST */
   THUMB_CACHE_CLEAR_OLD        = 1 << 2, /* clear old thumbnails */
   THUMB_CACHE_CLEAR_GARBAGE    = 1 << 3, /* clear thumbnails for not existing images */
   THUMB_CACHE_CLEAR_RECURSIVE  = 1 << 4, /* also clear all sub directories */
   THUMB_CACHE_CLEAR_ASYNC      = 1 << 5
} ThumbCacheClearFlags;


typedef struct ThumbCacheSaveInfo_Tag
{                               /* Key name (Thumbnail Managing Standard) */
   gint      image_width;       /* OriginalWidth */
   gint      image_height;      /* OriginalHeight */
   gint      image_depth;                             /* reserve */
   gint      image_colorspace;                        /* reserve */
   size_t    image_size;        /* OriginalSize  */   /* file size (byte)   */
   time_t    image_mtime;       /* OriginalMTime */   /* modification time  */
   gchar    *comment;
   gchar    *software;          /*   Software    */ 
   gpointer  data;              /* additional data */
} ThumbCacheSaveInfo;


#define GIMV_THUMB_CACHE_LOADER_IF_VERSION 1

typedef GimvImage *(*ThumbCacheLoadFn)             (const gchar *filename,
                                                    const gchar *cache_type,
                                                    ThumbCacheSaveInfo **info);
typedef GimvImage *(*ThumbCacheSaveFn)             (const gchar *filename,
                                                    const gchar *cache_type,
                                                    GimvImage   *image,
                                                    ThumbCacheSaveInfo *info);
typedef gchar     *(*ThumbCacheGetPathFn)          (const gchar *filename,
                                                    const gchar *cache_type);
typedef gboolean   (*ThumbCacheGetSizeFn)          (gint         width,
                                                    gint         height,
                                                    const gchar *cache_type,
                                                    gint        *width_ret,
                                                    gint        *height_ret);

typedef ThumbCacheSaveInfo *(*ThumbCacheGetInfoFn) (const gchar *filename,
                                                    const gchar *cache_type);
typedef gboolean            (*ThumbCachePutInfoFn) (const gchar *filename,
                                                    const gchar *cache_type,
                                                    ThumbCacheSaveInfo *info);

typedef GtkWidget *(*ThumbCacheLoadPrefsFn)        (gpointer data);
typedef GtkWidget *(*ThumbCacheSavePrefsFn)        (gpointer data);

/* if path is file, all flags will be ignored */
typedef ThumbCacheClearStatus (*ThumbCacheClearFn) (const gchar *path,
                                                    const gchar *cache_type,
                                                    ThumbCacheClearFlags flags,
                                                    gpointer unused_yet);

typedef struct ThumbCacheLoader_Tag
{
   const guint32          if_version; /* plugin interface version */
   gchar                 *label;
   ThumbCacheLoadFn       load;
   ThumbCacheSaveFn       save;
   ThumbCacheGetPathFn    get_path;
   ThumbCacheGetSizeFn    get_size;
   ThumbCacheGetInfoFn    get_info;
   ThumbCachePutInfoFn    put_info;
   ThumbCacheLoadPrefsFn  prefs_load;
   ThumbCacheSavePrefsFn  prefs_save;
   ThumbCacheClearFn      clear;
} ThumbCacheLoader;


gchar     *thumbsupport_get_thumb_cache_path   (const gchar *filename,
                                                const gchar *type);
gboolean   thumbsupport_has_thumbnail          (const gchar *filename,
                                                const gchar *type);
GimvImage *thumbsupport_load_thumbnail_cache   (const gchar *filename,
                                                const gchar *type,
                                                ThumbCacheSaveInfo **info);
GimvImage *thumbsupport_save_thumbnail_cache   (const gchar *filename,
                                                const gchar *type,
                                                GimvImage   *image,
                                                ThumbCacheSaveInfo *info);
gboolean   thumbsupport_get_thumb_cache_size   (gint         width,
                                                gint         height,
                                                const gchar *type,
                                                gint        *width_ret,
                                                gint        *height_ret);
gboolean   thumbsupport_has_load_prefs         (const gchar *type);
gboolean   thumbsupport_has_save_prefs         (const gchar *type);
GtkWidget *thumbsupport_get_load_prefs         (const gchar *type,
                                                gpointer     data);
GtkWidget *thumbsupport_get_save_prefs         (const gchar *type,
                                                gpointer     data);

GList     *thumbsupport_get_loader_list        (void);
GList     *thumbsupport_get_saver_list         (void);

/* currentry, only a directory will be accepted,
   and all flags will be ignored */
ThumbCacheClearStatus thumbsupport_clear_cache (const gchar *path,
                                                const gchar *cache_type,
                                                ThumbCacheClearFlags flags,
                                                gpointer     unused_yet);
gboolean thumbsupport_can_clear_cache          (const gchar *path,
                                                const gchar *cache_type);

ThumbCacheSaveInfo *thumbsupport_save_info_new (ImageInfo *info,
                                                gpointer data);
void thumbsupport_save_info_delete (ThumbCacheSaveInfo *save_info);

/* protected */
ThumbCacheSaveInfo *thumbsupport_save_info_new_prot (void);

#endif /* __THUMBNAIL_SUPPORT_H__ */
