/* -*- Mode: C; tab-width: 3; indent-tabs-mode: nil; c-basic-offset: 3 -*- */

/*
 * GImageView
 * Copyright (C) 2001 Takuro Ashie
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * $Id: thumbnail_view_album.h,v 1.1.2.2 2003/05/12 13:00:37 makeinu Exp $
 */

#ifndef __THUMBVIEW_DETAIL2_H__
#define __THUMBVIEW_DETAIL2_H__

#include "gimageview.h"
#include "thumbnail_view.h"

#define THUMBALBUM_LABEL  "Album"
#define THUMBALBUM2_LABEL "Album 2"
#define THUMBALBUM3_LABEL "Album 3"

GList     *thumbalbum_append_thumb_frames      (ThumbView      *tv,
                                                GList          *start,
                                                gchar          *dest_mode);
GtkWidget *thumbalbum_add_thumbnail            (Thumbnail      *thumb,
                                                gchar          *dest_mode,
                                                ThumbLoadType   type);
void       thumbalbum_redraw                   (ThumbView      *tv,
                                                gchar          *mode,
                                                GtkWidget      *scroll_win,
                                                GList         **loadlist);
GtkWidget *thumbalbum_resize                   (ThumbView      *tv);
gboolean   thumbalbum_refresh_thumbnail        (Thumbnail      *thumb,
                                                ThumbLoadType   type);
void       thumbalbum_adjust                   (ThumbView      *tv,
                                                Thumbnail      *thumb);
GtkWidget *thumbalbum_create                   (ThumbView      *tv,
                                                gchar          *dest_mode);
void       thumbalbum_remove_thumbview_data    (ThumbView      *tv);
gboolean   thumbalbum_set_selection            (Thumbnail      *thumb,
                                                gboolean        select);
void       thumbalbum_set_focus                (ThumbView      *tv,
                                                Thumbnail      *thumb);
Thumbnail *thumbalbum_get_focus                (ThumbView      *tv);
gboolean   thumbalbum_thumbnail_is_in_viewport (ThumbView      *tv,
                                                Thumbnail      *thumb);

#endif /* __THUMBVIEW_DETAIL_H__ */
