/* -*- Mode: C; tab-width: 3; indent-tabs-mode: nil; c-basic-offset: 3 -*- */

/*
 * GImageView
 * Copyright (C) 2001 Takuro Ashie
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * $Id: thumbnail_view.h,v 1.42 2003/07/05 16:41:12 makeinu Exp $
 */

#ifndef __THUMBNAIL_VIEW_H__
#define __THUMBNAIL_VIEW_H__

#include <sys/stat.h>
#include <unistd.h>

#include "gimageview.h"

#include "fileload.h"
#include "gfileutil.h"
#include "gimv_thumb_cache.h"

#define DEFAULT_DISP_MODE "Album"
#define DEFAULT_DISP_MODE_NUM 7


typedef enum
{
   THUMB_VIEW_MODE_COLLECTION,
   THUMB_VIEW_MODE_DIR,
   THUMB_VIEW_MODE_RECURSIVE_DIR, /* implemented as THUMB_VIEW_MODE_COLLECTION */
   THUMB_VIEW_MODE_ARCHIVE
} ThumbViewMode;


typedef enum
{
   THUMB_VIEW_STATUS_NORMAL,
   THUMB_VIEW_STATUS_LOADING,
   THUMB_VIEW_STATUS_CHECK_DUPLICATE
} ThumbViewStatus;


typedef enum
{
   THUMB_VIEW_OPEN_IMAGE_AUTO,
   THUMB_VIEW_OPEN_IMAGE_PREVIEW,
   THUMB_VIEW_OPEN_IMAGE_NEW_WIN,
   THUMB_VIEW_OPEN_IMAGE_SHARED_WIN,
   THUMB_VIEW_OPEN_IMAGE_EXTERNAL
} ThumbViewOpenImageType;


struct ThumbView_Tag
{
   /* file (thumbnail) list */
   GList           *thumblist;

   /* parent */
   GimvThumbWin    *thumb_window;
   GtkWidget       *container;
   GtkWidget       *popup_menu;

   gchar           *tabtitle;  /* caution!! must use internal character set */
   gint             ThumbnailSize;

   ThumbViewMode    mode;
   gchar           *dirname;   /* store dir name if mode is dirmode */
   FRArchive       *archive;

   gint             filenum;
   gulong           filesize;

   gchar           *disp_mode;

   /* for DnD */
   gchar           *dnd_destdir;

   /* file load progress infomation */
   ThumbViewStatus  status;
   FilesLoader     *progress;
   GList           *load_list;

   /* mode depended data */
   GHashTable      *disp_mode_data;

   /* list of relation to other object */
   GList           *related_image_view;
   GList           *related_dupl_win;

   /* for mouse event */
   gint             button_2pressed_queue; /* attach an action to
                                              button release event */
};


#define GIMV_THUMBNAIL_VIEW_IF_VERSION 1

/* for thumbnail view modules */
typedef struct ThumbViewPlugin_Tag
{
   const guint32 if_version; /* plugin interface version */

   gchar *label;

   gint priority_hint;

   GtkWidget *(*create_func)                 (ThumbView     *tv,
                                              gchar         *dest_mode);
   GList     *(*add_thumb_frames_func)       (ThumbView     *tv,
                                              GList         *start,
                                              gchar         *dest_mode);
   GtkWidget *(*add_thumb_func)              (GimvThumb     *thumb,
                                              gchar         *dest_mode,
                                              ThumbLoadType  type);
   gboolean   (*refresh_thumb_func)          (GimvThumb     *thumb,
                                              ThumbLoadType  type);
   void       (*remove_thumb_func)           (GimvThumb     *thumb);
   void       (*redraw_func)                 (ThumbView     *tv,
                                              gchar         *mode,
                                              GtkWidget     *scroll_win,
                                              GList        **loadlist);
   GtkWidget *(*resize_func)                 (ThumbView     *tv);
   void       (*adjust_func)                 (ThumbView     *tv,
                                              GimvThumb     *thumb);
   void       (*thumbview_data_remove_func)  (ThumbView     *tv);
   void       (*thumbnail_data_remove_func)  (GimvThumb     *thumb);
   gboolean   (*set_selection_func)          (GimvThumb     *thumb,
                                              gboolean       select);
   void       (*set_focus_func)              (ThumbView     *tv,
                                              GimvThumb     *thumb);
   GimvThumb *(*get_focus_func)              (ThumbView     *tv);
   gboolean   (*thumbnail_is_in_view_func)   (ThumbView     *tv,
                                              GimvThumb     *thumb);
} ThumbViewPlugin;


/* reference callback functions used by child module */
GList       *thumbview_get_list               (void);
gboolean     thumbview_thumb_button_press_cb  (GtkWidget        *widget,
                                               GdkEventButton   *event,
                                               GimvThumb        *thumb);
gboolean     thumbview_thumb_button_release_cb(GtkWidget        *widget,
                                               GdkEventButton   *event,
                                               GimvThumb        *thumb);
gboolean     thumbview_thumb_key_press_cb     (GtkWidget        *widget,
                                               GdkEventKey      *event,
                                               GimvThumb        *thumb);
gboolean     thumbview_thumb_key_release_cb   (GtkWidget        *widget,
                                               GdkEventKey      *event,
                                               GimvThumb        *thumb);
gboolean     thumbview_motion_notify_cb       (GtkWidget        *widget,
                                               GdkEventMotion   *event,
                                               GimvThumb        *thumb);
void         thumbview_drag_begin_cb          (GtkWidget        *widget,
                                               GdkDragContext   *context,
                                               gpointer          data);
void         thumbview_drag_data_received_cb  (GtkWidget        *widget,
                                               GdkDragContext   *context,
                                               gint              x,
                                               gint              y,
                                               GtkSelectionData *seldata,
                                               guint             info,
                                               guint32           time,
                                               gpointer          data);
void         thumbview_drag_data_get_cb       (GtkWidget        *widget,
                                               GdkDragContext   *context,
                                               GtkSelectionData *seldata,
                                               guint             info,
                                               guint             time,
                                               gpointer          data);
void         thumbview_drag_end_cb            (GtkWidget        *widget,
                                               GdkDragContext   *drag_context,
                                               gpointer          data);
void         thumbview_drag_data_delete_cb    (GtkWidget        *widget,
                                               GdkDragContext   *drag_context,
                                               gpointer          data);

void         thumbview_open_image             (ThumbView        *tv,
                                               GimvThumb        *thumb,
                                               gint              type);
void         thumbview_popup_menu             (ThumbView        *tv,
                                               GimvThumb        *thumb,
                                               GdkEventButton   *event);
void         thumbview_file_operate           (ThumbView        *tv,
                                               FileOperateType   type);
void         thumbview_rename_file            (ThumbView        *tv);
gboolean     thumbview_delete_files           (ThumbView        *tv);

/* thumbnail view handling functions used by parent module */
gint         thumbview_label_to_num           (gchar        *label);
gchar       *thumbview_num_to_label           (gint          num);
gchar      **thumbview_get_disp_mode_labels   (gint         *num_ret);
GList       *thumbview_get_disp_mode_list     (void);
void         thumbview_init                   (void);

const gchar *thumbview_get_path               (ThumbView    *tv);
void         thumbview_delete                 (ThumbView    *tv);
ThumbView   *thumbview_find_opened_dir        (const gchar  *path);
ThumbView   *thumbview_find_opened_archive    (const gchar  *path);
void         thumbview_sort_data              (ThumbView    *tv);
gboolean     thumbview_load_thumbnails        (ThumbView    *tv,
                                               GList        *loadlist,
                                               gchar        *dest_mode);
gboolean     thumbview_append_thumbnail       (ThumbView    *tv,
                                               FilesLoader  *files,
                                               gboolean      force);
void         thumbview_redraw                 (ThumbView    *tv,
                                               gchar        *mode,
                                               GtkWidget    *scroll_win,
                                               GList       **loadlist);
void         thumbview_change_mode            (ThumbView    *tv,
                                               gchar        *mode);
gboolean     thumbview_refresh_thumbnail      (GimvThumb    *thumb,
                                               ThumbLoadType type);
gboolean     thumbview_refresh_list           (ThumbView    *tv);
gint         thumbview_refresh_list_idle      (gpointer      data);
GtkWidget   *thumbview_resize                 (ThumbView    *tv);
void         thumbview_adjust                 (ThumbView    *tv,
                                               GimvThumb    *thumb);
GList       *thumbview_get_selection_list     (ThumbView    *tv);
GList       *thumbview_get_selected_file_list (ThumbView    *tv);
gboolean     thumbview_set_selection          (GimvThumb    *thumb,
                                               gboolean      select);
gboolean     thumbview_set_selection_all      (ThumbView    *tv,
                                               gboolean      select);
gboolean     thumbview_set_selection_multiple (GimvThumb    *thumb,
                                               gboolean      reverse,
                                               gboolean      clear);
void         thumbview_set_focus              (ThumbView    *tv,
                                               GimvThumb    *thumb);
GimvThumb   *thumbview_get_focus              (ThumbView    *tv);
void         thumbview_grab_focus             (ThumbView    *tv);
void         thumbview_find_duplicates        (ThumbView    *tv,
                                               GimvThumb    *thumb,
                                               const gchar  *type);
void         thumbview_reset_tab_label        (ThumbView    *tv,
                                               const gchar  *title);
ThumbView   *thumbview_create                 (FilesLoader  *files,
                                               GimvThumbWin *tw,
                                               GtkWidget    *container,
                                               ThumbViewMode mode);
#endif /* __THUMBNAIL_VIEW_H__ */
