#!/usr/bin/env perl

#:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
# This file is part of G-language Genome Analysis Environment package
#
#     Copyright (C) 2001-2007 Keio University
#:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
# 
#   $Id: Reader.pm,v 1.1.1.1 2002/04/02 20:25:38 gaou Exp $
#
# G-language GAE is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2 of the License, or (at your option) any later version.
# 
# G-language GAE is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
# See the GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public
# License along with G-language GAE -- see the file COPYING.
# If not, write to the Free Software Foundation, Inc.,
# 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
# 
#END_HEADER
#

package G::SystemsBiology::EcellReader;

use SubOpt;
use G::Messenger;
use strict;
use vars qw($VERSION @ISA @EXPORT @EXPORT_OK);

use SelfLoader;

require Exporter;

@ISA = qw(Exporter AutoLoader);

@EXPORT = qw(
	     _eri_reader
	     _eri_extracter
);


__DATA__

#::::::::::::::::::::::::::::::
#        Methods Start
#::::::::::::::::::::::::::::::


#_eri_reader ver.20010705-01
#scripting by Koya Mori(s98982km@sfc.keio.ac.jp)
#This program reads e-cell rule files.
#(hash)=&Ecell_rule(string .eri_file,   boolean debug);
sub _eri_reader{
    my $filename=shift;
    my @contents;
    my %RuleHash;
    my $word;
    my $number=1;
    my $s=1;
    my $p=1;
    my $e=1;
    
    
    open(FILE, $filename)|| die("ERROR: file does not exist\n"); 
    &msg_error("open data file $filename\n");

    while(<FILE>){
	tr/\n//d;
	@contents=split /\t/;
	if($contents[0] eq 'SYSTEM'){
	    $RuleHash{$number}{Type}=shift(@contents);
	    $RuleHash{$number}{Class}=shift(@contents);
	    $RuleHash{$number}{Path}=shift(@contents);
	    $RuleHash{$number}{Name}=shift(@contents);
	    foreach $word (@contents){
		$RuleHash{$number}{(split(/ /,$word))[0]}=(split(/ /,$word))[1];
	    }
	    $number++;
	}
	if($contents[0] eq 'SUBSTANCE'){
	    $RuleHash{$number}{Type}=shift(@contents);
	    $RuleHash{$number}{Class}=shift(@contents);
	    ($RuleHash{$number}{Path},$RuleHash{$number}{ID})=split(/:/,shift(@contents));
	    $RuleHash{$number}{Name}=shift(@contents);
	    foreach $word (@contents){
		$RuleHash{$number}{(split(/ /,$word))[0]}=(split(/ /,$word))[1];
	    }
	    $number++;
	}
	if($contents[0] eq 'FIX'){
	    ($RuleHash{$number-1}{FIX_path},$RuleHash{$number-1}{FIX})=split(/:/,$contents[1]);
	}
	if($contents[0] eq 'REACTOR'){
	    $s=$p=$e=1;
	    $RuleHash{$number}{Type}=shift(@contents);
	    $RuleHash{$number}{Class}=shift(@contents);
	    ($RuleHash{$number}{Path},$RuleHash{$number}{ID})=split(/:/,shift(@contents));
	    $RuleHash{$number}{Name}=shift(@contents);
	    foreach $word (@contents){
		if($word=~/Substrate/){
		    ($RuleHash{$number}{"S_path$s"},$RuleHash{$number}{"S_ID$s"})=split(/:/,(split(/ /,$word))[1]);
		    $RuleHash{$number}{"S_Coeff$s"}=(split(/ /,$word))[2];
		    $s++;
		}
		elsif($word=~/Product/){
		    ($RuleHash{$number}{"P_path$p"},$RuleHash{$number}{"P_ID$p"})=split(/:/,(split(/ /,$word))[1]);
		    $RuleHash{$number}{"P_Coeff$p"}=(split(/ /,$word))[2];
		    $p++;
		}
		elsif($word=~/Effector/){
		    ($RuleHash{$number}{"E_path$e"},$RuleHash{$number}{"E_ID$e"})=split(/:/,(split(/ /,$word))[1]);
		    $RuleHash{$number}{"E_Coeff$e"}=(split(/ /,$word))[2];
		    $e++;
		}
		elsif($word=~/Catalyst/){
		    ($RuleHash{$number}{C_path},$RuleHash{$number}{C_ID})=split(/:/,(split(/ /,$word))[1]);
		}
		else{
		    $RuleHash{$number}{Arg_tag}{(split(/ /,$word))[0]}=(split(/ /,$word))[1];
		}
	    }
	    $number++;
	}
	if($contents[0] eq 'Include'){
	    $RuleHash{$number}{Type}=shift(@contents);
	    $RuleHash{$number}{Class}=shift(@contents);    
	}
    }
    return \%RuleHash;
}


#_eri_extracter ver.20010709-01
#scripting by Koya Mori(s98982km@sfc.keio.ac.jp)
#This program prints E-cell eri files.
#&eri_printer(string filename,  string key,  boolean debug);
sub _eri_extracter{
    my $Result=&_eri_reader(shift @_);
    my @ID=@_;
    my @key;
    my @key2;
    my @key3;
    my $tmp;
    my $tmp2;
    my $tmp3;
    my $ID;
    my $switch;
    my $type;
    my $tmp_ID;
    
    $ID[0]=".*" if($ID[0] eq '');

    @key=sort{$a <=> $b} keys(%{$Result});
    foreach $tmp (@key){
	$switch=0;
	$type=0;
	foreach(@ID){
	    if($Result->{$tmp}->{Type}=~/$_/){
		$switch=1;
	    }
	    if($_ eq 'REACTOR' || $_ eq 'SUBSTANCE' || $_ eq 'SYSTEM'){
		$type=1;
	    }
	}
	if($switch==1 || $type==0){
	    if($#ID==0){
		$tmp_ID=$ID[0];
		$ID[0]=".*";
	    }
	    @key2=sort{$a <=> $b} keys(%{$Result->{$tmp}});
	    foreach $tmp2 (sort @key2){
		foreach $ID (@ID){
		    if($tmp2=~/$ID/){
			if($tmp2 eq "Arg_tag"){
			    @key3=sort keys(%{$Result->{$tmp}->{Arg_tag}});
			    foreach $tmp3 (@key3){
				&msg_send($tmp,' -> ',$tmp2,' -> ',$tmp3,' -> ',$Result->{$tmp}->{$tmp2}->{$tmp3},"\n");
			    }
			}
			else{
			    &msg_send($tmp,' -> ',$tmp2,' -> ',$Result->{$tmp}->{$tmp2},"\n");
			}
		    }
		}
	    }
	    if($#ID == 0){
		$ID[0]=$tmp_ID;
		$tmp_ID='';
	    }
	}
    }
}


sub DESTROY {
    my $self = shift;
}

1;
__END__
# Below is the stub of documentation for your module. You better edit it!

=head1 NAME

G::Ecell::Reader - Perl extension for blah blah blah

=head1 SYNOPSIS

  use G::Ecell::Reader;
  blah blah blah

=head1 DESCRIPTION

Stub documentation for G::Ecell::Reader was created by h2xs. It looks like the
author of the extension was negligent enough to leave the stub
unedited.

Blah blah blah.

=head1 AUTHOR

A. U. Thor, a.u.thor@a.galaxy.far.far.away

=head1 SEE ALSO

perl(1).

=cut
