#!/usr/bin/env perl

#:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
# This file is part of G-language Genome Analysis Environment package
#
#     Copyright (C) 2001-2007 Keio University
#:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
# 
#   $Id: Pathway.pm,v 1.1.1.1 2002/04/02 20:25:38 gaou Exp $
#
# G-language GAE is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2 of the License, or (at your option) any later version.
# 
# G-language GAE is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
# See the GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public
# License along with G-language GAE -- see the file COPYING.
# If not, write to the Free Software Foundation, Inc.,
# 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
# 
#END_HEADER
#

package G::SystemsBiology::DotE;

use POSIX;
use SubOpt;
use G::Messenger;
use strict;
use vars qw($VERSION @ISA @EXPORT @EXPORT_OK);

use SelfLoader;

require Exporter;

@ISA = qw(Exporter AutoLoader);
@EXPORT = qw(
	     dote
);

__DATA__

#::::::::::::::::::::::::::::::
#        Methods Start
#::::::::::::::::::::::::::::::

sub dote{
    my $name = $ENV{USER} . "'s model";
    my @argv = opt_get(@_);
    $name = opt_val("name") if(opt_val("name"));
    my $dir = shift @argv;
    
    opendir(DIR, $dir) || die($!);
    mkdir("graph", 0777);
    open(OUT, '>graph/sublist.ecw') || die($!);
    print OUT '&ecsname=' . $name . '&';
    
    my $max = 0;
    my $i = 1;
    foreach my $file (readdir(DIR)){
	last if ($i == 14);
	
	if($file =~ /(.*)\.ecd/){
	    open(FILE, $dir . '/' . $file) || die($!);
	    print OUT '&&s' . $i . '_name=' . $1 . '&';
	    
	    my @lines = ();
	    while(<FILE>){
		chomp;
		my (undef, $val, undef) = split(/\s+/, $_, 3) if(/^\d/);
		push(@lines, $val);
	    }
	    close(FILE);

	    my $j = 0;
	    my $step = int(scalar(@lines)/630);
	    $step = 1 if ($step == 0);
	    for ($j = 1; $j*$step < scalar @lines; $j++){
		printf OUT "\&s%d_%d=%.5f\&", $i, $j, $lines[$j*$step];
	    $max = $lines[$j*$step] if($lines[$j*$step] > $max);
	    }
	    
	    $i ++;
	}
    }
    closedir(DIR);
    
    printf OUT "\&maxs=%s\&", ceil($max);
    close(OUT);

    chdir("graph");
    system("wget -q http://www.g-language.org/~gaou/dote/default.swf"); 
    chdir("../");

    return "graph/default.swf";
}


1;

__END__
# Below is the stub of documentation for your module. You better edit it!

=head1 NAME

G::Ecell::Pathway - Perl extension for blah blah blah

=head1 SYNOPSIS

  use G::Ecell::Pathway;
  blah blah blah

=head1 DESCRIPTION

Stub documentation for G::Ecell::Pathway was created by h2xs. It looks like the
author of the extension was negligent enough to leave the stub
unedited.

Blah blah blah.

=head1 AUTHOR

A. U. Thor, a.u.thor@a.galaxy.far.far.away

=head1 SEE ALSO

perl(1).

=cut
