#!/usr/bin/env perl

#:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
# This file is part of G-language Genome Analysis Environment package
#
#     Copyright (C) 2001-2007 Keio University
#:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
# 
#   $Id: Reader.pm,v 1.8 2002/04/01 14:19:54 t98901ka Exp $
#
# G-language GAE is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2 of the License, or (at your option) any later version.
# 
# G-language GAE is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
# See the GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public
# License along with G-language GAE -- see the file COPYING.
# If not, write to the Free Software Foundation, Inc.,
# 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
# 
#END_HEADER
#

package G::SystemsBiology::Interaction;

use SubOpt;
use G::Messenger;
#use G::SystemsBiology::EcellReader;
use G::Tools::GPAC;
use strict;
use vars qw($VERSION @ISA @EXPORT @EXPORT_OK);

use SelfLoader;

require Exporter;

@ISA = qw(Exporter AutoLoader);
@EXPORT = qw(
	     substance_layout2	     
);

#::::::::::::::::::::::::::::::
#        Constants
#::::::::::::::::::::::::::::::

my %COG_fcode = (
		 J=>"Translation, ribosomal structure and biogenesis",
		 K=>"Transcription",
		 L=>"DNA replication, recombination and repair",
		 D=>"Cell division and chromosome partitioning",
		 O=>"Posttranslational modification, protein turnover, chaperones",
		 M=>"Cell envelope biogenesis, outer membrane",
		 N=>"Cell motility and secretion",
		 P=>"Inorganic ion transport and metabolism",
		 T=>"Signal transduction mechanisms",
		 C=>"Energy production and conservation",
		 G=>"Carbohydrate transport and metabolism",
		 E=>"Amino acid transport and metabolism",
		 F=>"Nucleotide transport and metabolism",
		 H=>"Coenzyme metabolism",
		 I=>"Lipid metabolism",
		 Q=>"Secondary metabolites biosynthesis, transport and catabolism",
		 R=>"General function prediction only",
		 S=>"Function unknown",
		 '-'=>"Non COG"
		 );


__DATA__

#::::::::::::::::::::::::::::::
#        Methods Start
#::::::::::::::::::::::::::::::


sub substance_layout2{
    &opt_default(output=>"show",filename=>"layout2.html", ptt=>"");

    my @args = opt_get(@_);
    my $gb = shift @args;
    my $filename = shift @args;
    my $output = opt_val("output");
    my $outfile = opt_val("filename");
    my $ptt = opt_val("ptt");

    set_gpac($gb, -ptt=>$ptt);

    my %gene2id;
    foreach my $cds ($gb->cds()){
	$gene2id{$gb->{$cds}->{gene}} = $cds;
    }
    
    mkdir("graph", 0777);
    open(FILE, '>graph/' . $outfile);
    print FILE qq(
		  <html>
		  <head>
		  <title>GENESYS: Substance Layout</title>
		  </head>
		  <body>
		  <applet code="GraphInteraction.class" width=800 height=600>
		  ); #"
    
    print FILE '<param name=functionkey value="';
    my $printcode = '';
    foreach my $code (keys %COG_fcode){
	$printcode .= sprintf("%s\#%s,", $code, $COG_fcode{$code});
    }
    print FILE $printcode . '">' . "\n";   #"
    
    my @contents;
    my %RuleHash;
    my $word;
    my $number=1;
    my ($s, $p, $e) = (1,1,1);
    my %Interaction;
    my %sum;

    open(ERI, $filename)|| die("ERROR: file does not exist\n");
    while(<ERI>){
	my @substrate=();
	my @product=();
	my @enzyme=();
	tr/\n//d;
	@contents=split /\t/;
	if($contents[0] eq 'REACTOR'){
	    $s=$p=$e=1;
	    $RuleHash{$number}{Type}=shift(@contents);
	    $RuleHash{$number}{Class}=shift(@contents);
	    
	    ($RuleHash{$number}{Paeth},$RuleHash{$number}{ID})=split(/:/,shift(@contents));
	    $RuleHash{$number}{Name}=shift(@contents);
	    $RuleHash{$number}{Enzyme}= (split(/-/,$RuleHash{$number}{ID}))[0];

	    foreach $word (@contents){
		if($word=~/Substrate/){
		    
		    ($RuleHash{$number}{"S_path$s"},$RuleHash{$number}{"S_ID$s"})=split(/:/,(split(/ /,$word))[1]);
		    $sum{$RuleHash{$number}{"S_ID$s"}}++;
		    push(@substrate,$RuleHash{$number}{"S_ID$s"});
		    $RuleHash{$number}{"S_Coeff$s"}=(split(/ /,$word))[2];
		    $s++;
		}elsif($word=~/Product/){
		    
		    ($RuleHash{$number}{"P_path$p"},$RuleHash{$number}{"P_ID$p"})=split(/:/,(split(/ /,$word))[1]);
		    $sum{$RuleHash{$number}{"P_ID$p"}}++;
		    push(@product,$RuleHash{$number}{"P_ID$p"});
		    $RuleHash{$number}{"P_Coeff$p"}=(split(/ /,$word))[2];
		    $p++;
		}elsif($word=~/Effector/){
		    
		    ($RuleHash{$number}{"E_path$e"},$RuleHash{$number}{"E_ID$e"})=split(/:/,(split(/ /,$word))[1]);
		    $RuleHash{$number}{"E_Coeff$e"}=(split(/ /,$word))[2];
		    $e++;
		}elsif($word=~/Catalyst/){
		    
		    ($RuleHash{$number}{C_path},$RuleHash{$number}{C_ID})=split(/:/,(split(/ /,$word))[1]);
		}else{
		    $RuleHash{$number}{Arg_tag}{(split(/ /,$word))[0]}=(split(/ /,$word))[1];
		}
	    }
	    $Interaction{$number}{substrate} = \@substrate;
	    $Interaction{$number}{product} = \@product;
	    $Interaction{$number}{enzyme} = $RuleHash{$number}{Enzyme};
	    $number++;
	}
	if($contents[0] eq 'Include'){
	    $RuleHash{$number}{Type}=shift(@contents);
	    $RuleHash{$number}{Class}=shift(@contents);
	}
    }
    close(ERI);
    
    my $printinter = '';
    print FILE qq(<param name=interaction value=");
    for(my $num=0; $num<$number-1; $num++){
	for(my $sub=0; $sub<=$#{$Interaction{$num}{substrate}}; $sub++){
	    my $substrate = ${$Interaction{$num}{substrate}}[$sub];
		 for(my $pro=0; $pro<=$#{$Interaction{$num}{product}}; $pro++){
		     my $product = ${$Interaction{$num}{product}}[$pro];
                     $printinter .= "$substrate-$product,";
	         }
       } 
    }
    substr($printinter, -1, 1) = '';
    print FILE $printinter . '">' , "\n";

    my $printinteraction = '';
    my %substance_list;
    print FILE qq(<param name=functionlist value=");
    for(my $num=0; $num<$number-1; $num++){
	for(my $sub=0; $sub<=$#{$Interaction{$num}{substrate}}; $sub++){
	    my $substrate = ${$Interaction{$num}{substrate}}[$sub];
                     if ($substance_list{$substrate} < 1){
                        $printinteraction .= sprintf("%s\#%s,", $substrate, $gb->{$gene2id{$Interaction{$num}{enzyme}}}->{code});
                     }
                     $substance_list{$substrate}++;
		     for(my $pro=0; $pro<=$#{$Interaction{$num}{product}}; $pro++){
		         my $product = ${$Interaction{$num}{product}}[$pro];

                         if ($substance_list{$product} < 1){
                               $printinteraction .= sprintf("%s\#%s,", 
                                   $product, $gb->{$gene2id{$Interaction{$num}{enzyme}}}->{code});
                         }
                         $substance_list{$product} ++;
	            }
       } 
    }
    substr($printinteraction, -1, 1) = '';
    print FILE $printinteraction . '">' , "\n";

    print FILE qq(
  	          </applet>
	          </body>
	          </html>
	         );

    return 1 unless ($output eq 'show');

    chdir("graph");
    system("wget http://www.charite.de/bioinformatics/interaction/Funk.class") unless(-M "Funk.class");
    system("wget http://www.charite.de/bioinformatics/interaction/GraphInteraction.class") unless(-M "GraphInteraction.class");
    system("wget http://www.charite.de/bioinformatics/interaction/GraphPanel.class") unless(-M "GraphPanel.class");
    system("wget http://www.charite.de/bioinformatics/interaction/Member.class") unless(-M "Member.class");
    system("wget http://www.charite.de/bioinformatics/interaction/Interaction.class") unless(-M "Interaction.class");
    system("wget http://www.charite.de/bioinformatics/interaction/Running.class") unless(-M "Running.class");
    system("appletviewer out.html &");
    chdir("../");

    return 1;
}




sub DESTROY {
    my $self = shift;
}

1;
__END__
# Below is the stub of documentation for your module. You better edit it!

=head1 NAME

G::Ecell::Interaction - Perl extension for blah blah blah

=head1 SYNOPSIS

  use G::Ecell::Interaction;
  blah blah blah

=head1 DESCRIPTION

Stub documentation for G::Ecell::Interaction was created by h2xs. It looks like the
author of the extension was negligent enough to leave the stub
unedited.

Blah blah blah.

=head1 AUTHOR

Seira Nakamura, gaou@g-language.org

=head1 SEE ALSO

perl(1).

=cut
