#!/usr/bin/env perl

#:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
# This file is part of G-language Genome Analysis Environment package
#
#     Copyright (C) 2001-2007 Keio University
#:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
# 
#   $Id: Bioperl.pm,v 1.1 2002/07/30 17:44:27 gaou Exp $
#
# G-language GAE is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2 of the License, or (at your option) any later version.
# 
# G-language GAE is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
# See the GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public
# License along with G-language GAE -- see the file COPYING.
# If not, write to the Free Software Foundation, Inc.,
# 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
# 
#END_HEADER
#
# written by Kazuharu Arakawa <gaou@sfc.keio.ac.jp> at
# G-language Project, Institute for Advanced Biosciences, Keio University.
#

package G::IO::Bioperl;

BEGIN{
    eval "use Bio::Perl;";
    if ($@) { warn "$@" };
}

use G::Skyline;
use strict;

sub convert {
    my $bpobj = shift;

    my $tmpname = "G-INTERNAL-" . $ENV{USER} . time() . rand();
    write_sequence(">/tmp/$tmpname.gbk", "genbank", $bpobj);

    my $this = new G::Skyline("/tmp/$tmpname.gbk", "no msg");
    unlink("/tmp/$tmpname.gbk");

    return $this;
}




1;
__END__
# Below is the stub of documentation for your module. You better edit it!

=head1 NAME

    G::IO::Bioperl

=head1 SYNOPSIS

    use G::IO::Bioperl;
    $gb = G::IO::Bioperl::convert($bioperl);

=head1 DESCRIPTION

    This class is intended to be called internally.

=head1 AUTHOR

Kazuharu Arakawa, gaou@sfc.keio.ac.jp

=head1 SEE ALSO

perl(1).

=cut
