#!/usr/bin/env perl

#:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
# This file is part of G-language Genome Analysis Environment package
#
#     Copyright (C) 2001-2007 Keio University
#:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
# 
#   $Id: GPAC.pm,v 1.1 2002/07/30 17:44:27 gaou Exp $
#
# G-language GAE is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2 of the License, or (at your option) any later version.
# 
# G-language GAE is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
# See the GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public
# License along with G-language GAE -- see the file COPYING.
# If not, write to the Free Software Foundation, Inc.,
# 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
# 
#END_HEADER
#

package G::Tools::GOA;

use SubOpt;
use G::Messenger;
use GD::Graph::bars;
use Rcmd;

use strict;
use Cwd;
use vars qw($VERSION @ISA @EXPORT @EXPORT_OK);

use SelfLoader;

require Exporter;

@ISA = qw(Exporter AutoLoader);
@EXPORT = qw(
	     gopac
	     set_goa
	     read_goa
);

__DATA__

#::::::::::::::::::::::::::::::
#        Methods Start
#::::::::::::::::::::::::::::::

sub gopac{
    my $gb = shift;
    my $gopac = shift;
    my $n = 0;

    my $id = $gb->{CDS1}->{feature};
    unless (length($gb->{"FEATURE$id"}->{gopac})){
        set_goa($gb);
    }

    foreach my $cds ($gb->cds('all')){
	if ($gb->{$cds}->{gopac} =~ /$gopac/){
	    $gb->{$cds}->{on} = 1;
	    $n ++;
	}else{
	    $gb->{$cds}->{on} = 0;
	}
    }

    return $n;
}


sub set_goa{
    my $gb = shift;
    my $path = shift || '';
    my $goa = read_goa($path);
    my %codeorder = (IEA=>1, NAS=>2, ISS=>3, IEP=>3,
		     IMP=>4, IGI=>4, IPI=>4, TAS=>5,
		     IDA=>5);

    print STDERR "loaded GOA...\n";

    if ($gb->filepath() =~ /\.embl$/){
	foreach my $cds ($gb->cds()){
	    my $xref = $gb->{$cds}->{db_xref};
	    my $id;
	    if ($xref =~ /SWISS-PROT\:(.*)/ || $xref =~ /UniProt\/TrEMBL:(.*)/){
		$id = $1;
		
		if ($goa->{$id}){
		    my %goanum = (0=>1);
		    foreach my $aspect (keys %{$goa->{$id}}){
			foreach my $i (keys %{$goa->{$id}->{$aspect}}){
			    $gb->{$cds}->{"GO:$aspect"} .= 
				$goa->{$id}->{$aspect}->{$i}->{GO} . ";";
			    $gb->{$cds}->{"GO:$aspect:evidence"} .=
				$goa->{$id}->{$aspect}->{$i}->{evidence} . ";";
			    $goanum{$codeorder{$goa->{$id}->{$aspect}->{$i}->{evidence}}}++;
			}
		    }
		    $gb->{$cds}->{gopac} = join('', (sort keys %goanum));
		}
	    }
	}
    }		
}

sub read_goa{
    my $goa = {};
    my $path = shift;
    $path ||= '/db/genesys/sprot/gene_association.goa_sptr';
    my $n = 0;
    my %codeorder = (IEA=>1, NAS=>2, ISS=>3, IEP=>3,
		     IMP=>4, IGI=>4, IPI=>4, TAS=>5,
		     IDA=>5);

    open(FILE, $path) || die($!);
    while(<FILE>){
	chomp;
	my (undef, $id, $entry, undef, $go, undef, $evidence, undef, $aspect,
	    undef, undef, undef, undef, $date, undef) = split(/\t/, $_, 15);
	$n ++;
	print STDERR "." if ($n %100000 == 0);

	my $i = 1;
	my $flag = 0;
	while(1){
	    if($goa->{$id}->{$aspect}->{$i}->{GO}){
		if($goa->{$id}->{$aspect}->{$i}->{GO} eq $go){
		    if($codeorder{$goa->{$id}->{$aspect}->{$i}->{evidence}} <
		       $codeorder{$evidence})
		    {
			$goa->{$id}->{$aspect}->{$i}->{GO} = $go;
			$goa->{$id}->{$aspect}->{$i}->{evidence} = $evidence;
			$goa->{$id}->{$aspect}->{$i}->{date} = $date;
			$goa->{$id}->{$aspect}->{$i}->{entry} = $entry;
		    }
		    $flag = 1;
		    last;
		}else{
		    $i ++;
		}
	    }else{
		last;
	    }
	}
	next if ($flag);
	
	$goa->{$id}->{$aspect}->{$i}->{GO} = $go;
	$goa->{$id}->{$aspect}->{$i}->{evidence} = $evidence;
	$goa->{$id}->{$aspect}->{$i}->{date} = $date;
	$goa->{$id}->{$aspect}->{$i}->{entry} = $entry;
    }
    close(FILE);
    
    print STDERR "\n";

    return $goa;
}




sub DESTROY {
    my $self = shift;
}

1;
__END__
# Below is the stub of documentation for your module. You better edit it!

=head1 NAME

G::Tools::GOA - Perl extension for blah blah blah

=head1 SYNOPSIS

  use G::Tools::PBS;
  blah blah blah

=head1 DESCRIPTION

Stub documentation for G::Tools::GOA was created by h2xs. It looks like the
author of the extension was negligent enough to leave the stub
unedited.

Blah blah blah.

=head1 AUTHOR

A. U. Thor, a.u.thor@a.galaxy.far.far.away

=head1 SEE ALSO

perl(1).

=cut

