#!/usr/bin/env perl

#:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
# This file is part of G-language Genome Analysis Environment package
#
#     Copyright (C) 2001-2007 Keio University
#:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
# 
#   $Id: Graph.pm,v 1.2 2002/05/27 19:37:55 gaou Exp $
#
# G-language GAE is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2 of the License, or (at your option) any later version.
# 
# G-language GAE is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
# See the GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public
# License along with G-language GAE -- see the file COPYING.
# If not, write to the Free Software Foundation, Inc.,
# 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
# 
#END_HEADER
#

package G::Tools::Graph;

use SubOpt;
use G::Messenger;

use strict;

BEGIN{
    eval "use GD::Graph::lines;";
    if($@){ warn "$@" };
    eval "use Chart::Graph qw(gnuplot);";
    if($@){ warn "$@" };
}

use vars qw($VERSION @ISA @EXPORT @EXPORT_OK);

use SelfLoader;

require Exporter;

@ISA = qw(Exporter AutoLoader);
@EXPORT = qw(
	     _R_base_graph
	     _R_RNA_graph
	     _UniUniGrapher
	     _UniMultiGrapher
);

__DATA__

#::::::::::::::::::::::::::::::
#        Methods Start
#::::::::::::::::::::::::::::::


# _UniMultiGrapher ver.20010906-01
# Author: Kazuharu Arakawa
# Usage: &_UniMultiGrapher(ref y, ref x1, refx2, ...);
# Options:
# -x                  name of x axis (default: x)
# -y                  name of y axis (default: y)
# -x1, -x2, ..., x$i  title of graph x$i (default: x$i)
# -filename           outfile name   (default: graph.gif)
# -style              style of graph (default: lines)
# -type               type of data (default: columns)
# Description:
#   This method creates a two dimensional graph with gnuplot.
#   Multiple x references can be used.
#   Options follow that of Chart::Graph.
# Requirements
#   Chart::Graph qw(gnuplot)
#   SubOpt



sub _UniMultiGrapher {
    &opt_default(x=>"x", y=>"y", title=>"graph", 
		   filename=>"graph.png", type=>"columns",
		 style=>"lines", grapher=>"gnuplot");

    mkdir ("graph", 0777);    
    my @args = opt_get(@_);

    if (opt_val("grapher") eq 'gnuplot' && 'MSWin32' ne $^O){
	my $ref_y = shift @args;
	my @command = ({"title" => opt_val("title"),
			    "output file" => 'graph/' . opt_val("filename"),
			    "x-axis label" => opt_val("x"),
			"y-axis label" => opt_val("y")}, );
	my $i = 1;
	foreach my $ref_x (@args){
	    my $title = opt_val("x$i");
	    $title = "x$i" if ($title eq '');
	    
	    push (@command,
		  [{"title" => $title,
		    "style" => opt_val("style"),
		    "type" => opt_val("type")},
		          $ref_y, $ref_x, ]
		  );
	    $i ++;
	}
    
	gnuplot(@command);
    }else{
	my $graph = GD::Graph::lines->new(640, 480);
	my $skip = int(scalar(@{$args[0]}) / 10);
	   $graph->set(
		       x_label => opt_val("x"),
		       y_label => opt_val("y"),
		       title => opt_val("title"),
		              x_label_skip => $skip,
		       );
	my $i = 1;
	my @legend;
	while(opt_val("x$i")){
	    push (@legend, opt_val("x$i"));
	    $i ++;
	}
	$graph->set_legend(@legend) if (scalar(@legend));
	my $gd = $graph->plot(\@args);

	open(IMG, '>graph/' . opt_val("filename")) or die $!;
	binmode IMG;
	print IMG $gd->png;
	close(IMG);
    }
}

# UniUniGrapher ver.20010829-01
# Author: Kazuharu Arakawa
# Usage: &UniUniGrapher(ref array1, ref array2);
# Options:
# -x        name of x axis (default: x)
# -y        name of y axis (default: y)
# -title    title of graph (default: graph)
# -filename outfile name   (default: graph.gif)
# -style    style of graph (default: lines)
# -type     type of graph  (default: columns)
# Description:
#   This method creates a two dimensional graph with gnuplot.
#   Options follow that of Chart::Graph.
# Requirements
#   Chart::Graph qw(gnuplot)
#   SubOpt


sub _UniUniGrapher {
    &opt_default(x=>"x", y=>"y", title=>"graph", 
		 filename=>"graph.gif",
		 style=>"lines", type=>"columns");

    my @args = opt_get(@_);
    my $array_ref1 = shift;
    my $array_ref2 = shift;
    my $title = shift;
    mkdir("graph", 0777);
    gnuplot(
	    {"title" => opt_val("title"),
	     "output file" => 'graph/' . opt_val("filename"),
	     "x-axis label" => opt_val("x"),
	     "y-axis label" => opt_val("y")},

	    [{"title" => opt_val("title"),
	      "style" => opt_val("style"),
	      "type" => opt_val("type")},
	      $array_ref1, $array_ref2, ],
	     );
}


sub DESTROY {
    my $self = shift;
}

1;
__END__
# Below is the stub of documentation for your module. You better edit it!

=head1 NAME

G::Tools::Graph - Perl extension for blah blah blah

=head1 SYNOPSIS

  use G::Tools::Graph;
  blah blah blah

=head1 DESCRIPTION

Stub documentation for G::Tools::Graph was created by h2xs. It looks like the
author of the extension was negligent enough to leave the stub
unedited.

Blah blah blah.

=head1 AUTHOR

A. U. Thor, a.u.thor@a.galaxy.far.far.away

=head1 SEE ALSO

perl(1).

=cut
