#!/usr/bin/env perl
#:::::::::::::::::::::::::::::::::::::::::::::::::::::::::
#             Genome2Shooting
#
#     Copyright (C) 2001-2007 Keio University
#:::::::::::::::::::::::::::::::::::::::::::::::::::::::::
#
#   $Id: G.pm,v 1.58 2001/11/23 03:43:18 t98901ka Exp $
#
# G-language System is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2 of the License, or (at your option) any later version.
#
# G-language System is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
# See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with G-language System -- see the file COPYING.
# If not, write to the Free Software Foundation, Inc.,
# 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
#
#END_HEADER
#
# written by Kazuharu Arakawa <gaou@g-language.org> at
# G-language Project, Institute for Advanced Biosciences, Keio University.
#

use G;
use File::ShareDir ':ALL';
use Getopt::Long;

my ($speed);
my $sharedir = dist_file('g-language', 'genomes/ecoli.gbk');
$sharedir =~ s/genomes\/ecoli.gbk//;
my $filename = $ARGV[0] ||= "$sharedir/genomes/buchnera.gbk";
GetOptions("ptt=s"=>\$ptt, "speed=s"=>\$speed);
$ptt = "$sharedir/genomes/buchnera.ptt" unless($ptt);

my $gb = new G($ARGV[0], "no msg");
set_gpac($gb, -ptt=>$ptt);
cai($gb, -output=>"NULL", -filename=>"/dev/null");

my $BitMapPath = "$sharedir/g2s";

my %main = (
	    width=>600, height=>600, x=>190, y=>500, jx=>34, jy=>34,
	    timing=>30, lifemax=>10, life=>10, movement=>5, power=>100
	    );;
$main{xmax} = $main{width} - 235;
$main{ymax} = $main{height} - 65;
$main{speed} = $speed ||= 20;
my (@bullet, @enemy, @laser, @item, @wave);
my @cds = $gb->cds();
my $pause = 0;
$main{time} = 0;



package StgApp;

use strict;
use vars qw(@ISA);

@ISA = qw(Wx::App);

use Wx;

sub OnInit {
    my( $this ) = @_;

    my( $frame ) = StgFrame->new( undef, -1, "genome2stg",
                                 [-1, -1], [$main{width}, $main{height}] );

    $frame->Show( 1 );
    $this->SetTopWindow( $frame );

    1;
}


1;







package StgFrame;

use strict;
use vars qw(@ISA);

use Wx qw(wxMENU_TEAROFF wxBLACK); 
use Wx::Event qw(EVT_MENU EVT_CLOSE);

@ISA = qw(Wx::Frame);

sub new {
    my $class = shift;
    my( $this ) = $class->SUPER::new( @_ );

    $main::panel = StgPanel->new( $this );
    $main::panel->SetBackgroundColour(wxBLACK);

    $this->SetIcon( Wx::GetWxPerlIcon() );
    
    my( $file_menu ) = Wx::Menu->new( '', wxMENU_TEAROFF );
    $file_menu->Append( 4, "E&xit\tCtrl-Q", 'Quit genome2stg' );

    my( $menu_bar ) = Wx::MenuBar->new();
    $menu_bar->Append( $file_menu, '&File' );

    my( $help_menu ) = Wx::Menu->new();
    $help_menu->Append( 3, "&About" );

    $menu_bar->Append( $help_menu, 
		       '                       genome2stg of ' . 
		       $gb->{FEATURE0}->{organism} . '         ' . length($gb->{SEQ}) . " bp");

    $this->SetMenuBar( $menu_bar );

    EVT_MENU( $this, 4, \&OnQuit );
    EVT_MENU( $this, 3, \&OnAbout );
    EVT_CLOSE( $this, \&OnClose );

    $this;
}


sub OnQuit {
  my $this = shift;

  $this->OnClose();
}



sub OnAbout {
  my $this = shift;

  use Wx qw(wxOK wxCENTRE);

  Wx::MessageBox( "genome2stg on G-language GAE\n\nKazuharu Arakawa (gaou\@g-language.org)\n\nCopyright(C) 2002 G-language Project\nInstitute for Advanced Biosciences\nKeio University\n\nhttp://www.g-language.org/\n\nSpecial thanks to akis (http://member.nifty.ne.jp/akis/) for 2D graphics,\nand Takahiro Arakawa for 3D graphics.", "About genome2stg", wxOK|wxCENTRE, $this );
}



sub OnClose {
  my( $this ) = shift;

  $pause = 1;
  $this->Destroy;

}



sub DESTROY {
    my $self = shift;

    $self->{TIMER}->Destroy;
}


1;














package StgPanel;

use strict;
use vars qw(@ISA);
use Wx qw(wxDefaultPosition wxDefaultSize wxBITMAP_TYPE_BMP wxBLACK 
	  wxGA_HORIZONTAL wxNO_BORDER wxWHITE_PEN wxCLIP_CHILDREN);
use Wx::Event qw(EVT_KEY_UP EVT_KEY_DOWN EVT_TIMER EVT_PAINT);

@ISA = qw(Wx::ScrolledWindow);

my $len = length $gb->{SEQ};

sub new {
    my ($class, $frame) = @_;
    my $this = $class->SUPER::new($frame,-1,wxDefaultPosition, wxDefaultSize, wxCLIP_CHILDREN);

    foreach my $tmp (qw(jiki left right up bullet panel teki1 teki2 teki3 teki4 teki5 
			bomb1 bomb2 bomb3 laser ready over wave go 
			completed congrat cureitem fireitem)){
	$main{$tmp} = Wx::Bitmap->new( sprintf("%s/%s.bmp", $BitMapPath, $tmp), wxBITMAP_TYPE_BMP);
	$main{$tmp}->SetMask(Wx::Mask->new($main{$tmp}, wxBLACK));
    }

    $main{bmp} = Wx::StaticBitmap->new( $this, -1, $main{jiki}, [$main{x}, $main{y}] );
    Wx::StaticText->new( $this, 1, "bp", [$main{xmax} + 160, 280]);
    $main{counter} = Wx::StaticText->new($this, 1, 0, [$main{xmax} + 100, 280]);
    $main{gene} = Wx::StaticText->new($this, 1, "next gene: " . $gb->{$cds[0]}->{gene}, [$main{xmax} + 70, 240]);

    $main{gauge} = Wx::Gauge->new($this, -1, $main{lifemax}, [$main{xmax} + 34 + 35, $main{ymax} - 75], [130, 20], 
				  wxGA_HORIZONTAL|wxNO_BORDER);
    $main{gauge}->SetValue($main{lifemax});
    $main{gauge}->Refresh();

    $main{energy} = Wx::Gauge->new($this, -1, 1000, [$main{xmax} + 34 + 35, $main{ymax} - 170], [130, 20], 
				  wxGA_HORIZONTAL|wxNO_BORDER);
    $main{energy}->SetValue($main{power});
    $main{energy}->Refresh();

    $main{timer} = Wx::Timer->new($this, 1);
    $main{timer}->Start($main{timing});

    EVT_PAINT($this, \&OnPaint);
    EVT_TIMER($this, 1, \&OnTimer);
    EVT_KEY_DOWN($this, \&OnKeyDown);
    EVT_KEY_UP($this, \&OnKeyUp);

    return $this;
}

sub OnTimer{
    my $this = shift;

    if ($main{time} == 0){
	$main{tmptime} ++;
	if ($main{tmptime} == 1){
	    $main{ready} = Wx::StaticBitmap->new( $this, -1, $main{ready}, [140, 250]);
	}elsif($main{tmptime} == 30){
	    $main{ready}->Destroy();
	    $main{ready} = Wx::StaticBitmap->new( $this, -1, $main{go}, [170, 250]);
	}elsif($main{tmptime} == 50){
	    $main{ready}->Destroy();
	    $main{time}++;
	}
	return;
    }
    return if ($pause);

    $main{time} ++;

    if ($main{power} < 1000 && $main{time} % 20 == 0){
	$main{power} += 20;
	$main{energy}->SetValue($main{power});
	$main{energy}->Refresh();
    }

    $main{counter}->SetLabel($main{time} * $main{speed}) 
	unless ($main{time} * $main{speed}>= $len);

    if (scalar(@cds) == 0){
	$main{gene}->SetLabel("no more genes");
    }elsif ($main{time} * $main{speed} > $gb->{$cds[0]}->{start}){
	my $enemy_cds = shift @cds;
	$main{gene}->SetLabel("next gene: " . $gb->{$cds[0]}->{gene});
	push(@enemy, StgEnemy->new($this, $enemy_cds));
    }

    if ($main{316} == 1 && $main{x} - $main{movement} >= 0){
	$main{x} -= $main{movement};
	$main{bmp}->Destroy();
	$main{bmp} = Wx::StaticBitmap->new( $this, -1, $main{left}, [$main{x}, $main{y}] );
    }elsif ($main{317} == 1 && $main{y} - $main{movement} >= 0){
	$main{y} -= $main{movement};
	$main{bmp}->Destroy();
	$main{bmp} = Wx::StaticBitmap->new( $this, -1, $main{up}, [$main{x}, $main{y}] );
    }elsif ($main{318} == 1 && $main{x} + $main{movement} <= $main{xmax}){
	$main{x} += $main{movement};
	$main{bmp}->Destroy();
	$main{bmp} = Wx::StaticBitmap->new( $this, -1, $main{right}, [$main{x}, $main{y}] );
    }elsif ($main{319} == 1 && $main{y} + $main{movement} <= $main{ymax}){
	$main{y} += $main{movement};
	$main{bmp}->Destroy();
	$main{bmp} = Wx::StaticBitmap->new( $this, -1, $main{jiki}, [$main{x}, $main{y}] );
    }

    if ($main{playerhit}){
	$main{playerhit} --;
	if ($main{playerhit} == 0){
	    $main{bmp}->SetBitmap($main{jiki});
	}
    }

    if ($main{life} == 0){
	$main{overtime} ++;
	$main{clear} = 1;
	foreach my $tmp (qw(316 317 318 319)){ $main{$tmp} = 0; }

	if ($main{overtime} == 1 || $main{overtime} == 21 || $main{overtime} == 41){
	    $main{bmp}->SetBitmap($main{bomb1});
	}elsif ($main{overtime} == 6 || $main{overtime} == 16 || 
		$main{overtime} == 26 || $main{overtime} == 36 || $main{overtime} == 46){
	    $main{bmp}->SetBitmap($main{bomb2});
	}elsif ($main{overtime} == 11 || $main{overtime} == 31 || $main{overtime} == 51){
	    $main{bmp}->SetBitmap($main{bomb3});
	}elsif ($main{overtime} == 56){
	    $main{bmp}->Destroy();
	    $pause = 1;
	    $main{ready} = Wx::StaticBitmap->new( $this, -1, $main{over}, [100, 250]);
	    return;
	}
    }

    if (scalar @bullet > 0){
	my @newbullet;
	foreach my $bulletobj (@bullet){
	    if ($bulletobj->move()){
		push(@newbullet, $bulletobj);
	    }else{
#		$bulletobj->DESTROY();
		undef $bulletobj;
	    }
	}
	@bullet = @newbullet;
    }

    if (scalar @wave > 0){
	my @newwave;
	foreach my $waveobj (@wave){
	    if ($waveobj->move()){
		push(@newwave, $waveobj);
	    }else{
#		$waveobj->{obj}->Destroy();
		undef $waveobj;
	    }
	}
	@wave = @newwave;
    }

    if (scalar @laser > 0){
	my @newlaser;
	foreach my $laserobj (@laser){
	    if ($laserobj->move()){
		push(@newlaser, $laserobj);
	    }else{
#		$laserobj->DESTROY();
		undef $laserobj;
	    }
	}
	@laser = @newlaser;
    }

    if (scalar @item > 0){
	my @newitem;
	foreach my $itemobj (@item){
	    if ($itemobj->move()){
		push(@newitem, $itemobj);
	    }else{
#		$itemobj->{obj}->Destroy();
		undef $itemobj;
	    }
	}
	@item = @newitem;
    }

    if (scalar @enemy > 0){
	my @newenemy;
	foreach my $enemobj (@enemy){
	    if ($enemobj->{hit} > 0){
		$enemobj->{hit} --;

		if ($enemobj->{hit} == 0){
#		    $enemobj->{obj}->Destroy();
		    undef $enemobj;
		}else{
		    if ($enemobj->{hit} == 1){
			$enemobj->{obj}->SetBitmap($main{bomb1});
		    }elsif ($enemobj->{hit} == 2){
			$enemobj->{obj}->SetBitmap($main{bomb2});
		    }
		    push(@newenemy, $enemobj);
		}
	    }else{
		$enemobj->move();
		$enemobj->hantei();
		push(@newenemy, $enemobj);
	    }
	}
	@enemy = @newenemy;
    }elsif(scalar(@enemy) < 1 && $main{time} * $main{speed} >= $len){
	unless($main{clear}){
	    $main{congrate} = Wx::StaticBitmap->new( $this, -1, $main{congrat}, [55, 190]);
	    $main{completede} = Wx::StaticBitmap->new( $this, -1, $main{completed}, [35, 280]);	
	    $main{clear} = 1;
	}
	$pause = 1;
    }
}

sub OnPaint{
    my ($this, $event) = @_;

    $main{pa2} = Wx::PaintDC->new($this);
    $main{pa2}->SetPen(wxWHITE_PEN);
    $main{pa2}->DrawBitmap($main{panel}, $main{xmax} + 34, 0, 0);

    my $i = 0;
    for ($i = 0; $i <= $main{ymax} + $main{jy}; $i ++){
	if (rand(1) < 0.2){
	    $main{pa2}->DrawPoint(int(rand($main{xmax}+$main{jx})), $i);
	}
    }
}

sub OnKeyUp{
    my ($this, $event) = @_;

    if ($event->GetKeyCode() == 316 || $event->GetKeyCode() == 317 ||
	$event->GetKeyCode() == 318 || $event->GetKeyCode() == 319){
	$main{$event->GetKeyCode()} = 0;
	$main{bmp}->SetBitmap($main{jiki}) unless($main{clear});
    }

    $event->Skip();
}

sub OnKeyDown{
    my ($this, $event) = @_;

    return if ($main{clear});

    if ($event->GetKeyCode() == 316 || $event->GetKeyCode() == 317 ||
	$event->GetKeyCode() == 318 || $event->GetKeyCode() == 319){
	foreach my $num (qw(316 317 318 319)){
	    if ($event->GetKeyCode() == $num){
		$main{$num} = 1;
	    }else{
		$main{$num} = 0;
	    }
	}
    }elsif ($event->GetKeyCode() == 32 && scalar @bullet < 5){
	push(@bullet, StgBullet->new($this));
    }elsif ($event->GetKeyCode() == 306 && $main{power} >= 200){
	push(@wave, StgWave->new($this));
	$main{power} -= 200;
	if($main{power} < 0){
	    $main{power} = 0;
	}
    }elsif ($event->GetKeyCode() == 80){
	if ($pause){
	    $pause = 0;
	}else{
	    $pause = 1;
	    $main{counter}->SetLabel("PAUSE");
	}
    }	

    $event->Skip();
}

1;







package StgBullet;

use Wx;

sub new {
    my ($class, $panel, $y) = @_;
    my $x = int(rand($main{xmax}+$main{jx}));
    my $this;
    $this->{pos} = [$main{x}+12,$main{y}-20];
    $this->{panel} = $panel;

    $this->{obj} = Wx::StaticBitmap->new( $panel, -1, $main{bullet}, $this->{pos});

    return bless $this;
}

sub move {
    my $this = shift;

    if ($this->{pos}[1] < 0){
	return 0;
    }else{
	$this->{pos}[1] -= 7;
	$this->{obj}->Destroy();
	$this->{obj} = Wx::StaticBitmap->new( $this->{panel}, -1, $main{bullet}, $this->{pos});

	return 1;
    }
}

sub DESTROY {
    my $this = shift;

    $this->{obj}->Destroy();
}

1;







package StgWave;

use Wx;

sub new {
    my ($class, $panel, $y) = @_;
    my $x = int(rand($main{xmax}+$main{jx}));
    my $this;
    $this->{pos} = [$main{x}-30,$main{y}-30];
    $this->{panel} = $panel;

    $this->{obj} = Wx::StaticBitmap->new( $panel, -1, $main{wave}, $this->{pos});

    return bless $this;
}

sub move {
    my $this = shift;

    if ($this->{pos}[1] < 0){
	return 0;
    }else{
	$this->{pos}[1] -= 12;
	$this->{obj}->Destroy();
	$this->{obj} = Wx::StaticBitmap->new( $this->{panel}, -1, $main{wave}, $this->{pos});

	return 1;
    }
}


sub DESTROY {
    my $this = shift;

    $this->{obj}->Destroy();
}

1;








package StgLaser;

use Wx;

sub new {
    my ($class, $panel, $x, $y) = @_;
    my $this;
    $this->{pos} = [$x+12,$y-20];
    $this->{panel} = $panel;

    $this->{obj} = Wx::StaticBitmap->new( $panel, -1, $main{laser}, $this->{pos});

    return bless $this;
}

sub move {
    my $this = shift;

    if ($this->{pos}[1] > $main{ymax} + 34){
	return 0;
    }else{
	$this->{pos}[1] += 7;
	$this->{obj}->Destroy();
	$this->{obj} = Wx::StaticBitmap->new( $this->{panel}, -1, $main{laser}, $this->{pos});
	if ($this->hantei()){
	    return 0;
	}else{
	    return 1;
	}
    }
}

sub hantei{
    my $this = shift;
    my $hit = 0;

    if (scalar @wave > 0){
	foreach my $waveobj (@wave){
	    if ($waveobj->{pos}[0] + 60 >= $this->{pos}[0] && $waveobj->{pos}[0] <= $this->{pos}[0] + 5
		&& $waveobj->{pos}[1] + 40 >= $this->{pos}[1] && $waveobj->{pos}[1] <= $this->{pos}[1] + 31){
		$hit = 1;
	    }
	}
    }

    if ($main{x} + 34 >= $this->{pos}[0] && $main{x} <= $this->{pos}[0] + 5
	&& $main{y} + 34 >= $this->{pos}[1] && $main{y} <= $this->{pos}[1] + 31){
	player_hit();
	$hit = 1;
    }
    return $hit;
}

sub player_hit{
    $main{playerhit} = 4;
    $main{bmp}->SetBitmap($main{bomb3});
    $main{life} -- unless($main{life} == 0);
    $main{gauge}->SetValue($main{life});
    $main{gauge}->Refresh();
}
 
sub DESTROY {
    my $this = shift;

    $this->{obj}->Destroy();
}

1;








package StgItem;

use Wx;

sub new {
    my ($class, $panel, $x, $y, $type) = @_;
    my $this;
    $this->{pos} = [$x,$y-10];
    $this->{panel} = $panel;
    $this->{type} = $type;
    $this->{obj} = Wx::StaticBitmap->new( $panel, -1, $main{$type . "item"}, $this->{pos});

    return bless $this;
}

sub move {
    my $this = shift;

    if ($this->{pos}[1] > $main{ymax} + 34){
	return 0;
    }else{
	$this->{pos}[1] ++;
	$this->{obj}->Destroy();
	$this->{obj} = Wx::StaticBitmap->new( $this->{panel}, -1, $main{$this->{type} . "item"}, $this->{pos});
	if ($this->hantei()){
	    return 0;
	}else{
	    return 1;
	}
    }
}

sub hantei{
    my $this = shift;
    my $hit = 0;

    if ($main{x} + 34 >= $this->{pos}[0] && $main{x} <= $this->{pos}[0] + 34
	&& $main{y} + 34 >= $this->{pos}[1] && $main{y} <= $this->{pos}[1] + 20){
	$this->player_hit();
	$hit = 1;
    }
    return $hit;
}

sub player_hit{
    my $this = shift;

    if ($this->{type} eq 'cure'){
	return if ($main{life} == $main{lifemax});
	$main{life} += 2;
	$main{life} = $main{lifemax} if ($main{life} > $main{lifemax});
	$main{gauge}->SetValue($main{life});
	$main{gauge}->Refresh();
    }else{
	return if ($main{power} == 1000);
	$main{power} += 200;
	$main{power} = 1000 if ($main{power} > 1000);
	$main{energy}->SetValue($main{power});
	$main{energy}->Refresh();
    } 
}
 
sub DESTROY {
    my $this = shift;

    $this->{obj}->Destroy();
}

1;










package StgEnemy;

use Wx;

my %COGnum = (
		 J=>1,        K=>1,         L=>2,
                 D=>2,        O=>3,         M=>3,
                 N=>3,        P=>3,         T=>3,
                 C=>4,        G=>4,         E=>4,
	         F=>4,        H=>4,         I=>4,
                 Q=>4,        R=>5,         S=>5,
	         U=>5,
                 '-'=>5,
                 );

sub new {
    my ($class, $panel, $cds) = @_;
    my $x = 0;
    $x = $main{xmax}-$main{jx} if ($gb->{$cds}->{direction} eq 'complement');

    my $this;
    $this->{cds} = $cds;
    $this->{pos} = [$x,50];
    $this->{gpac} = $gb->{$cds}->{gpac};
    $this->{panel} = $panel;
    $this->{cai} = $gb->{$cds}->{cai} ** 10;
    $this->{id} = $COGnum{$gb->{$cds}->{code}};
    unless(length $this->{id}){
	$this->{id} = 5;
    }
    $this->{obj} = Wx::StaticBitmap->new( $panel, -1, $main{bullet}, $this->{pos});

    return bless $this;
}

sub move {
    my $this = shift;

    my $x = 4 * $this->sign('x') + $this->{pos}[0];
    $x = 0 if ($x < 0);
    $x = $main{xmax} if ($x > $main{xmax});
    my $y = 4 * $this->sign('y') + $this->{pos}[1];
    $y = 0 if ($y < 0);
    $y = $main{ymax} if ($y > $main{ymax});
    $this->{pos} = [$x,$y];

    if (rand(1) < $this->{cai}){
	push(@laser, StgLaser->new($this->{panel}, @{$this->{pos}}));
    }
    $this->{obj}->Destroy();
    $this->{obj} = Wx::StaticBitmap->new( $this->{panel}, -1, $main{"teki" . $this->{id}}, $this->{pos});

    return 1;
}

sub sign{
    my $this = shift;
    my $dir = shift;
    my $rand = rand(3);

    if ($this->{'count' . $dir} > 0){
	$this->{'count' . $dir} --;
    }else{
	my $sign = 1;
	if ($rand < 1){
	    $sign = -1;
	}elsif ($rand < 2){
	    $sign = 0;
	}
	$this->{'count' . $dir} = 7;
	$this->{'sign' . $dir} = $sign;
    }
    return $this->{'sign' . $dir};
}

sub hantei{
    my $this = shift;
    my $hit = 0;

    if (scalar @bullet > 0){
	my @newbullet;
	foreach my $bulletobj (@bullet){
	    if ($bulletobj->{pos}[0] - 10 >= $this->{pos}[0] && $bulletobj->{pos}[0] <= $this->{pos}[0] + 33
		&& $bulletobj->{pos}[1] + 31 >= $this->{pos}[1] && $bulletobj->{pos}[1] <= $this->{pos}[1] + 33){
		$hit = 1;
		$this->{hit} = 5;
		$this->{obj}->SetBitmap($main{bomb1});
		if ($this->{gpac} =~ /4/ && rand(1) < 0.1){
		    if (rand(1) < 0.5){
			push(@item, StgItem->new($this->{panel}, @{$this->{pos}}, "cure"));	
		    }else{
			push(@item, StgItem->new($this->{panel}, @{$this->{pos}}, "fire"));
		    }
		}
		undef $bulletobj;
	    }else{
		push(@newbullet, $bulletobj);
	    }
	}
	@bullet = @newbullet;
    }

    if (scalar @wave > 0){
	foreach my $waveobj (@wave){
	    if ($waveobj->{pos}[0] + 60 >= $this->{pos}[0] && $waveobj->{pos}[0] <= $this->{pos}[0] + 33
		&& $waveobj->{pos}[1] + 20 >= $this->{pos}[1] && $waveobj->{pos}[1] <= $this->{pos}[1] + 33){
		$hit = 1;
		$this->{hit} = 5;
		$this->{obj}->SetBitmap($main{bomb1});
		if ($this->{gpac} =~ /4/ && rand(1) < 0.2){
		    if (rand(1) < 0.5){
			push(@item, StgItem->new($this->{panel}, @{$this->{pos}}, "cure"));	
		    }else{
			push(@item, StgItem->new($this->{panel}, @{$this->{pos}}, "fire"));
		    }
		}
	    }
	}
    }

    if ($main{x} + 34 >= $this->{pos}[0] && $main{x} <= $this->{pos}[0] + 33
	&& $main{y} + 34 >= $this->{pos}[1] && $main{y} <= $this->{pos}[1] + 33){
	player_hit();
	$hit = 1;
	$this->{hit} = 5;
	$this->{obj}->SetBitmap($main{bomb1});
    }
    return $hit;
}

sub player_hit{
    $main{playerhit} = 4;
#    $main{bmp}->SetBitmap($main{bomb3});
    $main{life} -- unless($main{life} == 0);;
    $main{gauge}->SetValue($main{life});
    $main{gauge}->Refresh();
}
 
sub DESTROY {
    my $this = shift;

    $this->{obj}->Destroy();
}

1;




package main;

my( $app ) = StgApp->new();
$app->MainLoop();

1;









