#!/usr/bin/env perl

#:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
# This file is part of G-language Genome Analysis Environment package
#
#     Copyright (C) 2001-2007 Keio University
#:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
# 
#   $Id: FreeEnergy.pm,v 1.1.1.1 2002/04/02 20:25:41 gaou Exp $
#
# G-language GAE is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2 of the License, or (at your option) any later version.
# 
# G-language GAE is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
# See the GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public
# License along with G-language GAE -- see the file COPYING.
# If not, write to the Free Software Foundation, Inc.,
# 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
# 
#END_HEADER
#

package G::Seq::FreeEnergy;

use SubOpt;
use G::Messenger;
use G::Tools::Graph;

use strict;

use SelfLoader;

require Exporter;

our @ISA = qw(Exporter);
our @EXPORT = qw(
	     RNAfold
	     foreach_RNAfold
);

__DATA__

#:::::::::::::::::::::::::::::::::
#       Perldoc
#:::::::::::::::::::::::::::::::::


=head1 NAME

  G::Seq::FreeEnergy - Analysis methods related to FreeEnergy

=head1 DESCRIPTION

    This class is a part of G-language Genome Analysis Environment, 
    collecting sequence analysis methods related to GC skew.

=cut

#::::::::::::::::::::::::::::::
#        Methods Start
#::::::::::::::::::::::::::::::


#RNAfold 2001715
#Auther:Naoki Okubo
#This program executes RNAfold.
#usage:&RNAfold(pointer Genome,  int start_position,  int end_position);
sub RNAfold{
    &opt_default(output=>"stdout",filename=>'FreeEnergy.csv');
    my @args=opt_get(@_);

    my $seq=shift @args;
    my $start=shift @args;
    my $end=shift @args;
    my $filename=opt_val("filename");
    my $rna_fold_result;
    my $sq;
    my $num;
    my $result;

    $sq = substr($seq,$start,$end-$start + 1);
    $rna_fold_result=qx!echo $sq | RNAfold!;
    $num++;
#    $result=(split(/\s\(\s/,$rna_fold_result))[1];
#    $result=~tr/\)\n//d;
# unable to retrive sequence over 58 letters
# suggested by Atsuko Kisi and Hayataro Kouchi

    $result = (split(/\(/, $rna_fold_result))[-1];
    chomp($result);
    $result =~ s/\)//;

    if(&opt_val("output") eq "stdout"){
	&msg_send($result,"\n");
    }
    if(&opt_val("output") eq "f"){
	open(FILE,">>$filename");
	print FILE $result,"\n";
	close(FILE);
    }
    
    mkdir("graph",0777);
    system('mv','rna.ps','graph/');

    return $result;
}


#RNAfold 2001715
#Auther:Naoki Okubo
#This program executes RNAfold.
#&RNAfoldG(pointer seq,  int start,  int end,  int  number,  boolean debug);
sub foreach_RNAfold{
    &opt_default(window=>50,output=>"show",filename=>"FreeEnergy.csv");
    my @args=opt_get(@_);
    
    my $seq=shift @args;
    my $start=shift @args;
    my $end=shift @args;
    my $number=opt_val("window");
    my $printer=opt_val("output");
    my $filename=opt_val("filename");
    my $i;
    my $cut;
    my $array;
    my $rna_fold_result;
    my $sq;
    my $num;
    my $x;
    my $y;
    my @y;
    my @RNA;


    if($printer=~/f/){
	open(FILE,">$filename");
    }

    $cut = substr($$seq,$start,$end-$start);


    for($i=0 ; $i<=length($cut)-$number ; $i=$i+1){
 
        $y=$i+$start;
        $sq = substr($$seq,$y,$number);


        $rna_fold_result=qx!echo $sq | RNAfold!;
        $num++;
        $rna_fold_result=~tr/()//d;
        $rna_fold_result=~tr/[A-Z]\n//d;
        $rna_fold_result=~s/\.\.//g;
        $rna_fold_result=~s/\.\ //g;
	$rna_fold_result=~tr/ //d;
	push(@RNA,$rna_fold_result);

	if($printer=~/f/){
	    print FILE $y,",",$y+$number,",",$rna_fold_result,"\n";
	}
	if($printer!~/[fn]/){
	    &msg_send($y,"..",$y+$number,"\t",$rna_fold_result,"\n");
 	}
	push(@y,$y);
    }
    
    unlink("rna.ps");

    if($printer=~/g/ || $printer=~/show/){
        &G::Tools::Graph::_UniMultiGrapher(\@y,\@RNA,-filename=>"FreeEnergy.png",-x=>"position",-y=>"free energy",-title=>"free energy");
    }

    msg_gimv('graph/FreeEnergy.png') if($printer=~/show/);

    return \@RNA;
}


1;
