#!/usr/bin/env perl

#:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
# This file is part of G-language Genome Analysis Environment package
#
#     Copyright (C) 2001-2007 Keio University
#:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
# 
#   $Id: Reader.pm,v 1.8 2002/04/01 14:19:54 t98901ka Exp $
#
# G-language GAE is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2 of the License, or (at your option) any later version.
# 
# G-language GAE is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
# See the GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public
# License along with G-language GAE -- see the file COPYING.
# If not, write to the Free Software Foundation, Inc.,
# 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
# 
#END_HEADER
#

package G::SystemsBiology::BioLayout;

use SubOpt;
use G::Messenger;
#use G::SystemsBiology::EcellReader;
use strict;
use vars qw($VERSION @ISA @EXPORT @EXPORT_OK);

use SelfLoader;

require Exporter;

@ISA = qw(Exporter AutoLoader);
# Items to export into callers namespace by default. Note: do not export
# names by default without a very good reason. Use EXPORT_OK instead.
# Do not simply export all your public functions/methods/constants.
@EXPORT = qw(
	     enzyme_layout
	     substance_layout	     
);


__DATA__

#::::::::::::::::::::::::::::::
#        Methods Start
#::::::::::::::::::::::::::::::

sub enzyme_layout{
    &opt_default(output=>"show",filename=>"enzyme_layout.txt", limit=>30);
    my @args = opt_get(@_);
    my $filename = shift @args;
    my $output = opt_val("output");
    my $outfile = opt_val("filename");
    my $limit = opt_val("limit");
    my @contents;
    my %RuleHash;
    my $word;
    my $number=1;
    my $s=1;
    my $p=1;
    my $e=1;
    my %Interaction;
    my %sum;

    open(FILE, $filename)|| die("ERROR: file does not exist\n");
    &msg_error("open data file $filename\n");
    while(<FILE>){
	my @substrate=();
	my @product=();
	my @enzyme=();
	tr/\n//d;
         @contents=split /\t/;
	if($contents[0] eq 'REACTOR'){
	    $s=$p=$e=1;
	    $RuleHash{$number}{Type}=shift(@contents);
	    $RuleHash{$number}{Class}=shift(@contents);
	    
	    ($RuleHash{$number}{Path},$RuleHash{$number}{ID})=split(/:/,shift(@contents));
	    $RuleHash{$number}{Name}=shift(@contents);
	    $RuleHash{$number}{Enzyme}=(split(/ /,$RuleHash{$number}{Name}))[2];
	    foreach $word (@contents){
		if($word=~/Substrate/){
		    
		    ($RuleHash{$number}{"S_path$s"},$RuleHash{$number}{"S_ID$s"})=split(/:/,(split(/ /,$word))[1]);
		    $sum{$RuleHash{$number}{"S_ID$s"}}++;
		    push(@substrate,$RuleHash{$number}{"S_ID$s"});
		    $RuleHash{$number}{"S_Coeff$s"}=(split(/ /,$word))[2];
		    $s++;
		}elsif($word=~/Product/){
		    
		    ($RuleHash{$number}{"P_path$p"},$RuleHash{$number}{"P_ID$p"})=split(/:/,(split(/ /,$word))[1]);
		    $sum{$RuleHash{$number}{"P_ID$p"}}++;
		    push(@product,$RuleHash{$number}{"P_ID$p"});
		    $RuleHash{$number}{"P_Coeff$p"}=(split(/ /,$word))[2];
		    $p++;
		}elsif($word=~/Effector/){
		    
		    ($RuleHash{$number}{"E_path$e"},$RuleHash{$number}{"E_ID$e"})=split(/:/,(split(/ /,$word))[1]);
		    $RuleHash{$number}{"E_Coeff$e"}=(split(/ /,$word))[2];
		    $e++;
		}elsif($word=~/Catalyst/){
		    ($RuleHash{$number}{C_path},$RuleHash{$number}{C_ID})=split(/:/,(split(//,$word))[1]);
		}else{
		    $RuleHash{$number}{Arg_tag}{(split(/ /,$word))[0]}=(split(/ /,$word))[1];
		}
	    }
	    $Interaction{$number}{substrate} = \@substrate;
	    $Interaction{$number}{product} = \@product;
	    $Interaction{$number}{enzyme} = $RuleHash{$number}{Enzyme};
	    $number++;
	}
	if($contents[0] eq 'Include'){
	    $RuleHash{$number}{Type}=shift(@contents);
	    $RuleHash{$number}{Class}=shift(@contents);
	}
    }
    
    foreach my $key (keys(%sum)){
	if($sum{$key} > $limit){
	    print "DELETED   $sum{$key}   $key\n";
	}
    }
    
    open (OUTFILE,">$outfile");
    for(my $num=0; $num<$number-1; $num++){
	for(my $pro = 0; $pro <= $#{$Interaction{$num}{product}}; $pro++){
	    my $product = ${$Interaction{$num}{product}}[$pro];
	if( $sum{$product} < $limit){
 	    for(my $others=0; $others<$number-1; $others++){
 	        if($num != $others){
 		    for(my $sub=0; $sub <= $#{$Interaction{$others}{substrate}}; $sub++){
 		        my $substrate = ${$Interaction{$others}{substrate}}[$sub];
		    if($sum{$substrate}<$limit){
			if($product eq $substrate){
			    print OUTFILE "$Interaction{$num}{enzyme}  $Interaction{$others}{enzyme}\n";
 		        }
 		    }
		}
	    }
	}
    }
}
}
close OUTFILE;
if($output eq "show"){
    system "java -jar /usr/local/bin/biolayout.jar $outfile";
}
}
 
 
sub substance_layout{
    &opt_default(output=>"show",filename=>"substance_layout.txt", limit=>30);
    my @args = opt_get(@_);
    my $filename = shift @args;
    my $output = opt_val("output");
    my $outfile = opt_val("filename");
    my $limit = opt_val("limit");
    my @contents;
    my %RuleHash;
    my $word;
    my $number=1;
    my $s=1;
    my $p=1;
    my $e=1;
    my %Interaction;
    my %sum;
    open(FILE, $filename)|| die("ERROR: file does not exist\n");
    &msg_error("open data file $filename\n");
    while(<FILE>){
	my @substrate=();
	my @product=();
	my @enzyme=();
	tr/\n//d;
	@contents=split /\t/;
	if($contents[0] eq 'REACTOR'){
	    $s=$p=$e=1;
     	$RuleHash{$number}{Type}=shift(@contents);
	    $RuleHash{$number}{Class}=shift(@contents);
	    
	    ($RuleHash{$number}{Paeth},$RuleHash{$number}{ID})=split(/:/,shift(@contents));
	    $RuleHash{$number}{Name}=shift(@contents);
	    $RuleHash{$number}{Enzyme}=(split(/ /,$RuleHash{$number}{Name}))[2];
	    foreach $word (@contents){
 	    if($word=~/Substrate/){
		
		($RuleHash{$number}{"S_path$s"},$RuleHash{$number}{"S_ID$s"})=split(/:/,(split(/ /,$word))[1]);
 	        $sum{$RuleHash{$number}{"S_ID$s"}}++;
 	        push(@substrate,$RuleHash{$number}{"S_ID$s"});
 	        $RuleHash{$number}{"S_Coeff$s"}=(split(/ /,$word))[2];
 	        $s++;
 	    }elsif($word=~/Product/){
		
		($RuleHash{$number}{"P_path$p"},$RuleHash{$number}{"P_ID$p"})=split(/:/,(split(/ /,$word))[1]);
 	        $sum{$RuleHash{$number}{"P_ID$p"}}++;
 	        push(@product,$RuleHash{$number}{"P_ID$p"});
 	        $RuleHash{$number}{"P_Coeff$p"}=(split(/ /,$word))[2];
 	        $p++;
 	    }elsif($word=~/Effector/){
		
		($RuleHash{$number}{"E_path$e"},$RuleHash{$number}{"E_ID$e"})=split(/:/,(split(/ /,$word))[1]);
		$RuleHash{$number}{"E_Coeff$e"}=(split(/ /,$word))[2];
 $e++;
 	    }elsif($word=~/Catalyst/){
		
		($RuleHash{$number}{C_path},$RuleHash{$number}{C_ID})=split(/:/,(split(/ /,$word))[1]);
 	    }else{
 	        $RuleHash{$number}{Arg_tag}{(split(/ /,$word))[0]}=(split(/ /,$word))[1];
 	    }
	}
	    $Interaction{$number}{substrate} = \@substrate;
	    $Interaction{$number}{product} = \@product;
	    $Interaction{$number}{enzyme} = $RuleHash{$number}{Enzyme};
	    $number++;
	}
	if($contents[0] eq 'Include'){
	    $RuleHash{$number}{Type}=shift(@contents);
	    $RuleHash{$number}{Class}=shift(@contents);
	}
     }
    
    foreach my $key (keys(%sum)){
	if($sum{$key} > $limit){
	    print "DELETED   $sum{$key}   $key\n";
	}
    }
 
    open (OUTFILE,">$outfile");
    for(my $num=0; $num<$number-1; $num++){
	for(my $sub=0; $sub<=$#{$Interaction{$num}{substrate}}; $sub++){
	    my $substrate = ${$Interaction{$num}{substrate}}[$sub];
             if($sum{$substrate}<$limit){
		 for(my $pro=0; $pro<=$#{$Interaction{$num}{product}}; $pro++){
		     my $product = ${$Interaction{$num}{product}}[$pro];
		 if($sum{$product}<$limit){
		     print OUTFILE "$substrate   $product\n";
		 }
	     }
    }
  }
 }
 close OUTFILE;
if($output eq "show"){
    system "java -jar /usr/local/bin/biolayout.jar $outfile";
}
}


sub DESTROY {
    my $self = shift;
}

1;
__END__
# Below is the stub of documentation for your module. You better edit it!

=head1 NAME

G::Ecell::BioLayout - Perl extension for blah blah blah

=head1 SYNOPSIS

  use G::Ecell::BioLayout;
  blah blah blah

=head1 DESCRIPTION

Stub documentation for G::Ecell::BioLayout was created by h2xs. It looks like the
author of the extension was negligent enough to leave the stub
unedited.

Blah blah blah.

=head1 AUTHOR

Seira Nakamura, seira@g-language.org

=head1 SEE ALSO

perl(1).

=cut
