#:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
# This file is part of G-language Genome Analysis Environment package
#
#     Copyright (C) 2001-2008 Keio University
#:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
# 
#   $Id: Inspire.pm,v 1.2 2002/05/27 03:32:43 gaou Exp $
#
# G-language GAE is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2 of the License, or (at your option) any later version.
# 
# G-language GAE is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
# See the GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public
# License along with G-language GAE -- see the file COPYING.
# If not, write to the Free Software Foundation, Inc.,
# 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
# 
#END_HEADER
#
# written by Kazuharu Arakawa <gaou@sfc.keio.ac.jp> at
# G-language Project, Institute for Advanced Biosciences, Keio University.
#

package G::Inspire;

use strict;
use base qw(Exporter);
use autouse 'Cwd'=>qw(getcwd);
use SelfLoader;

use G::Messenger;

our @EXPORT = qw(
		 SetScript
		 OnSave
		 OnExecute
		 OnGenerate
		 );



#::::::::::::::::::::::::::::::
#          Variables
#::::::::::::::::::::::::::::::

my %data;
my $hsGCF;

$data{"script"} = 'default.gcf';

__DATA__

#::::::::::::::::::::::::::::::
#           Methods
#::::::::::::::::::::::::::::::



sub SetScript {
    my $script = shift;

    $data{'script'} = $script;

    unless(lstat $data{'script'}){
	G::Messenger::msg_error("Error: No such GCF script - " , $data{'script'}, "\n");
	return;
    }

    open(FILE,$data{'script'});
    while(<FILE>){
    	$data{'engine'} = $1 if(/>Engine:\s(.+)/);
    	$data{'configure'} = $1 if(/>Configure:\s(.+)/);
    }
    close(FILE);

    my $tmp = $data{'engine'};
    my $evalstr = 'G::System::' . $tmp . '::' . $tmp;
    $evalstr .= "\_parser";

    {
	no strict 'refs';
	$hsGCF = &{$evalstr}($script);
        G::Messenger::msg_error("Engines set from GCF.\n");
    }

    return $hsGCF;
}


sub OnSave {
  my $script = shift;
  $hsGCF = shift;
  my $out = '';

  {
	no strict 'refs';
        $out = &{"G::System::" . $data{'engine'} . '::' . $data{'engine'} . 
		'_scripter'}($hsGCF);
  }

  open(OUT, '>' . $script) || G::Messenger::msg_error("Cannot open the file to save.\n");
  print OUT $out;
  close(OUT);

  &G::Messenger::msg_error("Saved GCF.\n");
}



sub OnExecute {
  my $msg = '';

  G::Messenger::msg_error("Start Analysis:\n");

  {
	no strict 'refs';
        $msg = &{"G::System::" . $data{'engine'} . '::' 
		     . $data{'engine'} . '_engine'}($data{'script'}, -src=>"");
  }

  sleep(1);
  chdir('../') unless ($msg eq 'HOGE');

  G::Messenger::msg_error("Done.\n");
}


sub OnGenerate {
    my $str = shift;

    {
	no strict 'refs';
        &{"G::System::" . $data{'engine'} . '::' . $data{'engine'}
	  . '_engine'}($data{'script'}, -src=>"$str");
    }

    &G::Messenger::msg_error("Script generated.\n");
}


1;


