#:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
# This file is part of G-language Genome Analysis Environment package
#
#     Copyright (C) 2001-2008 Keio University
#:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
# 
#   $Id: Fasta.pm,v 1.1.1.1 2002/04/02 20:25:44 gaou Exp $
#
# G-language GAE is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2 of the License, or (at your option) any later version.
# 
# G-language GAE is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
# See the GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public
# License along with G-language GAE -- see the file COPYING.
# If not, write to the Free Software Foundation, Inc.,
# 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
# 
#END_HEADER
#

package G::Tools::Fasta;

use SubOpt;
use G::Messenger;

use strict;
use base qw(Exporter);
use SelfLoader;

our @EXPORT = qw(
		 _fasta
);

__DATA__

#::::::::::::::::::::::::::::::
#        Methods Start
#::::::::::::::::::::::::::::::


sub _fasta{  
    &opt_default(qr=>'off',input=>"file");
    my @param;
    my @tmp;
    foreach(@_){
        if($_ eq '-a' || $_ eq '-A' || $_ eq '-B' || $_ eq '-f' || $_ eq '-g' ||
           $_ eq '-h' || $_ eq '-H' || $_ eq '-i' || $_ eq '-L' || $_ eq '-n' || 
           $_ eq '-o' || $_ eq '-p' || $_ eq '-Q' || $_ eq '-q' || $_ eq '-r' ||
           $_ eq '-S' || $_ eq '-1' || $_ eq '-3' ){
	    push(@param,$_);
        }
        else{
            push(@tmp,$_);
        }
    }
    @_=@tmp;
    my @args=opt_get(@_);

    my $qr=&opt_val("qr");
    my $input=&opt_val("input");
    my $data;
    my $file;
    my $seq;
    my %opt;
    my $param;
    my $num;

    $data=shift @args;
    if($input eq 'seq'){
	$seq=shift @args;
	opendir(DIR,'/tmp');
	@tmp=readdir(DIR);
	$num=$#tmp+1+time;
	@tmp=keys(%$seq);
	open(FILE,'>/tmp/fasta_'.$num.'.seq');
	print FILE ">$tmp[0]\n";
	print FILE $$seq{"$tmp[0]"},"\n";
	close(FILE);
	$file='/tmp/fasta_'.$num.'.seq'; 
    }
    else{
	$file=shift @args;
    }

    $opt{E}=&opt_val("E");
    $opt{O}=&opt_val("O");
    $opt{b}=&opt_val("b");
    $opt{c}=&opt_val("c");
    $opt{d}=&opt_val("d");
    $opt{F}=&opt_val("F");
    $opt{j}=&opt_val("j");
    $opt{l}=&opt_val("l");
    $opt{M}=&opt_val("M");
    $opt{m}=&opt_val("m");
    $opt{R}=&opt_val("R");
    $opt{s}=&opt_val("s");
    $opt{w}=&opt_val("w");
    $opt{x}=&opt_val("x");
    $opt{X}=&opt_val("X");
    $opt{y}=&opt_val("y");
    $opt{z}=&opt_val("z");

    foreach(sort keys(%opt)){
	next if($opt{$_} eq '');
	push(@param,'-'.$_);
	push(@param,$opt{$_});
    }
    $param=join(' ',@param);

    system('fasta33',"$data","$file",@param) if($qr eq "off");
    system('qr',"fasta33 $data $file $param") if($qr eq "on");

    unlink('/tmp/fasta_'.$num.'.seq') if($input eq 'seq' && $qr ne 'on');

    return "$data $file $param";
}


1;
