#:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
# This file is part of G-language Genome Analysis Environment package
#
#     Copyright (C) 2001-2008 Keio University
#:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
# 
#   $Id: GenBankI.pm,v 1.1 2002/07/30 17:44:27 gaou Exp $
#
# G-language GAE is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2 of the License, or (at your option) any later version.
# 
# G-language GAE is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
# See the GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public
# License along with G-language GAE -- see the file COPYING.
# If not, write to the Free Software Foundation, Inc.,
# 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
# 
#END_HEADER
#
# written by Kazuharu Arakawa <gaou@sfc.keio.ac.jp> at
# G-language Project, Institute for Advanced Biosciences, Keio University.
#

package G::IO::FastaI;

use strict;
use warnings;
use base qw(G::IO::Handler G::IO::GenBankO);

use Carp;
use G::Messenger;

#::::::::::::::::::::::::::::::
#     Let the code begin...
#::::::::::::::::::::::::::::::
my $infile = '';
my $prev = '';

sub new{
    my $pkg = shift;
    my $this = {};

    bless $this;

    return $this;
}

sub filepath {
    return $infile;
}

sub open_gb {
    my $this = shift;
    my $filename = shift;
    $prev = '';
    $infile = $filename;
    
    open(FASTAFILE, $filename) or croak("Error at G::IO::FastaI: $!\n");

    return *FASTAFILE;
}

sub close_gb {
    close(FASTAFILE);
}

sub read_header {}
sub read_features {}
sub goto_origin {}

sub next_locus{
    my $this = shift;
    my $msg = shift;
    undef %$this;
    $this->read_locus();
    $this->getnucs();

    if (defined($this->{SEQ})){
	$this->seq_info() unless($msg);
	return 1;
    }else{
	return 0;
    }
}

sub read_locus{
    my $this = shift;

    if($prev =~ /^>(.*)$/){
	$this->{LOCUS}->{id} = $1;
	return;
    }

    while(<FASTAFILE>){
	chomp;
	if (/^>(.*)$/){
	    $this->{LOCUS}->{id} = $1;
	    last;
	}
    }
}
	
sub getnucs {
    my $this = shift;

    while(<FASTAFILE>){
	$prev = $_;
	last if (/^\s*\n$/ || /^>/);
	s/[^A-Za-z]//g;
	$this->{SEQ} .= lc($_);
    }
}

1;
