#:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
# This file is part of G-language Genome Analysis Environment package
#
#     Copyright (C) 2001-2009 Keio University
#:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
# 
#   $Id: HMMER.pm,v 1.1.1.1 2002/04/02 20:25:45 gaou Exp $
#
# G-language GAE is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2 of the License, or (at your option) any later version.
# 
# G-language GAE is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
# See the GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public
# License along with G-language GAE -- see the file COPYING.
# If not, write to the Free Software Foundation, Inc.,
# 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
# 
#END_HEADER
#

package G::Tools::HMMER;

use SubOpt;
use G::Messenger;

use strict;
use base qw(Exporter);
use SelfLoader;

our @EXPORT = qw(
		 _hmmpfam
);


__DATA__

#::::::::::::::::::::::::::::::
#        Methods Start
#::::::::::::::::::::::::::::::


sub _hmmpfam{  
    &opt_default(qr=>'off',input=>"file",filename=>"hmmpfam.hmm",output=>"f");
    my @param;
    my @tmp;
    foreach(@_){
	if($_ eq '-n' || $_ eq '--forward' || $_ eq '--null2' || $_ eq '--pvm' ||$_ eq '--xnu'){
	    push(@param,$_);
	}
	else{
	    push(@tmp,$_);
	}
    }
    @_=@tmp;
    my @args=opt_get(@_);

    my $qr=&opt_val("qr");
    my $input=&opt_val("input");
    my $output=&opt_val("output");
    my $data=shift @args;
    my $file;
    my $filename;
    my $seq;
    my $param;
    my %opt;
    my $num;

    if($input eq "seq"){
	$seq=shift @args;
	opendir(DIR,'/tmp');
	@tmp=readdir(DIR);
	$num=$#tmp+1+time;
	@tmp=keys(%$seq);
	open(FILE,'>/tmp/hmmpfam_'.$num.'.seq');
	print FILE ">$tmp[0]\n";
	print FILE $$seq{$tmp[0]},"\n";
	close(FILE);
	$file='/tmp/hmmpfam_'.$num.'.seq'; 
	$filename=&opt_val("filename");
    }
    else{
	$file=shift @args;
	$filename=$file.'.hmm';
    }

    $opt{A}=&opt_val("A");
    $opt{E}=&opt_val("E");
    $opt{T}=&opt_val("T");
    $opt{Z}=&opt_val("Z");
    $opt{-cpu}=&opt_val('-cpu');
    $opt{-domE}=&opt_val('-domE');
    $opt{-domT}=&opt_val('-domT');

    foreach(sort keys(%opt)){
	next if($opt{$_} eq '');
	push(@param,'-'.$_);
	push(@param,$opt{$_});
    }
    $param=join(" ",@param);
    
    if($qr eq "on"){
	system('qr',"hmmpfam $param $data $file") if($output eq "stdout");
	system('qr',"hmmpfam $param $data $file > $filename") if($output ne "stdout");
    }
    else{
	system("hmmpfam $param $data $file") if($output eq "stdout");
	system("hmmpfam $param $data $file > $filename") if($output ne "stdout");
    }

    unlink('/tmp/hmmpfam_'.$num.'.seq') if($input eq "seq" && $qr ne 'on');

    return "$param $data $file";
}

1;
