#:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
# This file is part of G-language Genome Analysis Environment package
#
#     Copyright (C) 2001-2009 Keio University
#:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
# 
#   $Id: Repeat.pm,v 1.1.1.1 2002/04/02 20:25:45 gaou Exp $
#
# G-language GAE is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2 of the License, or (at your option) any later version.
# 
# G-language GAE is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
# See the GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public
# License along with G-language GAE -- see the file COPYING.
# If not, write to the Free Software Foundation, Inc.,
# 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
# 
#END_HEADER
#

package G::Tools::Repeat;

use SubOpt;
use G::Messenger;

use strict;
use base qw(Exporter);
use SelfLoader;

our @EXPORT = qw(
		 _repeatmasker
		 _trf
);


__DATA__

#::::::::::::::::::::::::::::::
#        Methods Start
#::::::::::::::::::::::::::::::

sub _repeatmasker{  
    &opt_default(input=>"file",qr=>"off");
    my @param;
    my @tmp;
    foreach(@_){
	if($_ eq '-nolow' || $_ eq '-l' || $_ eq '-int' || $_ eq '-norna' ||
           $_ eq '-alu' || $_ eq '-m' || $_ eq '-rod' || $_ eq '-mam' ||
           $_ eq '-cow' || $_ eq '-ar' || $_ eq '-dr' || $_ eq '-el' ||
	   $_ eq '-is_only' || $_ eq '-is_clip' || $_ eq '-no_is' ||
	   $_ eq '-rodspec' || $_ eq '-primspec' || $_ eq '-w' || $_ eq '-s'||
	   $_ eq '-q' || $_ eq '-qq' || $_ eq '-gccalc' || $_ eq '-nocut' ||
	   $_ eq '-noisy' || $_ eq '-a' || $_ eq '-cut' || $_ eq '-small' ||
	   $_ eq '-xsmall' || $_ eq '-x' || $_ eq '-poly' || $_ eq '-ace' ||
	   $_ eq '-gff' || $_ eq '-u' || $_ eq '-xm' || $_ eq '-fixed' ||
	   $_ eq '-no_id' || $_ eq '-e'){
	    push(@param,$_);
	}
	else{
	    push(@tmp,$_);
	}
    }
    @_=@tmp;
    my @args=opt_get(@_);

    my $input=&opt_val("input");
    my $qr=&opt_val("qr");
    my $file;
    my $seq;
    my $param;
    my %opt;
    my $num;

    if($input eq "seq"){
	$seq=shift @args;
	opendir(DIR,'/tmp');
	@tmp=readdir(DIR);
	$num=$#tmp+1+time;
	@tmp=keys(%$seq);
	open(FILE,'>/tmp/repeatmasker_'.$num.'.seq');
	print FILE ">$tmp[0]\n";
	print FILE $$seq{$tmp[0]},"\n";
	close(FILE);
	$file='/tmp/repeatmasker_'.$num.'.seq'; 
	&opt_default(dir=>'.');
    }
    else{
	$file=shift @args;
    }

    $opt{div}=&opt_val("div");
    $opt{lib}=&opt_val("lib");
    $opt{cutoff}=&opt_val("cutoff");
    $opt{pa}=&opt_val("pa");
    $opt{gc}=&opt_val('gc');
    $opt{frag}=&opt_val('frag');
    $opt{dir}=&opt_val('dir');

    foreach(sort keys(%opt)){
	next if($opt{$_} eq '');
	push(@param,'-'.$_);
	push(@param,$opt{$_});
    }
    $param=join(" ",@param);
    
    system("RepeatMasker $param $file") if($qr ne 'on');
    system('qr',"RepeatMasker $param $file") if($qr eq 'on');

    unlink('/tmp/repeatmasker_'.$num.'.seq') if($input eq "seq" && $qr ne 'on');

    return "$param $file";
}


sub _trf{  
    &opt_default(qr=>'off',input=>"file",Match=>"2",Mismatch=>"7",Delta=>"7",PM=>"80",PI=>"10",Minscore=>"50",MaxPeriod=>"500");
    my @param;
    my @tmp;
    foreach(@_){
        if($_ eq '-m' || $_ eq '-f' || $_ eq '-d'){
            push(@param,$_);
        }
        else{
            push(@tmp,$_);
        }
    }
    @_=@tmp;
    my @args=opt_get(@_);

    my $qr=&opt_val("qr");
    my $input=&opt_val("input");
    my $filename=&opt_val("filename");
    my $file;
    my $seq;
    my $param;
    my %opt;
    my $num;

    if($input eq "seq"){
        $seq=shift @args;
	if($filename eq ''){
	    opendir(DIR,'/tmp');
	    @tmp=readdir(DIR);
	    $num=$#tmp+1+time;
	    $filename='/tmp/trf_'.$num.'.seq';
	}
        @tmp=keys(%$seq);
        open(FILE,'>'."$filename");
        print FILE ">$tmp[0]\n";
        print FILE $$seq{$tmp[0]},"\n";
        close(FILE);
        $file=$filename; 
    }
    else{
        $file=shift @args;
    }

    @param=(&opt_val("Match"),&opt_val("Mismatch"),&opt_val("Delta"),&opt_val("PM"),&opt_val("PI"),&opt_val("Minscore"),&opt_val("MaxPeriod"),@param);
    foreach(sort keys(%opt)){
        next if($opt{$_} eq '');
        push(@param,'-'.$_);
        push(@param,$opt{$_});
    }
    $param=join(" ",@param);
    
    system("trf $file $param") if($qr ne 'on');
    system('qr',"trf $file $param") if($qr eq 'on');

    unlink("$filename") if($input eq "seq" && $qr ne 'on');

    return "$file $param";
}

1;
