#:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
# This file is part of G-language Genome Analysis Environment package
#
#     Copyright (C) 2001-2010 Keio University
#:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
# 
#   $Id: GenBankI.pm,v 1.1 2002/07/30 17:44:27 gaou Exp $
#
# G-language GAE is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2 of the License, or (at your option) any later version.
# 
# G-language GAE is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
# See the GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public
# License along with G-language GAE -- see the file COPYING.
# If not, write to the Free Software Foundation, Inc.,
# 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
# 
#END_HEADER
#
# written by Kazuharu Arakawa <gaou@sfc.keio.ac.jp> at
# G-language Project, Institute for Advanced Biosciences, Keio University.
#

package G::IO::FastQI;

use strict;
use warnings;
use base qw(G::IO::Handler G::IO::GenBankO);

use Carp;
use IO::File;
use IO::Zlib;
use G::Messenger;

#::::::::::::::::::::::::::::::
#     Let the code begin...
#::::::::::::::::::::::::::::::

my %FH;

sub new{
    my $pkg = shift;
    my $this = {};

    bless $this;

    return $this;
}

sub DESTROY {
    return unless($FH{$_[0]->{INSTANCE}});
    close ($FH{$_[0]->{INSTANCE}});
    delete($FH{$_[0]->{INSTANCE}});
}

sub open_gb {
    my $this = shift;
    my $filename = shift;
    $this->{PREVLINE} = '';
    $this->{FILENAME} = $filename;
    $this->{INSTANCE} = $filename . '-' . time() . '-' . rand();

    if($filename =~ /\.gz$/){
        $FH{$this->{INSTANCE}} = new IO::Zlib;
	$FH{$this->{INSTANCE}}->open($filename, 'rb') or croak("Error at G::IO::FastQI: $!\n");;
    }else{
        $FH{$this->{INSTANCE}} = new IO::File;
        open($FH{$this->{INSTANCE}}, $filename)or croak("Error at G::IO::FastQI: $!\n");
    }

    return $FH{$this->{INSTANCE}};
}

sub next_locus{
    my $this = shift;
    my $msg  = shift;
    my $file = $this->{FILENAME};
    my $prev = $this->{PREVLINE};
    my $inst = $this->{INSTANCE};

    undef %$this;

    $this->{FILENAME} = $file;
    $this->{PREVLINE} = $prev;
    $this->{INSTANCE} = $inst;

    $this->read_locus();
    $this->getnucs();

    if (defined($this->{SEQ})){
	$this->seq_info() unless($msg);
	return 1;
    }else{
	return 0;
    }
}

sub read_locus{
    my $this = shift;

    if($this->{PREVLINE} =~ /^\@(.*)$/){
	$this->{LOCUS}->{id} = $1;
	return;
    }

    my $fh = $FH{$this->{INSTANCE}};

    while(<$fh>){
	chomp;
	if (/^\@(.*)$/){
	    $this->{LOCUS}->{id} = $1;
	    last;
	}
    }
}
	
sub getnucs {
    my $this = shift;

    my $flag = 0;
    my $fh = $FH{$this->{INSTANCE}};

    while(<$fh>){
	$this->{PREVLINE} = $_;
	last if (/^\s*\n$/ || /^\@/);

	if($flag){
	    s/\s//g;
	    $this->{QUAL} .= $_;
	}else{
	    if(/^\+(.*)$/){
		die("Something is wrong in your FASTAQ file: $this->{LOCUS}->{id}, $1") if ($this->{LOCUS}->{id} ne $1);
		$flag = 1;
	    }else{
		s/[^A-Za-z]//g;
		$this->{SEQ} .= lc($_);
	    }
	}
    }
}

1;
