#:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
# This file is part of G-language Genome Analysis Environment package
#
#     Copyright (C) 2001-2016 Keio University
#:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
# 
#   $Id: G.pm,v 1.4 2002/07/30 17:40:56 gaou Exp $
#
# G-language GAE is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2 of the License, or (at your option) any later version.
# 
# G-language GAE is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
# See the GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public
# License along with G-language GAE -- see the file COPYING.
# If not, write to the Free Software Foundation, Inc.,
# 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
# 
#END_HEADER
#
# written by Atsuko Kishi <uran@g-language.org> at
# G-language Project, Institute for Advanced Biosciences, Keio University.
#

package G::DynamicLoader;

use strict;
use base qw(Exporter);
use File::Find;

#:::::::::::::::::::::::::::::::::
#       Perldoc
#:::::::::::::::::::::::::::::::::


=head1 NAME

    G::DynamicLoader - Dynamic Loading of Plug-in modules

=head1 DESCRIPTION

    This class is a part of G-language Genome Analysis Environment, 
    for internal functionality of dynamically loading plug-in modules.

    G-language System searches for plug-in modules located at 
    ~/Plug-in or $ENV{GLANG_PLUGIN} at compile time, and exports 
    all EXPORTed methods in any depths of folders within the plug-in 
    directory. Therefore, users can customize and override the
    installed G-language modules by placing the custom module 
    in their plug-in folder with the same class name and method name.

=cut


#:::::::::::::::::::::::::::::::::
#       Let the code begin...
#:::::::::::::::::::::::::::::::::

our @EXPORT;

BEGIN{

    my $path = $ENV{HOME} . '/Plug-in';
    if($ENV{GLANG_PLUGIN}){
	$path = $ENV{GLANG_PLUGIN};
	substr($path, -1, 1) = '' if(substr($path, -1, 1) eq '/');
    }
    unshift(@INC, $path);

    no strict 'refs';
    
    my $sub = sub {
	my $dir = $File::Find::name;
	my $dirpath = $dir;
	
	if(-d $dir){
	    $dir =~ s/^$path$/\.\//g;
	    $dir =~ s/^$path\//\.\//g;
	    
	    my $file;
	    opendir(DIR, $dirpath) || die "can't opendir $dir: $!"; 
	    
	    $dir =~ s/^\.\//\.::/g;
	    $dir.="::" unless($dir=~/::$/);
	    $dir =~ s/\//::/g;	
	    $dir =~ s/^\.:://g;	
	    
	    while(defined($file=readdir(DIR))){
		if($file=~/(.+)\.pm$/){
		    next if ($file =~ /^\.\#/);
		    my $dirname = $dir . $1;

		    eval "use $dirname";
		    warn "$@" if ($@);
		    
		    push(@EXPORT, @{$dirname . '::' . 'EXPORT'});	   
		}
	    }
	    closedir(DIR);
	}
    };
    
    find($sub, $path) if (-e $path);
}

1;











