#:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
# This file is part of G-language Genome Analysis Environment package
#
#     Copyright (C) 2001-2016 Keio University
#:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
# 
# G-language GAE is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2 of the License, or (at your option) any later version.
# 
# G-language GAE is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
# See the GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public
# License along with G-language GAE -- see the file COPYING.
# If not, write to the Free Software Foundation, Inc.,
# 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
# 
#END_HEADER
#
# written by Kazuharu Arakawa <gaou@sfc.keio.ac.jp> at
# G-language Project, Institute for Advanced Biosciences, Keio University.
#

package Rcmd::Handler;

use strict;
use autouse 'Carp'=>qw(croak carp);

use SubOpt;
use G::Messenger;
use Scalar::Util qw/looks_like_number/;

use base 'Exporter';
our @EXPORT= qw/_is_nominal _installed_R_packages/;


#:::::::::::::::::::::::::::::::::
#       Perldoc
#:::::::::::::::::::::::::::::::::


=head1 NAME

  Rcmd::Handler - Internal class with miscellaneous interfaces to R language.

=head1 DESCRIPTION

 Intended for internal use only. Super class for the core. Provides 
 the native methods.

=head1 AUTHOR

Kazuharu Arakawa, gaou@sfc.keio.ac.jp

=cut



sub _is_nominal {
    return -1 unless $_[0];
    return -1 unless ref $_[0] eq 'ARRAY';

    my @array= @{+shift};
    return -1 unless $array[0];

    # array is continuous scale (0) or nominal scale (1)
    my $is_nominal= 0;
    for (0 .. ($#array > 9 ? 9 : $#array)) {
        my $item= $array[$_];
        next unless $item;

        if (looks_like_number( $item ) ){ # $item is number
            next;
        } else { # $item is not number
            $is_nominal = 1; # nominal scale
            last;
        }
    }

    return $is_nominal;
}

sub _installed_R_packages {
    my $R_OUTPUT;

    # trap STDERR output from R
    open TMPOUT, '>&', STDERR; close STDERR; open STDERR, '>', \$R_OUTPUT;

    # call 'library()' method
    my $rcmd= Rcmd->new(); $rcmd->exec('library()');

    # re-open STDERR
    close STDERR; open STDERR, '>&TMPOUT'; close TMPOUT;

    my @pkg_list;
    for my $line (split /\n/, $R_OUTPUT) {
	my ($pkg)= split /\s+/, $line;
	push @pkg_list, $pkg if $pkg;
    }

    return @pkg_list;
}

1;
