(require 'GPSGraphNode "GPSGraphNode.lisp")

(defun GPS (state goals &optional (*ops* *ops*))

  (let ((gps-node (make-instance 'GPSGraphNode 'initGoal goals)))

    (setState gps-node state)
    (setGhat gps-node 0)
    (setFhat gps-node (hhat gps-node))

    (let ((gps-graph (make-instance 'GraphSearchA)))
      (setOpen gps-graph (list gps-node))

;      (let ((solutions
;	     (graph-search gps-graph 1)))
;	(dolist (node solutions)
;	  (reportSolution node) ))

      (let ((solutions
	     (graph-search gps-graph 1)))
	(dolist (node solutions)
	  (let ((parents nil))
	    (do ((parent (getParent node) (getParent parent)))
		((null parent) parents)
	      (if (null (remove-if #'atom (getState parent))) nil
		  (setq parents
			(cons (remove-if #'atom (getState parent)) parents) )))
	    (print (list parents 'parents)) )
	  (print (list (remove-if #'atom (getState node)) 'solution)) ))

      ))

  )
