(require "auxfns" "auxfns.lisp")
;(require 'GraphNode "GraphNode.lisp")
(require 'GraphSearch "GraphSearchA.lisp")
(defun requires (&optional args) (require args))
;(require "gps1" "gps1.lisp")
(require "gps" "gps.lisp")

(defclass GPSGraphNode (GraphNode)
  ((goal
    :allocation :class
    :initarg initGoal
    :reader getGoal ))
  )

(defmethod goal-p ((thisNode GraphNode))
  (let ((state (getState thisNode))
	(goals (getGoal thisNode)))
    (every #'(lambda (goal) (member-equal goal state)) goals) ))

(defmethod hhat ((thisNode GraphNode))
  (let ((state (getState thisNode))
	(goals (getGoal thisNode)))
    (count-if #'(lambda (goal) (not (member-equal goal state))) goals) ))

(defmethod betterNode-p ((thisNode GraphNode) (anotherNode GraphNode))
  (let* ((state (getState thisNode))
	 (anotherState (getState anotherNode))
	 (goals (getGoal thisNode))
	 (thisDiff
	  (count-if #'(lambda (goal) (not (member-equal goal state))) goals) )
	 (anotherDiff
	  (count-if
	   #'(lambda (goal) (not (member-equal goal anotherState))) goals )))
    (labels ((alreadyOnParents (states node accumulator)
	       (let ((parentStates (getState node)))
		 (if (onParent-p states parentStates)
		     (let ((parent (getParent node)))
		       (if (null parent) (+ accumulator 1)
			   (alreadyOnParents states parent
					     (+ accumulator 1) )))
		     (let ((parent (getParent node)))
		       (if (null parent) accumulator
			   (alreadyOnParents states parent accumulator) )))))
	     (onParent-p (states parentStates)
	       (if (null parentStates) t
		   (if (not (member-equal (first parentStates) states)) nil
		       (onParent-p states (rest ParentStates)) ))))
      (let ((thisOnCount (alreadyOnParents state (getParent thisNode) 0))
	    (anotherOnCount
	     (alreadyOnParents anotherState (getParent anotherNode) 0) ))
	(<= (+ thisDiff thisOnCount) (+ anotherDiff anotherOnCount)) ))))

(defmethod onGraph-p ((thisNode GraphNode) (nodelist list))
  (let ((state (getState thisNode)))
    (dolist (check nodelist)
      (labels ((loop (states)
		 (if (null states) t
		     (if (not (member-equal (first states) (getState check)))
			 nil
			 (loop (rest states)) ))))
	(loop state) ))))

(defmethod =State ((thisNode GraphNode) (anotherNode GraphNode))
  (let ((state (getState thisNode))
	(anotherState (getState anotherNode)))
    (labels ((loop (states)
	       (if (null states) t
		   (if (not (member-equal (first states) anotherState)) nil
		       (loop (rest states)) ))))
      (loop state) )))

;(debug ':gps)
(setf *dbg-ids* (union '(:gps) *dbg-ids*))

(defmethod graphExpand ((thisNode GraphNode))
  (dbg-indent :gps 0 "graphExpand state: ~a" (getState thisNode))
  (dbg-indent :gps 0 "graphExpand goal: ~a" (getGoal thisNode))
  (let ((nodes nil)
	(state (getState thisNode))
	(goal (first (getGoal thisNode))))
    (labels ((appropriate-p (states conds)
	       (if (null conds) t
		   (if (member-equal (first conds) states)
		       (appropriate-p states (rest conds)) nil )))
	     (effective-p (states adds)
	       (if (null adds) nil
		   (if (not (member-equal (first adds) states)) t
		       (effective-p states (rest adds)) )))
	     (loop (ops accumulator)
	       (if (null ops) accumulator
		   (if (and (appropriate-p state (op-preconds (first ops)))
			    (effective-p state (op-add-list (first ops))))
		       (loop (rest ops)
			     (append accumulator (list (first ops))) )
		       (loop (rest ops) accumulator) ))))
      (dbg-indent :gps 0 "*ops*: ~a" *ops*)
      (let ((achieved-ops (loop *ops* nil)))
	(dolist (achieved achieved-ops)
	  (dbg-indent :gps 0 "achieved: ~a" achieved)
	  (dbg-indent :gps 0 "state: ~a" state)
	  (let ((expanded
		 (makeSuccessor
		  thisNode (list (apply-op state goal achieved nil) 1) )))
	    (when expanded (setq nodes (append nodes (list expanded)))) )))
      (list nodes thisNode) )))

(defmethod reportSolution ((thisNode GPSGraphNode))
  (when (getParent thisNode) (reportSolution (getParent thisNode)))
  (print 
   (list (getState thisNode)
	 'hat (hhat thisNode) (getGhat thisNode) (getFhat thisNode) )))
