(require 'PtreeNode "PtreeNode.lisp")
(require 'PtreeGraphNode "PtreeGraphNode.lisp")

(defclass HanoiPtreeNode (PtreeNode)
  ((operators
    :allocation :class
    :initform
    (let ((operators
	   (list
	    (lambda (node)
	      (let* ((problem (getProblem node))
		     (last-pair (last (first problem)))
		     (front (remove (first last-pair) (first problem)))
		     (from (second problem))
		     (to (third problem))
		     (sub (first (remove from (remove to '(a b c)))))
		     (seq (fourth problem)) )
		(list (list front from sub (append seq (list 0)))
		      (list last-pair from to (append seq (list 1)))
		      (list front sub to (append seq (list 2))) ))))))
      operators )
    :reader getOperators ))
  )

(defmethod solved-p ((thisNode ProblemNode))
  (= (length (first (getProblem thisNode))) 1) )

(defmethod hhat ((thisNode ProblemNode))
  0 )

(defmethod problemCompare ((thisNode ProblemNode) (a-seq list) (b-seq list))
  (if (null b-seq) nil
    (if (< (first a-seq) (first b-seq)) t
      (if (> (first a-seq) (first b-seq)) nil
	(problemCompare thisNode (rest a-seq) (rest b-seq)) ))))

(defmethod printPnode ((thisNode ProblemNode))
  (list (if (getOr? thisNode) 'or 'and)
	(getProblem thisNode)
	(if (getSolved? thisNode) 'solved 'not-solved)
	(let ((compareFnc (lambda (a b)
			   (let* ((a-problem (getProblem a))
				  (b-problem (getProblem b))
				  (a-seq (if (null a-problem) nil
					   (fourth a-problem) ))
				  (b-seq (if (null b-problem) nil
					   (fourth b-problem) )) )
			     (problemCompare thisNode a-seq b-seq) ))))
	  (printSuccessors thisNode
			   (if (null (getSuccessors thisNode)) nil
			     (sort (getSuccessors thisNode) compareFnc) )))))

(defmethod printSuccessors ((thisNode ProblemNode) (successors list))
  (if (null successors) nil
    (cons (printPnode (first successors))
	  (printSuccessors thisNode (rest successors)) )))

(defmethod reportSolution ((thisNode PtreeNode))
  (print (printPnode thisNode)) )

(let ((hanoi-problem (make-instance 'HanoiPtreeNode)))
  (let ((successor (make-instance 'HanoiPtreeNode)))
    (setProblem successor '((1 2 3) a c (0)))
    ;(setProblem successor '((1 2 3 4 5 6) a c (0)))
    (setSolved? successor nil)
    (setSuccessors successor nil)
    (setSuccessors hanoi-problem (list successor))

    (let ((hanoi-node (make-instance 'PtreeGraphNode)))
      (setState hanoi-node hanoi-problem)
;;; ???
      (setGhat hanoi-node 0)
      (setFhat hanoi-node (hhat hanoi-problem))
;;; ???

      (let ((hanoi-graph (make-instance 'GraphSearchA)))
	(setOpen hanoi-graph (list hanoi-node))

	(let ((solutions (graph-search hanoi-graph 1)))
	  (dolist (node solutions) (reportSolution node)) )))))
;;; deBug
;(let ((solutions (graph-search hanoi-graph 1)))
;  (dolist (node solutions)
;    (let ((parents nil))
;      (do ((parent (getParent node) (getParent parent)))
;	  ((null parent) parents)
;	(setq parents (cons (printPnode (getState parent)) parents))
;	)
;      (print (list parents 'parents)) )
;    (print (list (printPnode (getState node)) 'solution)) ))
