;;;; -*- Mode: Lisp; Syntax: Common-Lisp -*-

;(require 'GraphSearch "GraphSearch.lisp")
(require 'GraphSearch "GraphSearchA.lisp")

(defclass BinaryTreeGraphNode (GraphNode)
  ((goal :allocation :class :initform 6 :reader getGoal))
  )

(defmethod goal-p ((thisNode BinaryTreeGraphNode))
  (equal (getState thisNode) (getGoal thisNode)) )

(defmethod hhat ((thisNode BinaryTreeGraphNode))
  (abs (- (getState thisNode) (getGoal thisNode))) )

(defmethod =State ((thisNode BinaryTreeGraphNode)
		   (anotherNode BinaryTreeGraphNode))
  (equal (getState thisNode) (getState anotherNode)) )

(defmethod operators ((thisNode BinaryTreeGraphNode))
  (let ((old (getState thisNode)))
    (list (list (+ old 1) 1) (list (+ old 2) 1)) ))

(setq binaryTree-node (make-instance 'BinaryTreeGraphNode))

(setState binaryTree-node 1)
(setGhat binaryTree-node 0)
(setFhat binaryTree-node (hhat binaryTree-node))

(setq binaryTree-graph (make-instance 'GraphSearchA))
(setOpen binaryTree-graph (list binaryTree-node))

(defmethod reportSolution ((thisNode BinaryTreeGraphNode))
  (when (getParent thisNode) (reportSolution (getParent thisNode)))
  (print 
   (list (getState thisNode)
	 'hat (hhat thisNode) (getGhat thisNode) (getFhat thisNode) )))

(let ((solutions (graph-search binaryTree-graph 1)))
  (dolist (node solutions) (reportSolution node)) )
