#include "StdAfx.h"
#include "CharCodeConvert.h"

#include <fstream>
#include <ostream>
#include <mbstring.h>
#include <string>



//  SJIS to JIS
std::string SJIStoJISc(unsigned char inLead, unsigned char inTrial)
{
	unsigned char offset = (inLead <=  0x9F) ? 0x70 : 0xB0;

	//inLead
	inLead = ((inLead - offset) << 1) - ((inTrial <  0x9F) ? 1 : 0);

	//inTrial
	//if (inTrial < 0x7F) offset = 0x1F; else if (inTrial < 0x9F) offset = 0x20; else offset = 0x7E;
	offset  = (inTrial < 0x7F) ? 0x1F : ( (inTrial < 0x9F) ? 0x20 : 0x7E );
	inTrial = inTrial - offset;

	//return
	const char retstr[] = { (char)inLead, (char)inTrial, '\0' };
	return std::string(retstr);
}


std::string SJIStoJISstr(const std::string& s)
{
	//prepare
	bool during_kanji = false;
	std::string ret   = "";
	char* sp          = (char *)(s.c_str());

	const char kanji_in[]  = { (char)0x1B, '$', 'B', '\0' };
	const char kanji_out[] = { (char)0x1B, '(', 'B', '\0' };

	//convert
	while (*sp != '\0')
	{
		if (_ismbblead(*sp))
		{
			//QoCg̑oCgł
			if (!during_kanji)
			{
				during_kanji = true;
				ret          = ret + kanji_in; //QoCgn
			}
			ret = ret + SJIStoJISc(*sp, *(sp+1));
			sp++;
		}
		else
		{
			//PoCg͂QoCg̑oCgł
			if (during_kanji)
			{
				during_kanji = false;
				ret = ret + kanji_out; //QoCgI
			}
			if (*sp != '\r' || *(sp+1) != '\n')
				ret = ret + *sp;
		}

		sp++;
	}

	//last
	if (during_kanji) ret = ret + kanji_out; //ŌAsciiɂ

	//return
	return ret;
}
