#include "StdAfx.h"
#include "KstDefaultFont.h"


namespace gk
{


bool KstDefaultFont::Initialize(void)
{
	return GetFont().CreateFontMapInternal();
}

bool KstDefaultFont::Initialize(const char* kst32b_filename)
{
	return GetFont().CreateFontMap(kst32b_filename);
}

void KstDefaultFont::ReleaseBuffer(void)
{
	GetFont().Clear();
}


bool KstDefaultFont::IsInitialized(void)
{
	return GetFont().HasBuffer();
}


KstFontMap& KstDefaultFont::GetFont(void)
{
	static KstFontMap DefaultFont;
	return DefaultFont;
}


}
