#include "StdAfx.h"
#include "KstFontMap.h"

#include <sstream>
#include <fstream>

#include "InternalFont.h"
#include "IOUtil.h"


namespace gk
{


void KstFontMap::Clear(void)
{
	m_FontMap.clear();
}

bool KstFontMap::HasBuffer(void) const
{
	return !m_FontMap.empty();
}


//! kst32b`̃tHgt@Ct@Cǂݍ
bool KstFontMap::CreateFontMap(const char* filename)
{
	Clear();

	std::ifstream ifs(filename);
	if( !ifs.is_open() )
		return false;

	return CreateFontMap( ifs );
}

//! kst32b`̃tHgt@CXg[ǂݍ
bool KstFontMap::CreateFontMap(std::istream& ist)
{
	Clear();

	while(!ist.eof())
	{
		std::string line_str;
		if( !IOUtil::ReadNextLine(ist, line_str) )
			continue;

		unsigned int char_code = -1;
		std::string stroke;
		if( !ReadSingleLine(line_str, char_code, stroke) )
		{
			Clear();
			return false;
		}

		m_FontMap[char_code] = stroke;
	}

	return true;
}

//! \[Xɖߍ񂾃tHg𗘗pă}bv𐶐
bool KstFontMap::CreateFontMapInternal(void)
{
	std::ostringstream os;
	InternalFont::GetBuffer(os);

	std::istringstream iss( os.str().c_str() );
	return CreateFontMap( iss );
}


bool KstFontMap::ReadSingleLine(const std::string& s_line, unsigned int& char_code, std::string& stroke) const
{
	try
	{
		std::istringstream iss(s_line);
		iss >> std::hex >> char_code >> stroke;
	}
	catch(...)
	{
		return false;
	}

	return true;
}


//! w肳ꂽR[hɑΉXg[N\XNvgԂ.
//! w肳ꂽR[hɕݒ肳ĂȂꍇnullԂ.
const std::string* KstFontMap::GetStrokeScript(int charCode) const
{
	std::map<int, std::string>::const_iterator found_str;
	found_str = m_FontMap.find(charCode);
	if( found_str == m_FontMap.end() )
		return NULL;

	return &found_str->second;
}


}
