#pragma once

#include "GLKST_API.h"

#include <map>
#include <string>

#include "KstPrimitives.h"
#include "KstString.h"


namespace gk
{


//! kst32b`̃tHgXg
class GLKST_API KstFontMap
{
public:
	void Clear(void);

	bool HasBuffer(void) const;

	bool CreateFontMap(const char* filename);
	bool CreateFontMap(std::istream& ist);

	bool CreateFontMapInternal(void);

	const std::string* GetStrokeScript(int charCode) const;

private:
	bool ReadSingleLine(const std::string& s_line, unsigned int& char_code, std::string& stroke) const;


private:
	std::map<int, std::string> m_FontMap;
};


}
