#pragma once

#include <utility>

#include "KstVec3.h"


namespace gk
{


//! 4s
/*
 
 CfbNX͐w̍sƈv
 [ (0,0) , (0,1) , (0,2) , (0,3) ]
 [ (1,0) , (1,1) , (1,2) , (1,3) ]
 [ (2,0) , (2,1) , (2,2) , (2,3) ]
 [ (3,0) , (3,1) , (3,2) , (3,3) ]

 ʂCfbNX
 [ 0  ,  1 ,  2 ,  3 ]
 [ 4  ,  5 ,  6 ,  7 ]
 [ 8  ,  9 , 10 , 11 ]
 [ 12 , 13 , 14 , 15 ]

 ς̌

 [ax] = [bx by bz bw] * [ m00 m01 m02 m03 ]
 [ay]                   [ m10 m11 m12 m13 ]
 [az]                   [ m20 m21 m22 m23 ]
 [aw]                   [ m30 m31 m32 m33 ]

 [ax] = [ m00 m01 m02 m03 ] * [bx]
 [ay]   [ m10 m11 m12 m13 ]   [by]
 [az]   [ m20 m21 m22 m23 ]   [bz]
 [aw]   [ m30 m31 m32 m33 ]   [bw]

 xNg̍sϊ̐
 v' = v * m;

*/
class Mat4
{
public:
	enum
	{
		WIDTH        =  4 , //!< s,̕
		NUM_ELEMENTS = 16 , //!< Svf
	};

public:
	float m00 , m01 , m02 , m03 ,
	      m10 , m11 , m12 , m13 ,
	      m20 , m21 , m22 , m23 ,
	      m30 , m31 , m32 , m33 ;

public:
	Mat4(void)
		: m00(0) , m01(0) , m02(0) , m03(0)
		, m10(0) , m11(0) , m12(0) , m13(0)
		, m20(0) , m21(0) , m22(0) , m23(0)
		, m30(0) , m31(0) , m32(0) , m33(0) 
	{}

	Mat4(const float* _v)
		: m00(_v[ 0]) , m01(_v[ 1]) , m02(_v[ 2]) , m03(_v[ 3])
		, m10(_v[ 4]) , m11(_v[ 5]) , m12(_v[ 6]) , m13(_v[ 7])
		, m20(_v[ 8]) , m21(_v[ 9]) , m22(_v[10]) , m23(_v[11])
		, m30(_v[12]) , m31(_v[13]) , m32(_v[14]) , m33(_v[15])
	{}

	Mat4(const Mat4& m)
		: m00(m.m00) , m01(m.m01) , m02(m.m02) , m03(m.m03)
		, m10(m.m10) , m11(m.m11) , m12(m.m12) , m13(m.m13)
		, m20(m.m20) , m21(m.m21) , m22(m.m22) , m23(m.m23)
		, m30(m.m30) , m31(m.m31) , m32(m.m32) , m33(m.m33)
	{}


	float*       ary(void)       { return &m00; }
	const float* ary(void) const { return &m00; }

	float&       operator[](size_t idx);
	const float& operator[](size_t idx) const;

	float&       operator()(size_t idx);
	const float& operator()(size_t idx) const;

	float&      at(size_t idx);
	const float& at(size_t idx) const;

	float&       operator()(size_t idx_row, size_t idx_col);
	const float& operator()(size_t idx_row, size_t idx_col) const;

	float&       at(size_t idx_row, size_t idx_col);
	const float& at(size_t idx_row, size_t idx_col) const;


	void set( const Mat4& m );
	void set( const float* _v );
	void set( float _v00 , float _v01 , float _v02 , float _v03 ,
	          float _v10 , float _v11 , float _v12 , float _v13 ,
	          float _v20 , float _v21 , float _v22 , float _v23 ,
	          float _v30 , float _v31 , float _v32 , float _v33 );

	Mat4& operator=( const Mat4& m );

	void get( Mat4& m ) const;
	void get( float* v ) const;

	//! SvfɓlZbg
	void fill( float _v );

	//! Pʍs
	void set_identity(void);
	//! s
	void set_zero(void);

	//! Pʍs񐶐
	static const Mat4& identity(void);
	//! s񐶐
	static const Mat4& zero(void);

	//! ]u
	void transpose(void);
	Mat4 get_transpose(void) const;

	//! ts
	void invert(void);
	Mat4 get_invert(void) const;


	//! sړs
	static Mat4 translate( const Vec3& v );
	static Mat4 translate( float x , float y , float z );
	void set_translate( const Vec3& v );
	void set_translate( float x , float y , float z );

	//! ]s
	static Mat4 rotate( const Vec3& axis , float angle );
	static Mat4 rotate_x( float angle );
	static Mat4 rotate_y( float angle );
	static Mat4 rotate_z( float angle );
	void set_rotate( const Vec3& axis , float angle );
	void set_rotate_x( float angle );
	void set_rotate_y( float angle );
	void set_rotate_z( float angle );

	//! XP[s
	static Mat4 scale( float scale_xyz );
	static Mat4 scale( const Vec3& scale_xyz );
	static Mat4 scale( float scale_x , float scale_y , float scale_z );
	void set_scale( float scale_xyz );
	void set_scale( const Vec3& scale_xyz );
	void set_scale( float scale_x , float scale_y , float scale_z );

	// w肵s()̗vf擾 [i,0][i,1][i,2][i,3]
	void set_row( size_t row_idx , float v0 , float v1 , float v2 , float v3 );
	void set_row( size_t row_idx , const Vec3& v );
	void get_row( size_t row_idx , float& v0 , float& v1 , float& v2 ) const;
	void get_row( size_t row_idx , float& v0 , float& v1 , float& v2 , float& v3 ) const;
	void get_row( size_t row_idx , Vec3& v ) const;

	// w肵(c)̗vf擾 [0,i][1,i][2,i][3,i]
	void set_col( size_t col_idx , float v0 , float v1 , float v2 , float v3 );
	void set_col( size_t col_idx , const Vec3& v );
	void get_col( size_t col_idx , float& v0 , float& v1 , float& v2 ) const;
	void get_col( size_t col_idx , float& v0 , float& v1 , float& v2 , float& v3 ) const;
	void get_col( size_t col_idx , Vec3& v ) const;


	//! w肵s, [JO[oւ̒ϊs
	// vec_global = vec_local * m
	void set_ortho_trans( const Vec3& ex , const Vec3& ey , const Vec3& ez );
	//! w肵s, O[o烍[Jւ̒ϊs
	// vec_local = vec_global * m
	void set_ortho_trans_rev( const Vec3& ex , const Vec3& ey , const Vec3& ez );

	bool operator==( const Mat4& m ) const;
	bool operator!=( const Mat4& m ) const;

	Mat4& operator+=( const Mat4& m );
	Mat4& operator-=( const Mat4& m );
	Mat4& operator*=( float val );
	Mat4& operator/=( float val );

	Mat4& operator*=( const Mat4& m );


	friend Mat4 operator+( const Mat4& m1 , const Mat4& m2 );
	friend Mat4 operator-( const Mat4& m1 , const Mat4& m2 );
	friend Mat4 operator*( const Mat4& m1 , const Mat4& m2 );

	friend Mat4 operator*( const Mat4& m1 , float val );
	friend Mat4 operator*( float val , const Mat4& m1 );

	friend Mat4 operator/( const Mat4& m1 , float val );

	// Vec3 Ƃ̐
	//  { v *= m } == { v = v * m } != { v = m * v }
	friend Vec3& operator*=( Vec3& v , const Mat4& m );
	friend Vec3 operator*( const Vec3& v , const Mat4& m );

	friend Vec3 operator*( const Mat4& m , const Vec3& v );
};



inline float& Mat4::operator[](size_t idx)
{
	return at(idx);
}

inline const float& Mat4::operator[](size_t idx) const
{
	return at(idx);
}

inline float& Mat4::operator()(size_t idx)
{
	return at(idx);
}

inline const float& Mat4::operator()(size_t idx) const 
{
	return at(idx);
}

inline float& Mat4::operator()(size_t idx_row, size_t idx_col)
{
	return at( idx_row , idx_col );
}

inline const float& Mat4::operator()(size_t idx_row, size_t idx_col) const
{
	return at( idx_row , idx_col );
}

inline float& Mat4::at(size_t idx)
{
	return ary()[idx];
}

inline const float& Mat4::at(size_t idx) const
{
	return ary()[idx];
}

inline float& Mat4::at(size_t idx_row, size_t idx_col)
{
	return ary()[ idx_col + idx_row * WIDTH ];
}

inline const float& Mat4::at(size_t idx_row, size_t idx_col) const
{
	return ary()[ idx_col + idx_row * WIDTH ];
}


inline void Mat4::set( const Mat4& m )
{
	for( size_t i = 0 ; i < NUM_ELEMENTS ; ++i )
		this->at(i) = m.at(i);
}

inline void Mat4::set( const float* _v )
{
	for( size_t i = 0 ; i < NUM_ELEMENTS ; ++i )
		this->at(i) = _v[i];
}

inline void Mat4::set( float _v00 , float _v01 , float _v02 , float _v03 ,
                       float _v10 , float _v11 , float _v12 , float _v13 ,
                       float _v20 , float _v21 , float _v22 , float _v23 ,
                       float _v30 , float _v31 , float _v32 , float _v33 )
{
	m00 = _v00;   m01 = _v01;   m02 = _v02;   m03 = _v03;
	m10 = _v10;   m11 = _v11;   m12 = _v12;   m13 = _v13;
	m20 = _v20;   m21 = _v21;   m22 = _v22;   m23 = _v23;
	m30 = _v30;   m31 = _v31;   m32 = _v32;   m33 = _v33;
}

inline Mat4& Mat4::operator=( const Mat4& m )
{
	set(m);
	return *this;
}


inline void Mat4::fill( float _v )
{
	for( size_t i = 0 ; i < NUM_ELEMENTS ; ++i )
		this->at(i) = _v;
}


inline void Mat4::set_identity(void)
{
	set( identity() );
}

inline void Mat4::set_zero(void)
{
	set( zero() );
}

inline const Mat4& Mat4::identity(void)
{
	static const float v[NUM_ELEMENTS]
		= { 1.0f , 0.0f , 0.0f , 0.0f ,
		    0.0f , 1.0f , 0.0f , 0.0f ,
		    0.0f , 0.0f , 1.0f , 0.0f ,
		    0.0f , 0.0f , 0.0f , 1.0f };

	static const Mat4 m(v);
	return m;
}

inline const Mat4& Mat4::zero(void)
{
	static const float v[NUM_ELEMENTS]
		= { 0.0f , 0.0f , 0.0f , 0.0f ,
		    0.0f , 0.0f , 0.0f , 0.0f ,
		    0.0f , 0.0f , 0.0f , 0.0f ,
		    0.0f , 0.0f , 0.0f , 0.0f };

	static const Mat4 m(v);
	return m;
}


inline void Mat4::transpose(void)
{
	(std::swap)( m01 , m10 );
	(std::swap)( m02 , m20 );
	(std::swap)( m03 , m30 );
	(std::swap)( m12 , m21 );
	(std::swap)( m13 , m31 );
	(std::swap)( m23 , m32 );
}

inline Mat4 Mat4::get_transpose(void) const
{
	Mat4 m = (*this);
	m.transpose();
	return m;
}


inline void Mat4::invert(void)
{
	Mat4 inv_mat;

	float det = at(0,0)*at(1,1)*at(2,2)*at(3,3) + at(0,0)*at(1,2)*at(2,3)*at(3,1) + at(0,0)*at(1,2)*at(2,1)*at(3,2)
	          + at(0,1)*at(1,0)*at(2,3)*at(3,2) + at(0,1)*at(1,2)*at(2,0)*at(3,3) + at(0,1)*at(1,2)*at(2,2)*at(3,0)
	          + at(0,2)*at(1,0)*at(2,1)*at(3,3) + at(0,2)*at(1,1)*at(2,3)*at(3,0) + at(0,2)*at(1,2)*at(2,0)*at(3,1)
	          + at(0,3)*at(1,0)*at(2,2)*at(3,1) + at(0,3)*at(1,1)*at(2,0)*at(3,2) + at(0,3)*at(1,1)*at(2,1)*at(3,0)
	          - at(0,0)*at(1,1)*at(2,3)*at(3,2) - at(0,0)*at(1,2)*at(2,1)*at(3,3) - at(0,0)*at(1,2)*at(2,2)*at(3,1)
	          - at(0,1)*at(1,0)*at(2,2)*at(3,3) - at(0,1)*at(1,2)*at(2,3)*at(3,0) - at(0,1)*at(1,2)*at(2,0)*at(3,2)
	          - at(0,2)*at(1,0)*at(2,3)*at(3,1) - at(0,2)*at(1,1)*at(2,0)*at(3,3) - at(0,2)*at(1,2)*at(2,1)*at(3,0)
	          - at(0,3)*at(1,0)*at(2,1)*at(3,2) - at(0,3)*at(1,1)*at(2,2)*at(3,0) - at(0,3)*at(1,1)*at(2,0)*at(3,1);

	if( det == 0.0f )
	{
		(*this) = inv_mat;
		return;
	}

	float det_inv = 1.0f / det;

	inv_mat(0,0) = ( at(1,1)*at(2,2)*at(3,3) + at(1,2)*at(2,3)*at(3,1) + at(1,3)*at(2,1)*at(3,2) - at(1,1)*at(2,3)*at(3,2) - at(1,2)*at(2,1)*at(3,3) - at(1,3)*at(2,2)*at(3,1) ) * det_inv;
	inv_mat(0,1) = ( at(0,1)*at(2,3)*at(3,2) + at(0,2)*at(2,1)*at(3,3) + at(0,3)*at(2,2)*at(3,1) - at(0,1)*at(2,2)*at(3,3) - at(0,2)*at(2,3)*at(3,1) - at(0,3)*at(2,1)*at(3,2) ) * det_inv;
	inv_mat(0,2) = ( at(0,1)*at(1,2)*at(3,3) + at(0,2)*at(1,3)*at(3,1) + at(0,3)*at(1,1)*at(3,2) - at(0,1)*at(1,3)*at(3,2) - at(0,2)*at(1,1)*at(3,3) - at(0,3)*at(1,2)*at(3,1) ) * det_inv;
	inv_mat(0,3) = ( at(0,1)*at(1,3)*at(2,2) + at(0,2)*at(1,1)*at(2,3) + at(0,3)*at(1,2)*at(2,1) - at(0,1)*at(1,2)*at(2,3) - at(0,2)*at(1,3)*at(2,1) - at(0,3)*at(1,1)*at(2,2) ) * det_inv;
	inv_mat(1,0) = ( at(1,0)*at(2,3)*at(3,2) + at(1,2)*at(2,0)*at(3,3) + at(1,3)*at(2,2)*at(3,0) - at(1,0)*at(2,2)*at(3,3) - at(1,2)*at(2,3)*at(3,0) - at(1,3)*at(2,0)*at(3,2) ) * det_inv;
	inv_mat(1,1) = ( at(0,0)*at(2,2)*at(3,3) + at(0,2)*at(2,3)*at(3,0) + at(0,3)*at(2,0)*at(3,2) - at(0,0)*at(2,3)*at(3,2) - at(0,2)*at(2,0)*at(3,3) - at(0,3)*at(2,2)*at(3,0) ) * det_inv;
	inv_mat(1,2) = ( at(0,0)*at(1,3)*at(3,2) + at(0,2)*at(1,0)*at(3,3) + at(0,3)*at(1,2)*at(3,0) - at(0,0)*at(1,2)*at(3,3) - at(0,2)*at(1,3)*at(3,0) - at(0,3)*at(1,0)*at(3,2) ) * det_inv;
	inv_mat(1,3) = ( at(0,0)*at(1,2)*at(2,3) + at(0,2)*at(1,3)*at(2,0) + at(0,3)*at(1,0)*at(2,2) - at(0,0)*at(1,3)*at(2,2) - at(0,2)*at(1,0)*at(2,3) - at(0,3)*at(1,2)*at(2,0) ) * det_inv;
	inv_mat(2,0) = ( at(1,0)*at(2,1)*at(3,3) + at(1,1)*at(2,3)*at(3,0) + at(1,3)*at(2,0)*at(3,1) - at(1,0)*at(2,3)*at(3,1) - at(1,1)*at(2,0)*at(3,3) - at(1,3)*at(2,1)*at(3,0) ) * det_inv;
	inv_mat(2,1) = ( at(0,0)*at(2,3)*at(3,1) + at(0,1)*at(2,0)*at(3,3) + at(0,3)*at(2,1)*at(3,0) - at(0,0)*at(2,1)*at(3,3) - at(0,1)*at(2,3)*at(3,0) - at(0,3)*at(2,0)*at(3,1) ) * det_inv;
	inv_mat(2,2) = ( at(0,0)*at(1,1)*at(3,3) + at(0,1)*at(1,3)*at(3,0) + at(0,3)*at(1,0)*at(3,1) - at(0,0)*at(1,3)*at(3,1) - at(0,1)*at(1,0)*at(3,3) - at(0,3)*at(1,1)*at(3,0) ) * det_inv;
	inv_mat(2,3) = ( at(0,0)*at(1,3)*at(2,1) + at(0,1)*at(1,0)*at(2,3) + at(0,3)*at(1,1)*at(2,0) - at(0,0)*at(1,1)*at(2,3) - at(0,1)*at(1,3)*at(2,0) - at(0,3)*at(1,0)*at(2,1) ) * det_inv;
	inv_mat(3,0) = ( at(1,0)*at(2,2)*at(3,1) + at(1,1)*at(2,0)*at(3,2) + at(1,2)*at(2,1)*at(3,0) - at(1,0)*at(2,1)*at(3,2) - at(1,1)*at(2,2)*at(3,0) - at(1,2)*at(2,0)*at(3,1) ) * det_inv;
	inv_mat(3,1) = ( at(0,0)*at(2,1)*at(3,2) + at(0,1)*at(2,2)*at(3,0) + at(0,2)*at(2,0)*at(3,1) - at(0,0)*at(2,2)*at(3,1) - at(0,1)*at(2,0)*at(3,2) - at(0,2)*at(2,1)*at(3,0) ) * det_inv;
	inv_mat(3,2) = ( at(0,0)*at(1,2)*at(3,1) + at(0,1)*at(1,0)*at(3,2) + at(0,2)*at(1,1)*at(3,0) - at(0,0)*at(1,1)*at(3,2) - at(0,1)*at(1,2)*at(3,0) - at(0,2)*at(1,0)*at(3,1) ) * det_inv;
	inv_mat(3,3) = ( at(0,0)*at(1,1)*at(2,2) + at(0,1)*at(1,2)*at(2,0) + at(0,2)*at(1,0)*at(2,1) - at(0,0)*at(1,2)*at(2,1) - at(0,1)*at(1,0)*at(2,2) - at(0,2)*at(1,1)*at(2,0) ) * det_inv;

	(*this) = inv_mat;
}

inline Mat4 Mat4::get_invert(void) const
{
	Mat4 m = (*this);
	m.invert();
	return m;
}


inline Mat4 Mat4::translate( const Vec3& v )
{
	Mat4 m;
	m.set_translate(v);
	return m;
}

inline Mat4 Mat4::translate( float x , float y , float z )
{
	Mat4 m;
	m.set_translate(x, y, z);
	return m;
}

inline void Mat4::set_translate( const Vec3& v )
{
	set_translate(v.x, v.y, v.z);
}

inline void Mat4::set_translate( float x , float y , float z )
{
	set( 1.0f , 0.0f , 0.0f , 0.0f ,
	     0.0f , 1.0f , 0.0f , 0.0f ,
	     0.0f , 0.0f , 1.0f , 0.0f ,
	     x    , y    , z    , 1.0f );
}


inline Mat4 Mat4::rotate( const Vec3& axis , float angle )
{
	Mat4 m;
	m.set_rotate(axis, angle);
	return m;
}

inline Mat4 Mat4::rotate_x( float angle )
{
	Mat4 m;
	m.set_rotate_x(angle);
	return m;
}

inline Mat4 Mat4::rotate_y( float angle )
{
	Mat4 m;
	m.set_rotate_y(angle);
	return m;
}

inline Mat4 Mat4::rotate_z( float angle )
{
	Mat4 m;
	m.set_rotate_z(angle);
	return m;
}

inline void Mat4::set_rotate( const Vec3& axis , float angle )
{
	float c = cos(angle)  , s = sin(angle);
	float mc = 1.0f - c ;
	float ax = axis.x ;  float ay = axis.y ;  float az = axis.z ;
	set( ( ax * ax * mc + c      ) , ( ay * ax * mc + az * s ) , ( az * ax * mc - ay * s ) , 0.0f ,
	     ( ax * ay * mc - az * s ) , ( ay * ay * mc + c      ) , ( az * ay * mc + ax * s ) , 0.0f ,
	     ( ax * az * mc + ay * s ) , ( ay * az * mc - ax * s ) , ( az * az * mc + c      ) , 0.0f ,
	     0.0f                      , 0.0f                      , 0.0f                      , 1.0f );
}

inline void Mat4::set_rotate_x( float angle )
{
	float c = cos(angle)  , s = sin(angle);
	set( 1.0f , 0.0f , 0.0f , 0.0f ,
	     0.0f , c    , s    , 0.0f ,
	     0.0f , -s   , c    , 0.0f ,
	     0.0f , 0.0f , 0.0f , 1.0f );
}

inline void Mat4::set_rotate_y( float angle )
{
	float c = cos(angle)  , s = sin(angle);
	set( c    , 0.0f , -s   , 0.0f ,
	     0.0f , 1.0f , 0.0f , 0.0f ,
	     s    , 0.0f , c    , 0.0f ,
	     0.0f , 0.0f , 0.0f , 1.0f );
}

inline void Mat4::set_rotate_z( float angle )
{
	float c = cos(angle)  , s = sin(angle);
	set( c    , s    , 0.0f , 0.0f ,
	     -s   , c    , 0.0f , 0.0f ,
	     0.0f , 0.0f , 1.0f , 0.0f ,
	     0.0f , 0.0f , 0.0f , 1.0f );
}


inline Mat4 Mat4::scale( float scale_xyz )
{
	Mat4 m;
	m.set_scale( scale_xyz );
	return m;
}

inline Mat4 Mat4::scale( const Vec3& scale_xyz )
{
	Mat4 m;
	m.set_scale( scale_xyz );
	return m;
}

inline Mat4 Mat4::scale( float scale_x , float scale_y , float scale_z )
{
	Mat4 m;
	m.set_scale( scale_x , scale_y , scale_z );
	return m;
}

inline void Mat4::set_scale( float scale_xyz )
{
	set_scale(scale_xyz, scale_xyz, scale_xyz);
}

inline void Mat4::set_scale( const Vec3& scale_xyz )
{
	set_scale(scale_xyz.x, scale_xyz.y, scale_xyz.z);
}

inline void Mat4::set_scale( float scale_x , float scale_y , float scale_z )
{
	set( scale_x , 0.0f    , 0.0f    , 0.0f ,
	     0.0f    , scale_y , 0.0f    , 0.0f ,
	     0.0f    , 0.0f    , scale_z , 0.0f ,
	     0.0f    , 0.0f    , 0.0f    , 1.0f );
}


inline void Mat4::set_row( size_t row_idx , float v0 , float v1 , float v2 , float v3 )
{
	at( row_idx , 0 ) = v0;
	at( row_idx , 1 ) = v1;
	at( row_idx , 2 ) = v2;
	at( row_idx , 3 ) = v3;
}

inline void Mat4::set_row( size_t row_idx , const Vec3& v )
{
	set_row( row_idx , v.x , v.y , v.z , 0.0f );
}

inline void Mat4::get_row( size_t row_idx , float& v0 , float& v1 , float& v2 ) const
{
	v0 = at( row_idx , 0 );
	v1 = at( row_idx , 1 );
	v2 = at( row_idx , 2 );
}

inline void Mat4::get_row( size_t row_idx , float& v0 , float& v1 , float& v2 , float& v3 ) const
{
	v0 = at( row_idx , 0 );
	v1 = at( row_idx , 1 );
	v2 = at( row_idx , 2 );
	v3 = at( row_idx , 3 );
}

inline void Mat4::get_row( size_t row_idx , Vec3& v ) const
{
	get_row( row_idx , v.x , v.y , v.z );
}



inline void Mat4::set_col( size_t col_idx , float v0 , float v1 , float v2 , float v3 )
{
	at( 0 , col_idx ) = v0;
	at( 1 , col_idx ) = v1;
	at( 2 , col_idx ) = v2;
	at( 3 , col_idx ) = v3;
}

inline void Mat4::set_col( size_t col_idx , const Vec3& v )
{
	set_col( col_idx , v.x , v.y , v.z , 0.0f );
}

inline void Mat4::get_col( size_t col_idx , float& v0 , float& v1 , float& v2 ) const
{
	v0 = at( 0 , col_idx );
	v1 = at( 1 , col_idx );
	v2 = at( 2 , col_idx );
}

inline void Mat4::get_col( size_t col_idx , float& v0 , float& v1 , float& v2 , float& v3 ) const
{
	v0 = at( 0 , col_idx );
	v1 = at( 1 , col_idx );
	v2 = at( 2 , col_idx );
	v3 = at( 3 , col_idx );
}

inline void Mat4::get_col( size_t col_idx , Vec3& v ) const
{
	get_col( col_idx , v.x , v.y , v.z );
}


inline void Mat4::set_ortho_trans( const Vec3& ex , const Vec3& ey , const Vec3& ez )
{
	set_col( 0 , ex.x , ex.y , ex.z , 0.0f );
	set_col( 1 , ey.x , ey.y , ey.z , 0.0f );
	set_col( 2 , ez.x , ez.y , ez.z , 0.0f );
	set_col( 3 , 0.0f , 0.0f , 0.0f , 1.0f );
}

inline void Mat4::set_ortho_trans_rev( const Vec3& ex , const Vec3& ey , const Vec3& ez )
{
	set_col( 0 , ex.x , ey.x , ex.z , 0.0f );
	set_col( 1 , ex.y , ey.y , ey.z , 0.0f );
	set_col( 2 , ex.z , ey.z , ez.z , 0.0f );
	set_col( 3 , 0.0f , 0.0f , 0.0f , 1.0f );
}

inline bool Mat4::operator==( const Mat4& m ) const
{
	for( size_t i = 0 ; i < NUM_ELEMENTS ; ++i )
		if( m.at(i) != at(i) ) return false;

	return true;
}

inline bool Mat4::operator!=( const Mat4& m ) const
{
	for( size_t i = 0 ; i < NUM_ELEMENTS ; ++i )
		if( m.at(i) != at(i) ) return false;

	return true;
}


inline Mat4& Mat4::operator+=( const Mat4& m )
{
	for( size_t i = 0 ; i < NUM_ELEMENTS ; ++i )
		at(i) += m[i];

	return *this;
}

inline Mat4& Mat4::operator-=( const Mat4& m )
{
	for( size_t i = 0 ; i < NUM_ELEMENTS ; ++i )
		at(i) -= m[i];

	return *this;
}

inline Mat4& Mat4::operator*=( float val )
{
	for( size_t i = 0 ; i < NUM_ELEMENTS ; ++i )
		at(i) *= val;

	return *this;
}

inline Mat4& Mat4::operator/=( float val )
{
	for( size_t i = 0 ; i < NUM_ELEMENTS ; ++i )
		at(i) /= val;

	return *this;
}

inline Mat4& Mat4::operator*=( const Mat4& m )
{
	Mat4 tmp;

	tmp.m00 = this->m00 * m.m00 + this->m01 * m.m10 + this->m02 * m.m20 + this->m03 * m.m30;
	tmp.m10 = this->m10 * m.m00 + this->m11 * m.m10 + this->m12 * m.m20 + this->m13 * m.m30;
	tmp.m20 = this->m20 * m.m00 + this->m21 * m.m10 + this->m22 * m.m20 + this->m23 * m.m30;
	tmp.m30 = this->m30 * m.m00 + this->m31 * m.m10 + this->m32 * m.m20 + this->m33 * m.m30;

	tmp.m01 = this->m00 * m.m01 + this->m01 * m.m11 + this->m02 * m.m21 + this->m03 * m.m31;
	tmp.m11 = this->m10 * m.m01 + this->m11 * m.m11 + this->m12 * m.m21 + this->m13 * m.m31;
	tmp.m21 = this->m20 * m.m01 + this->m21 * m.m11 + this->m22 * m.m21 + this->m23 * m.m31;
	tmp.m31 = this->m30 * m.m01 + this->m31 * m.m11 + this->m32 * m.m21 + this->m33 * m.m31;

	tmp.m02 = this->m00 * m.m02 + this->m01 * m.m12 + this->m02 * m.m22 + this->m03 * m.m32;
	tmp.m12 = this->m10 * m.m02 + this->m11 * m.m12 + this->m12 * m.m22 + this->m13 * m.m32;
	tmp.m22 = this->m20 * m.m02 + this->m21 * m.m12 + this->m22 * m.m22 + this->m23 * m.m32;
	tmp.m32 = this->m30 * m.m02 + this->m31 * m.m12 + this->m32 * m.m22 + this->m33 * m.m32;

	tmp.m03 = this->m00 * m.m03 + this->m01 * m.m13 + this->m02 * m.m23 + this->m03 * m.m33;
	tmp.m13 = this->m10 * m.m03 + this->m11 * m.m13 + this->m12 * m.m23 + this->m13 * m.m33;
	tmp.m23 = this->m20 * m.m03 + this->m21 * m.m13 + this->m22 * m.m23 + this->m23 * m.m33;
	tmp.m33 = this->m30 * m.m03 + this->m31 * m.m13 + this->m32 * m.m23 + this->m33 * m.m33;

	(*this) = tmp;

	return *this;
}



inline Mat4 operator+( const Mat4& m1 , const Mat4& m2 )
{
	Mat4 ret = m1;
	ret += m1;
	return ret;
}

inline Mat4 operator-( const Mat4& m1 , const Mat4& m2 )
{
	Mat4 ret = m1;
	ret -= m1;
	return ret;
}

inline Mat4 operator*( const Mat4& m1 , const Mat4& m2 )
{
	Mat4 ret = m1;
	ret *= m2;
	return ret;
}

inline Mat4 operator*( const Mat4& m1 , float val )
{
	Mat4 ret = m1;
	ret *= val;
	return ret;
}

inline Mat4 operator*( float val , const Mat4& m1 )
{
	Mat4 ret = m1;
	ret *= val;
	return ret;
}

inline Mat4 operator/( const Mat4& m1 , float val )
{
	Mat4 ret = m1;
	ret /= val;
	return ret;
}

inline Vec3& operator*=( Vec3& v , const Mat4& m )
{
	Vec3 tmp = v;

	v.x = tmp.x * m.m00 + tmp.y * m.m10 + tmp.z * m.m20 + m.m30;
	v.y = tmp.x * m.m01 + tmp.y * m.m11 + tmp.z * m.m21 + m.m31;
	v.z = tmp.x * m.m02 + tmp.y * m.m12 + tmp.z * m.m22 + m.m32;

	// W->ʏ3DWւ̕ϊ
	float w = tmp.x * m.m03 + tmp.y * m.m13 + tmp.z * m.m23 + m.m33;
	v /= w;

	return v;
}

inline Vec3 operator*( const Vec3& v , const Mat4& m )
{
	Vec3 ret = v;
	ret *= m;
	return ret;
}

inline Vec3 operator*( const Mat4& m , const Vec3& v )
{
	Vec3 ret;

	ret.x = v.x * m.m00 + v.y * m.m01 + v.z * m.m02 + m.m03;
	ret.y = v.x * m.m10 + v.y * m.m11 + v.z * m.m12 + m.m13;
	ret.z = v.x * m.m20 + v.y * m.m21 + v.z * m.m22 + m.m23;

	// W->ʏ3DWւ̕ϊ
	float w = v.x * m.m30 + v.y * m.m31 + v.z * m.m32 + m.m33;
	ret /= w;

	return ret;
}


}
