#pragma once

#include "GLKST_API.h"

#include "KstStrokeChar.h"

#include <string>


namespace gk
{


class Vec3;
class Mat4;
class KstFontMap;


//! \Xg[NXg
class GLKST_API KstString
{
public:
	KstString(void);
	KstString(const std::string& str);
	KstString(const char* str);
	KstString(const std::string& str, const KstFontMap& font);
	KstString(const char* str, const KstFontMap& font);

	void Clear(void);

	// ǉ
	void AddStroke(KstStrokeChar& c);

	// 擾
	size_t GetStrokeCount(void) const;

	// 擾
	KstStrokeChar& GetStroke(size_t i);
	const KstStrokeChar& GetStroke(size_t i) const;

	// ςݕ̕\̃TCY擾
	float GetWidth(void) const;
	float GetHeight(void) const;

	// WtHg當̃Xg[N𐶐
	// tHgɕsꍇ()Ȃ, sKstExceptionX[.
	void SetStr(const std::string& s);
	void SetStr(const char* s);

	// w肳ꂽtHg當̃Xg[N𐶐
	// tHgɕsꍇ()Ȃ, sKstExceptionX[.
	void SetStr(const std::string& s, const KstFontMap& font);
	void SetStr(const char* s, const KstFontMap& font);

	// \
	// 1̃XP[1ł̃TCY, [hWl
	// SpȂ32x32, pȂ16x32,
	// Ԃ̌Ԃ͏c2ŕ\.
	void Draw(void) const;
	void Draw(const Vec3& position) const;
	void Draw(const Vec3& position, const Vec3& euler_rot) const;
	void Draw(const Vec3& position, const Vec3& euler_rot, float scale) const;
	void Draw(const Mat4& transform) const;

	// ɊOڂ钷`\
	void DrawBound(void) const;
	void DrawBound(const Vec3& position) const;
	void DrawBound(const Vec3& position, const Vec3& euler_rot) const;
	void DrawBound(const Vec3& position, const Vec3& euler_rot, float scale) const;
	void DrawBound(const Mat4& transform) const;

private:
	static void CreateStroke(const std::string& s, KstString& stroke);
	static void CreateStroke(const char* s, KstString& stroke);
	static void CreateStroke(const std::string& s, const KstFontMap& font, KstString& stroke);
	static void CreateStroke(const char* s, const KstFontMap& font, KstString& stroke);

	void DrawStringMain(void) const;
	void DrawBoundMain(void) const;
	void DrawChar(const KstStrokeChar& stroke) const;

	void SetTransform(const Vec3& position, const Vec3& euler_rot, float scale) const;
	void SetTransform(const Mat4& transform) const;


private:
	std::vector<KstStrokeChar> m_Str;
	float m_Width;
	float m_Height;
};


}
