#include "stdafx.h"
#include "KstStrokeChar.h"

#include "KstFontMap.h"
#include "KstException.h"

#include <assert.h>

#include <iomanip>
#include <sstream>


namespace gk
{


	void KstStrokeChar::Clear(void)
{
	m_Segments.clear();
}


bool KstStrokeChar::IsSinglebyteChar(void) const
{
	return (m_CharType == SINGLEBYTE);
}

bool KstStrokeChar::IsMultibyteChar(void) const
{
	return (m_CharType == MULTIBYTE);
}

bool KstStrokeChar::IsNewline(void) const
{
	return (m_CharType == NEWLINE);
}


//! 1̃Xg[N𐶐
void KstStrokeChar::Create(const int charCode, bool IsMultibyte, const KstFontMap& font)
{
	// tHgĂȂꍇɔ
	_ASSERTE( font.HasBuffer() );
	if( !font.HasBuffer() )
	{
		throw KstException( "Font is not initialized." );
	}

	Clear();

	if( IsMultibyte )
		m_CharType = KstStrokeChar::MULTIBYTE;
	else
		m_CharType = KstStrokeChar::SINGLEBYTE;

	// 20(Hex)       : Terminator
	//   21-26,28-3F : Move to X=0--29
	//   40-5B,5E-5F : Draw to X=0--29
	//   60-7D       : Next X to 0--29
	//   7E,A1-BF    : Move to Y=0--31
	//   C0-DF       : Draw to Y=0--31

	// R[hXg[Nf[^擾
	const std::string* stroke_str = font.GetStrokeScript(charCode);

	// sȕR[hw肳ꂽꍇɔ.
	assert( stroke_str != NULL );

	if( stroke_str == NULL )
	{
		std::ostringstream s;
		s << "Charcode(0x" << std::setw(4) << std::setfill('0') << std::hex << charCode << ") is not found.";
		throw KstException( s.str() );
	}

	Point2i pCurrentPos(0, 0);
	Point2i pDrawTo(0,0);
	for (size_t i = 0; i < stroke_str->size(); i++)
	{
		bool IsStrokeEnd = false;
		unsigned char dat = (unsigned char)stroke_str->at(i);

		//Move to X
		if (dat >= 0x21 && dat <= 0x26)
		{
			pCurrentPos.x = dat - 0x21;
			pDrawTo.x = pCurrentPos.x;
		}
		else if (dat >= 0x28 && dat <= 0x3F)
		{
			pCurrentPos.x = dat - 0x22;
			pDrawTo.x = pCurrentPos.x;
		}
		else
		{
			//Move to Y
			if (dat == 0x7E)
			{
				pCurrentPos.y = 0;
				pDrawTo.y = pCurrentPos.y;
			}
			else if (dat >= 0xA1 && dat <= 0xBF)
			{
				pCurrentPos.y = dat - 0xA0;
				pDrawTo.y = pCurrentPos.y;
			}
			else
			{
				//Next X
				if (dat >= 0x60 && dat <= 0x7D)
				{
					pDrawTo.x = dat - 0x60;
				}
				else
				{
					//Draw to X
					if (dat >= 0x40 && dat <= 0x5B)
					{
						pDrawTo.x = dat - 0x40;
						IsStrokeEnd = true;
					}
					else if (dat >= 0x5E && dat <= 0x5F)
					{
						pDrawTo.x = dat - 0x42;
						IsStrokeEnd = true;
					}
					else
					{
						//Draw to Y
						if (dat >= 0xC0 && dat <= 0xDF)
						{
							pDrawTo.y = dat - 0xC0;
							IsStrokeEnd = true;
						}
					}
				}
			}
		}

		if (IsStrokeEnd)
		{
			m_Segments.push_back( Segment2i(pCurrentPos, pDrawTo) );
			pCurrentPos = pDrawTo;
		}
	}
}


//! s𐶐
void KstStrokeChar::CreateNewline(void)
{
	Clear();

	m_CharType = NEWLINE;
}


KstStrokeChar::CHAR_TYPES KstStrokeChar::GetCharType(void) const
{
	return m_CharType;
}


Segment2i& KstStrokeChar::GetSegment(size_t idx)
{
	return m_Segments[idx];
}

const Segment2i& KstStrokeChar::GetSegment(size_t idx) const
{
	return m_Segments[idx];
}

size_t KstStrokeChar::GetNumSegments(void) const
{
	return m_Segments.size();
}


}
