#pragma once

#include "GLKST_API.h"

#include <vector>

#include "KstPrimitives.h"


namespace gk
{


class KstFontMap;


//! 1킷Xg[N.
struct GLKST_API KstStrokeChar
{
public:
	enum CHAR_TYPES
	{
		NONE       = 0,
		SINGLEBYTE = 1,
		MULTIBYTE  = 2,
		NEWLINE    = 3,
	};

public:
	KstStrokeChar(void)
		: m_CharType(SINGLEBYTE)
	{
	}

	void Clear(void);

	bool IsSinglebyteChar(void) const;
	bool IsMultibyteChar(void) const;
	bool IsNewline(void) const;

	void Create(const int charCode, bool IsMultibyte, const KstFontMap& font);
	void CreateNewline(void);

	CHAR_TYPES GetCharType(void) const;

	Segment2i& GetSegment(size_t idx);
	const Segment2i& GetSegment(size_t idx) const;
	size_t GetNumSegments(void) const;


private:
	std::vector<Segment2i> m_Segments;
	CHAR_TYPES             m_CharType;
};


}
