#include "stdafx.h"
#include <stdlib.h>

#include <gl/openglut.h>

#include <GLKST/GLKST.h>

#define _USE_MATH_DEFINES
#include <math.h>



int g_Width  = 640;
int g_Height = 480;

int lx = 0;
int ly = 0;

int g_button = 0;



void DrawAxis(void)
{
	double l = 100;

	glBegin(GL_LINES);
	glColor3d(1,0,0);  glVertex3d(0,0,0);  glVertex3d(l,0,0);
	glColor3d(0,1,0);  glVertex3d(0,0,0);  glVertex3d(0,l,0);
	glColor3d(0,0,1);  glVertex3d(0,0,0);  glVertex3d(0,0,l);
	glEnd();
}


void DrawObjects(void)
{
	glPushAttrib( GL_POINT_BIT | GL_LINE_BIT | GL_POINT_BIT | GL_ENABLE_BIT );

	glDisable(GL_LIGHTING);

	glLineWidth(3.0f);
	DrawAxis();

	glLineWidth(3.0f);
	glColor3d(0,1,1);
	gk::KstString s1( "͂[E\n\t{Ή\nsł\nabcABC123!?" );
	s1.Draw();
	s1.DrawBound();

	glLineWidth(1.0f);
	glColor3d(0,1,1);
	gk::KstString s2( "(E_E)" );
	s2.Draw( gk::Vec3(-60 , -60 , 0) , gk::Vec3(0 , 0 , 45) , 0.5 );
	s2.DrawBound( gk::Vec3(-60 , -60 , 0) , gk::Vec3(0 , 0 , 45) , 0.5 );

	glColor3d(1,0,1);
	glLineWidth(3.0f);
	gk::Mat4 trans = gk::Mat4::identity();
	trans *= gk::Mat4::scale(0.5f);
	trans *= gk::Mat4::rotate_z(M_PI*0.25);
	trans *= gk::Mat4::translate(-60 , -60 , 0);
	s2.Draw(trans);

	glPopAttrib();
}


void display(void)
{
	glViewport( 0 , 0 , g_Width , g_Height );

	glClearColor(0.2f, 0.2f, 0.2f, 1.0f);
	glClear(GL_COLOR_BUFFER_BIT|GL_DEPTH_BUFFER_BIT);

	glMatrixMode(GL_PROJECTION);
	glLoadIdentity();
	//glOrtho( -1 , 1 , -1 , 1 , 0.01 , 5 );
	gluPerspective(45.0, (double)g_Width/(double)g_Height, 0.1 , 1000 );

	glMatrixMode(GL_MODELVIEW);
	glPushMatrix();

	float m[16];
	glGetFloatv( GL_MODELVIEW_MATRIX , m );
	glLoadIdentity();

	gluLookAt( 0.0 , 0.0 , 400.0 , 0.0 , 0.0 , 0.0 , 0.0 , 1.0 , 0.0 );

	glMultMatrixf(m);

	DrawObjects();

	glPopMatrix();

	glutSwapBuffers();
}


void resize(int w, int h)
{
	g_Width  = w;
	g_Height = h;
	glViewport( 0 , 0 , w , h );
}


void mouse(int button, int state, int x, int y)
{
	g_button = button;
}

void motion(int x, int y)
{
	bool bShift = ((glutGetModifiers() & GLUT_ACTIVE_SHIFT) != 0);
	bool bAlt   = ((glutGetModifiers() & GLUT_ACTIVE_SHIFT) != 0);
	bool bCtrl  = ((glutGetModifiers() & GLUT_ACTIVE_SHIFT) != 0);

	int dx = x - lx;
	int dy = y - ly;
	lx = x;
	ly = y;

	glMatrixMode(GL_MODELVIEW);

	if( g_button == 0 )
	{
		float m[16];
		glGetFloatv( GL_MODELVIEW_MATRIX , m );

		glLoadIdentity();
		glTranslated( (double)dx , -(double)dy , 0 );

		glMultMatrixf( m );

		glutPostRedisplay();
		return;
	}
	else if( g_button == 1 )
	{
		int d = 100 + dy;
		d = (std::min)( d , 110 );
		d = (std::max)( d , 90 );
		float df = (float)d / 100.0f;
		glScalef( df , df , df );

		glutPostRedisplay();
		return;
	}
	else if( g_button == 2 )
	{
		float m[16];
		glGetFloatv( GL_MODELVIEW_MATRIX , m );

		glLoadIdentity();

		glRotated(dx, 0, 1, 0);
		glRotated(dy, 1, 0, 0);

		glMultMatrixf( m );

		glutPostRedisplay();
		return;
	}
}

void passive_motion(int x, int y)
{
	int dx = x - lx;
	int dy = y - ly;
	lx = x;
	ly = y;
}

void keyboard(unsigned char key, int x, int y)
{
	switch (key)
	{
	case 'q':
	case 'Q':
	case '\033':  /* '\033'  ESC  ASCII R[h */
		exit(0);
	default:
	break;
	}
}


void initEvents(void)
{
	glutDisplayFunc(display);
	glutReshapeFunc(resize);
	glutMouseFunc(mouse);
	glutMotionFunc(motion);
	glutPassiveMotionFunc(passive_motion);
	glutKeyboardFunc(keyboard);
}

void initGl(void)
{
	glEnable(GL_DEPTH_TEST);

	glMatrixMode(GL_PROJECTION);
	glLoadIdentity();

	glMatrixMode(GL_MODELVIEW);
	glLoadIdentity();
}

int _tmain(int argc, _TCHAR* argv[])
{
	gk::KstDefaultFont::Initialize();

	glutInitWindowPosition(100, 100);
	glutInitWindowSize(g_Width, g_Height);
	glutInit(&argc, argv);

	glutInitDisplayMode( GLUT_RGBA | GLUT_DOUBLE );
	glutCreateWindow(argv[0]);

	initGl();

	initEvents();

	glutMainLoop();
	return 0;
}
