/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include	<sys/types.h>
#include	<sys/time.h>
#include	<sys/resource.h>
#include	<unistd.h>
#include	"utils.h"
#include	"limits.h"

void
_print_rlim(int type)
{
int er;
struct rlimit r;
	er = getrlimit(type,&r);
	if ( er < 0 ) {
		fprintf(stderr,"%i\t",type);
		perror("");
	}
	else {
		fprintf(stderr,"%i :\t%i - %i\n",
			type,
			r.rlim_cur,
			r.rlim_max);
	}
}

unsigned int
_get_mem_size()
{
static unsigned int mem_size;
struct rlimit rr;

	if ( mem_size )
		return mem_size;
	getrlimit(RLIMIT_RSS,&rr);
	mem_size = rr.rlim_max;
	if ( mem_size > (256<<20) )
		mem_size = (256<<20);
	else if ( mem_size == 0 )
		mem_size = 1024*1024;
	return mem_size;
}
